/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.content;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletURL;
import org.apache.portals.applications.webcontent2.portlet.rewriter.MutableAttributes;
import org.apache.portals.applications.webcontent2.portlet.rewriter.WebContentRewriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DynamicWebContentRewriter
extends WebContentRewriter {
    private static final Logger log = LoggerFactory.getLogger(DynamicWebContentRewriter.class);
    private static final Pattern ONCLICK_LOCATION_PATTERN = Pattern.compile("[.]location *= *'([^']*)'");
    private static final Pattern STYLE_URL_PATTERN = Pattern.compile("url\\( *\"([^\"]*)\" *\\)");
    protected String basePortalPath;

    public String getBasePortalPath() {
        return this.basePortalPath;
    }

    public void setBasePortalPath(String basePortalPath) {
        this.basePortalPath = basePortalPath;
        if (log.isDebugEnabled()) {
            log.debug("basePortalPath: " + basePortalPath);
        }
    }

    public void setBaseUrl(String base) {
        super.setBaseUrl(base);
        if (log.isDebugEnabled()) {
            log.debug("baseUrl: " + base);
        }
    }

    public void setActionURL(PortletURL action) {
        super.setActionURL(action);
        if (log.isDebugEnabled()) {
            log.debug("actionURL: " + action);
        }
    }

    public String rewriteUrl(String url, String tag, String attribute, MutableAttributes otherAttributes) {
        String rewrittenUrl = url;
        if (tag.equalsIgnoreCase("A") && attribute.equalsIgnoreCase("href")) {
            rewrittenUrl = this.portalURL(url);
        } else if (tag.equalsIgnoreCase("FORM") && attribute.equalsIgnoreCase("action")) {
            this.getActionURL().setParameter("_AP_URL", this.webContentURL(url));
            String httpMethod = otherAttributes.getValue("method");
            if (httpMethod != null) {
                this.getActionURL().setParameter("_AP_METHOD", httpMethod);
            }
            rewrittenUrl = this.getActionURL().toString();
        } else if (attribute.equalsIgnoreCase("onclick")) {
            String javascript = url;
            StringBuilder rewrittenJavascript = new StringBuilder();
            int rewrittenIndex = 0;
            Matcher matcher = ONCLICK_LOCATION_PATTERN.matcher(javascript);
            while (matcher.find()) {
                rewrittenJavascript.append(javascript.substring(rewrittenIndex, matcher.start(1)));
                rewrittenJavascript.append(this.portalURL(matcher.group(1)));
                rewrittenIndex = matcher.end(1);
            }
            if (rewrittenIndex > 0) {
                rewrittenJavascript.append(javascript.substring(rewrittenIndex));
                rewrittenUrl = rewrittenJavascript.toString();
            }
        } else {
            rewrittenUrl = this.webContentURL(url);
        }
        if (log.isDebugEnabled()) {
            log.debug("rewriteUrl: " + url + " -> " + rewrittenUrl);
        }
        return rewrittenUrl;
    }

    public String rewriteText(String tag, String text) {
        String rewrittenText = null;
        if (tag.equalsIgnoreCase("STYLE")) {
            StringBuilder rewrittenStyle = new StringBuilder();
            int rewrittenIndex = 0;
            Matcher matcher = STYLE_URL_PATTERN.matcher(text);
            while (matcher.find()) {
                rewrittenStyle.append(text.substring(rewrittenIndex, matcher.start(1)));
                rewrittenStyle.append(this.webContentURL(matcher.group(1)));
                rewrittenIndex = matcher.end(1);
            }
            if (rewrittenIndex > 0) {
                rewrittenStyle.append(text.substring(rewrittenIndex));
                rewrittenText = rewrittenStyle.toString();
            }
        }
        if (rewrittenText != null && log.isDebugEnabled()) {
            String logText = text.replace('\n', ' ').replace('\r', ' ');
            String logRewrittenText = rewrittenText.replace('\n', ' ').replace('\r', ' ');
            log.debug("rewriteText: " + logText + " -> " + logRewrittenText);
        }
        return rewrittenText;
    }

    protected String webContentURL(String url) {
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            if (url.startsWith("/")) {
                String baseRootUrl = DynamicWebContentRewriter.baseRootURL((String)this.getBaseUrl());
                url = baseRootUrl + url.substring(1);
            } else {
                while (url.startsWith("./")) {
                    url = url.substring(2);
                }
                String baseUrl = DynamicWebContentRewriter.baseURL((String)this.getBaseUrl(), (boolean)false);
                while (url.startsWith("../")) {
                    url = url.substring(3);
                    baseUrl = DynamicWebContentRewriter.baseURL((String)baseUrl, (boolean)true);
                }
                url = baseUrl + url;
            }
        }
        return url;
    }

    protected String portalURL(String url) {
        String baseUrl;
        if (url.startsWith("http://") || url.startsWith("https://")) {
            baseUrl = DynamicWebContentRewriter.baseURL((String)this.getBaseUrl(), (boolean)false);
            if (url.startsWith(baseUrl)) {
                return url.substring(baseUrl.length());
            }
            String baseRootUrl = DynamicWebContentRewriter.baseRootURL((String)this.getBaseUrl());
            if (url.startsWith(baseRootUrl)) {
                url = url.substring(baseRootUrl.length());
                String remainingBasePath = baseUrl.substring(baseRootUrl.length());
                int remainingBasePathIndex = remainingBasePath.indexOf(47);
                while (remainingBasePathIndex != -1) {
                    url = "../" + url;
                    remainingBasePathIndex = remainingBasePath.indexOf(47, remainingBasePathIndex + 1);
                }
            }
        } else if (url.startsWith("/")) {
            baseUrl = DynamicWebContentRewriter.baseURL((String)this.getBaseUrl(), (boolean)false);
            String baseRootUrl = DynamicWebContentRewriter.baseRootURL((String)this.getBaseUrl());
            url = url.substring(1);
            int length = baseRootUrl.length();
            String remainingBasePath = length >= baseUrl.length() ? "" : baseUrl.substring(length);
            int remainingBasePathIndex = remainingBasePath.indexOf(47);
            while (remainingBasePathIndex != -1) {
                url = "../" + url;
                remainingBasePathIndex = remainingBasePath.indexOf(47, remainingBasePathIndex + 1);
            }
        } else {
            while (url.startsWith("./")) {
                url = url.substring(2);
            }
        }
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            String basePortalPath = this.getBasePortalPath();
            if (!basePortalPath.endsWith("/")) {
                basePortalPath = basePortalPath + "/";
            }
            url = basePortalPath + url;
        }
        return url;
    }

    protected static String baseURL(String baseUrl, boolean force) {
        boolean folderUrl = baseUrl.endsWith("/");
        if (!folderUrl || force) {
            int baseUrlIndex;
            int baseRootUrlIndex = baseUrl.indexOf(47);
            baseRootUrlIndex = baseUrl.indexOf(47, baseRootUrlIndex + 1);
            baseRootUrlIndex = baseUrl.indexOf(47, baseRootUrlIndex + 1);
            int n = baseUrlIndex = folderUrl ? baseUrl.lastIndexOf(47, baseUrl.length() - 2) : baseUrl.lastIndexOf(47);
            if (baseRootUrlIndex != -1 || baseUrlIndex > baseUrlIndex) {
                baseUrl = baseUrl.substring(0, baseUrlIndex + 1);
            } else if (!folderUrl) {
                baseUrl = baseUrl + "/";
            }
        }
        return baseUrl;
    }

    protected static String baseRootURL(String baseUrl) {
        int baseRootUrlIndex = baseUrl.indexOf(47);
        baseRootUrlIndex = baseUrl.indexOf(47, baseRootUrlIndex + 1);
        baseRootUrlIndex = baseUrl.indexOf(47, baseRootUrlIndex + 1);
        return (baseRootUrlIndex != -1 ? baseUrl : baseUrl.substring(0, baseRootUrlIndex)) + "/";
    }
}

