/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.prm.model;

import org.apache.jetspeed.om.portlet.GenericMetadata;
import org.apache.jetspeed.om.portlet.LocalizedField;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.portlets.JetspeedServiceLocator;
import org.apache.jetspeed.portlets.prm.LocalizedFieldBean;
import org.apache.jetspeed.portlets.prm.PortletApplicationNodeBean;
import org.apache.jetspeed.portlets.util.PortletApplicationUtils;
import org.apache.wicket.model.LoadableDetachableModel;

public class LocalizedFieldBeanModel
extends LoadableDetachableModel<LocalizedFieldBean> {
    private static final long serialVersionUID = 1L;
    private JetspeedServiceLocator locator;
    private PortletApplicationNodeBean paNodeBean;
    private String name;
    private String localeString;

    public LocalizedFieldBeanModel(JetspeedServiceLocator locator, PortletApplicationNodeBean paNodeBean, LocalizedFieldBean fieldBean) {
        super((Object)fieldBean);
        this.locator = locator;
        this.paNodeBean = paNodeBean;
        this.name = fieldBean.getName();
        this.localeString = fieldBean.getLocaleString();
    }

    protected LocalizedFieldBean load() {
        LocalizedFieldBean fieldBean = null;
        PortletApplication app = this.locator.getPortletRegistry().getPortletApplication(this.paNodeBean.getApplicationName());
        PortletDefinition def = null;
        if (this.paNodeBean.getName() != null) {
            def = PortletApplicationUtils.getPortletOrClone((PortletApplication)app, (String)this.paNodeBean.getName());
        }
        GenericMetadata metadata = def == null ? app.getMetadata() : def.getMetadata();
        for (LocalizedField field : metadata.getFields()) {
            LocalizedFieldBean tempBean = new LocalizedFieldBean(field);
            if (!this.name.equals(tempBean.getName()) || !this.localeString.equals(tempBean.getLocaleString())) continue;
            fieldBean = tempBean;
            break;
        }
        return fieldBean;
    }
}

