/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.administration.PortalAdministration;
import org.apache.jetspeed.administration.PortalConfiguration;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.page.BaseFragmentElement;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.page.FragmentDefinition;
import org.apache.jetspeed.om.page.FragmentReference;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.om.portlet.Preference;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeSet;
import org.apache.jetspeed.portlets.search.PortletToPageMap;
import org.apache.jetspeed.portlets.search.SearchInfo;
import org.apache.jetspeed.search.ParsedObject;
import org.apache.jetspeed.search.SearchEngine;
import org.apache.jetspeed.search.SearchResults;
import org.apache.portals.bridges.common.GenericServletPortlet;

public class SearchPortlet
extends GenericServletPortlet {
    public static final String SEARCH_KEY = "SEARCH_KEY";
    public static final String SEARCH_RESULTS = "SEARCH_RESULTS";
    public static final String DEFAULT_SEARCH_RESULTS_PAGE = "/search/results.psml";
    private SearchEngine searchEngine;
    private PortalAdministration admin;
    private PageManager pageManager;
    private PortletRegistry portletRegistry;
    private PortalConfiguration configuration;
    private String filePreference;
    private String portletClass;
    private String mountPoint;
    private static final String SEARCH_CACHE = "J2_SEARCH_CACHE";

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        PortletContext context = this.getPortletContext();
        this.searchEngine = (SearchEngine)context.getAttribute("cps:SearchComponent");
        if (this.searchEngine == null) {
            throw new PortletException("Could not get instance of portal Search Engine component");
        }
        this.admin = (PortalAdministration)this.getPortletContext().getAttribute("cps:PortalAdministration");
        if (null == this.admin) {
            throw new PortletException("Failed to find the Portal Administration on portlet initialization");
        }
        this.pageManager = (PageManager)context.getAttribute("cps:PageManager");
        if (this.pageManager == null) {
            throw new PortletException("Could not get instance of portal PageManager component");
        }
        this.portletRegistry = (PortletRegistry)context.getAttribute("cps:PortletRegistryComponent");
        if (this.portletRegistry == null) {
            throw new PortletException("Could not get instance of portal PortletRegistry component");
        }
        this.configuration = (PortalConfiguration)this.getPortletContext().getAttribute("cps:PortalConfiguration");
        if (null == this.configuration) {
            throw new PortletException("Failed to find the Portal Configuration on portlet initialization");
        }
        this.filePreference = config.getInitParameter("FilePreference");
        this.portletClass = config.getInitParameter("PortletClass");
        this.mountPoint = config.getInitParameter("MountPoint");
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String viewPage = this.getPortletConfig().getInitParameter("ViewPage");
        this.getPortletContext().getRequestDispatcher(viewPage).include(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse actionResponse) throws PortletException, IOException {
        String jsSearch = request.getParameter("jsSearch");
        if (jsSearch == null) {
            jsSearch = "";
        }
        SearchResults searchResults = this.searchEngine.search(jsSearch);
        ArrayList<SearchInfo> searchInfoResults = new ArrayList<SearchInfo>();
        for (ParsedObject result : searchResults.getResults()) {
            String link;
            if (result.getType().equals("url")) {
                List links;
                String link2;
                String key;
                int index = result.getTitle().indexOf(this.mountPoint);
                if (index <= -1 || (key = result.getTitle().substring(index)) == null || (link2 = this.getBestLink(links = this.getPortletToPageMap(request.getPortletSession()).getContent(key))) == null) continue;
                searchInfoResults.add(new SearchInfo(key, result.getType(), link2, Float.valueOf(result.getScore()), result.getDescription(), this.admin.getPortalURL((PortletRequest)request, (PortletResponse)actionResponse, link2)));
                continue;
            }
            String key = result.getKey().substring(result.getKey().indexOf("::") + 2);
            List links = this.getPortletToPageMap(request.getPortletSession()).getPortlet(key);
            if (links == null || (link = this.getBestLink(links)) == null) continue;
            boolean error = false;
            try {
                Page page = this.pageManager.getPage(link);
                page.checkAccess(JetspeedActions.VIEW);
            }
            catch (Exception e) {
                error = true;
            }
            if (error) continue;
            searchInfoResults.add(new SearchInfo(result.getTitle(), result.getType(), key, Float.valueOf(result.getScore()), result.getDescription(), this.admin.getPortalURL((PortletRequest)request, (PortletResponse)actionResponse, link)));
        }
        request.getPortletSession().setAttribute(SEARCH_RESULTS, searchInfoResults, 1);
        request.getPortletSession().setAttribute(SEARCH_KEY, (Object)jsSearch, 1);
        String redirect = this.admin.getPortalURL((PortletRequest)request, (PortletResponse)actionResponse, DEFAULT_SEARCH_RESULTS_PAGE);
        actionResponse.sendRedirect(redirect);
    }

    private PortletToPageMap getPortletToPageMap(PortletSession session) {
        PortletToPageMap map = (PortletToPageMap)session.getAttribute(SEARCH_CACHE);
        long start = System.currentTimeMillis();
        if (map == null) {
            map = new PortletToPageMap();
            try {
                Folder root = this.pageManager.getFolder("/");
                this.traverse(root, map);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            session.setAttribute(SEARCH_CACHE, (Object)map);
            return map;
        }
        return map;
    }

    private void traverse(Folder folder, PortletToPageMap map) {
        try {
            for (Node node : folder.getAll()) {
                switch (node.getType()) {
                    case "folder": {
                        this.traverse((Folder)node, map);
                        break;
                    }
                    case ".psml": {
                        this.visitPortlets((Fragment)((Page)node).getRootFragment(), map, node.getPath());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void visitPortlets(Fragment root, PortletToPageMap map, String pagePath) {
        try {
            for (BaseFragmentElement f : root.getFragments()) {
                if (f instanceof FragmentReference) {
                    FragmentReference fragmentReference = (FragmentReference)f;
                    NodeSet definitions = this.pageManager.getFragmentDefinitions(this.pageManager.getFolder("/"));
                    for (Node n : definitions) {
                        Fragment fragment = (Fragment)((FragmentDefinition)n).getRootFragment();
                        String contentPath = this.getContentFilePath(fragment.getName());
                        if (contentPath != null) {
                            map.putContent(contentPath, pagePath);
                            continue;
                        }
                        map.putPortlet(fragment.getName(), pagePath);
                    }
                    continue;
                }
                Fragment fragment = (Fragment)f;
                String contentPath = this.getContentFilePath(fragment.getName());
                if (contentPath != null) {
                    map.putContent(contentPath, pagePath);
                    continue;
                }
                map.putPortlet(fragment.getName(), pagePath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getContentFilePath(String uniqueName) {
        List values;
        Preference pref;
        PortletDefinition portlet = this.portletRegistry.getPortletDefinitionByUniqueName(uniqueName);
        if (portlet != null && portlet.getPortletClass().equals(this.portletClass) && (pref = portlet.getPortletPreferences().getPortletPreference(this.filePreference)) != null && (values = pref.getValues()).size() > 0) {
            return (String)values.get(0);
        }
        return null;
    }

    private String getBestLink(List<String> links) {
        if (links == null || links.size() == 0) {
            return this.configuration.getString("/psml.page.default", "/default-page.psml");
        }
        String best = null;
        for (String link : links) {
            if (link.startsWith("/_") || link.startsWith("/system")) continue;
            best = link;
        }
        return best;
    }
}

