/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.security.constraints;

import java.util.HashMap;
import java.util.List;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.security.GroupManager;
import org.apache.jetspeed.security.RoleManager;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.mvc.AbstractController;

public class ConstraintsViewController
extends AbstractController
implements PortletConfigAware {
    private static final String ROLES_CACHE_SESSION_ATTRIBUTE_NAME = "j2Roles";
    private static final String GROUPS_CACHE_SESSION_ATTRIBUTE_NAME = "j2Groups";
    private PortletConfig portletConfig;
    protected PageManager pageManager;
    protected RoleManager rm = null;
    protected GroupManager gm = null;

    public ModelAndView handleRenderRequestInternal(RenderRequest request, RenderResponse response) throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("messages", this.portletConfig.getResourceBundle(request.getLocale()));
        model.put("greeting", "Hello");
        boolean constraintsEnabled = this.pageManager.getConstraintsEnabled();
        model.put("constraintsEnabled", new Boolean(constraintsEnabled));
        PageSecurity constraints = this.pageManager.getPageSecurity();
        model.put("defs", constraints.getSecurityConstraintsDefs());
        model.put("globals", constraints.getGlobalSecurityConstraintsRefs());
        PortletSession session = request.getPortletSession();
        List roles = (List)session.getAttribute(ROLES_CACHE_SESSION_ATTRIBUTE_NAME, 2);
        if (roles == null) {
            try {
                roles = this.rm.getRoles("");
                session.setAttribute(ROLES_CACHE_SESSION_ATTRIBUTE_NAME, (Object)roles, 2);
            }
            catch (Exception e) {
                this.logger.error((Object)"Could not get list of roles from RoleManager.", (Throwable)e);
            }
        }
        model.put("roles", roles);
        List groups = (List)session.getAttribute(GROUPS_CACHE_SESSION_ATTRIBUTE_NAME, 2);
        if (groups == null) {
            try {
                groups = this.gm.getGroups("");
                session.setAttribute(GROUPS_CACHE_SESSION_ATTRIBUTE_NAME, (Object)groups, 2);
            }
            catch (Exception e) {
                this.logger.error((Object)"Could not get list of groups from GroupManager.", (Throwable)e);
            }
        }
        model.put("groups", groups);
        model.put("renderRequest", request);
        return new ModelAndView("constraintsView", "model", model);
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
        this.pageManager = (PageManager)this.getPortletContext().getAttribute("cps:PageManager");
        if (null == this.pageManager) {
            PortletException pe = new PortletException("Failed to find the Page Manager on portlet initialization");
            throw new RuntimeException(pe);
        }
        this.rm = (RoleManager)this.getPortletContext().getAttribute("cps:RoleManager");
        if (this.rm == null) {
            throw new RuntimeException("Could not get instance of portal role manager component");
        }
        this.gm = (GroupManager)this.getPortletContext().getAttribute("cps:GroupManager");
        if (this.gm == null) {
            throw new RuntimeException("Could not get instance of portal group manager component");
        }
    }
}

