/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.security.permissions;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.jetspeed.portlets.dojo.AbstractAdminDojoVelocityPortlet;
import org.apache.jetspeed.portlets.security.permissions.SecurityPermissionsPortlet;
import org.apache.jetspeed.security.JetspeedPermission;
import org.apache.jetspeed.security.PermissionManager;
import org.apache.jetspeed.security.RoleManager;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityPermissionsPortlet
extends AbstractAdminDojoVelocityPortlet {
    static final Logger logger = LoggerFactory.getLogger(SecurityPermissionsPortlet.class);
    protected PermissionManager pm = null;
    protected RoleManager rm = null;
    static final String[] CLASSNAMES = new String[]{"org.apache.jetspeed.security.FolderPermission", "org.apache.jetspeed.security.PagePermission", "org.apache.jetspeed.security.PortletPermission"};
    static final String[] TITLES = new String[]{"Folders", "Pages", "Portlets"};

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        PortletContext context = this.getPortletContext();
        this.pm = (PermissionManager)context.getAttribute("cps:PermissionManager");
        if (this.pm == null) {
            throw new PortletException("Could not get instance of portal permission manager component");
        }
        this.rm = (RoleManager)context.getAttribute("cps:RoleManager");
        if (this.rm == null) {
            throw new PortletException("Could not get instance of portal role manager component");
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.retrievePermissions(request.getPortletSession(), this.getContext(request));
        super.doView(request, response);
    }

    public void retrievePermissions(PortletSession session, Context context) {
        Iterator folderPermissions = (Iterator)session.getAttribute("folderPermissions", 2);
        Iterator pagePermissions = (Iterator)session.getAttribute("pagePermissions", 2);
        Iterator portletPermissions = (Iterator)session.getAttribute("portletPermissions", 2);
        List roles = (List)session.getAttribute("roles", 2);
        if (portletPermissions == null) {
            LinkedList<PermissionData> folders = new LinkedList<PermissionData>();
            LinkedList<PermissionData> pages = new LinkedList<PermissionData>();
            LinkedList<PermissionData> portlets = new LinkedList<PermissionData>();
            for (JetspeedPermission permission : this.pm.getPermissions()) {
                if (permission.getType().equals("folder")) {
                    folders.add(new PermissionData(this, permission));
                    continue;
                }
                if (permission.getType().equals("page")) {
                    pages.add(new PermissionData(this, permission));
                    continue;
                }
                if (!permission.getType().equals("portlet")) continue;
                portlets.add(new PermissionData(this, permission));
            }
            folderPermissions = folders.iterator();
            pagePermissions = pages.iterator();
            portletPermissions = portlets.iterator();
            try {
                roles = this.rm.getRoles("");
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        context.put("folderPermissions", (Object)folderPermissions);
        context.put("pagePermissions", (Object)pagePermissions);
        context.put("portletPermissions", (Object)portletPermissions);
        context.put("roles", (Object)roles);
    }

    public void processAction(ActionRequest request, ActionResponse actionResponse) throws PortletException, IOException {
    }
}

