/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.security.sso;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.security.auth.Subject;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.security.JSSubject;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.sso.SSOException;
import org.apache.jetspeed.sso.SSOManager;
import org.apache.jetspeed.sso.SSOSite;
import org.apache.jetspeed.sso.SSOUser;
import org.apache.portals.applications.gems.browser.BrowserIterator;
import org.apache.portals.applications.gems.browser.BrowserPortlet;
import org.apache.portals.applications.gems.browser.DatabaseBrowserIterator;
import org.apache.portals.applications.gems.browser.StatusMessage;
import org.apache.portals.messaging.PortletMessaging;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSOChangePasswordPortlet
extends BrowserPortlet {
    static final Logger logger = LoggerFactory.getLogger(SSOChangePasswordPortlet.class);
    private SSOManager sso;
    private UserManager userManager;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.sso = (SSOManager)this.getPortletContext().getAttribute("cps:SSO");
        if (null == this.sso) {
            throw new PortletException("Failed to find the SSO Provider on portlet initialization");
        }
        this.userManager = (UserManager)this.getPortletContext().getAttribute("cps:UserManager");
        if (null == this.userManager) {
            throw new PortletException("Failed to find the User Manager on portlet initialization");
        }
    }

    public void getRows(RenderRequest request, String sql, int windowSize) throws Exception {
        ArrayList<String> resultSetTitleList = new ArrayList<String>();
        ArrayList<String> resultSetTypeList = new ArrayList<String>();
        try {
            Collection sites = this.sso.getSites("");
            resultSetTypeList.add(String.valueOf(12));
            resultSetTypeList.add(String.valueOf(12));
            resultSetTitleList.add(0, "URL");
            resultSetTitleList.add(1, "Site");
            ArrayList list = new ArrayList();
            if (sites != null) {
                for (SSOSite site : sites) {
                    ArrayList<String> row = new ArrayList<String>(2);
                    row.add(0, site.getURL());
                    row.add(1, site.getName());
                    list.add(row);
                }
            }
            DatabaseBrowserIterator iterator = new DatabaseBrowserIterator(list, resultSetTitleList, resultSetTypeList, windowSize);
            this.setBrowserIterator(request, (BrowserIterator)iterator);
            iterator.sort("Site");
        }
        catch (Exception e) {
            logger.error("Exception in getRows: ", (Throwable)e);
            throw e;
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        StatusMessage msg;
        String selectedSiteName = (String)PortletMessaging.receive((PortletRequest)request, (String)"SSOChangePassword", (String)"selectedName");
        if (selectedSiteName != null) {
            Context context = this.getContext(request);
            context.put("currentName", (Object)selectedSiteName);
            context.put("currentUrl", (Object)((String)PortletMessaging.receive((PortletRequest)request, (String)"SSOChangePassword", (String)"selectedUrl")));
            String ssoUsername = (String)PortletMessaging.receive((PortletRequest)request, (String)"SSOChangePassword", (String)"ssoUsername");
            context.put("ssoUsername", (Object)ssoUsername);
        }
        if ((msg = (StatusMessage)PortletMessaging.consume((PortletRequest)request, (String)"SSOChangePassword", (String)"status")) != null) {
            this.getContext(request).put("statusMsg", (Object)msg);
        }
        super.doView(request, response);
    }

    protected void clearPortletMessages(PortletRequest request, PortletResponse response) {
        PortletMessaging.cancel((PortletRequest)request, (String)"SSOChangePassword", (String)"selectedName");
        PortletMessaging.cancel((PortletRequest)request, (String)"SSOChangePassword", (String)"selectedUrl");
        PortletMessaging.cancel((PortletRequest)request, (String)"SSOChangePassword", (String)"ssoUsername");
    }

    protected void setPortletMessage(PortletRequest request, String key, String msg) throws IOException {
        if (StringUtils.isNotEmpty((String)msg)) {
            PortletMessaging.publish((PortletRequest)request, (String)"SSOChangePassword", (String)key, (Object)msg);
        } else {
            PortletMessaging.cancel((PortletRequest)request, (String)"SSOChangePassword", (String)key);
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        if (request.getPortletMode() == PortletMode.VIEW) {
            SSOSite site;
            String selectedSite = request.getParameter("ssoSite");
            if (selectedSite != null && (site = this.sso.getSiteByName(selectedSite)) != null) {
                this.setPortletMessage((PortletRequest)request, "selectedUrl", site.getURL());
                this.setPortletMessage((PortletRequest)request, "selectedName", site.getName());
                this.setPortletMessage((PortletRequest)request, "change", selectedSite);
                this.setPortletMessage((PortletRequest)request, "ssoUsername", this.getRemoteUserName((PortletRequest)request, site));
            }
            String refresh = request.getParameter("sso.refresh");
            String save = request.getParameter("sso.save");
            String delete = request.getParameter("sso.delete");
            if (refresh != null) {
                this.clearBrowserIterator((PortletRequest)request);
            } else if (delete != null) {
                SSOSite site2;
                String siteName = request.getParameter("site.name");
                if (!StringUtils.isEmpty((String)siteName) && (site2 = this.sso.getSiteByName(siteName)) != null) {
                    this.removeRemoteUser((PortletRequest)request, site2);
                    this.clearBrowserIterator((PortletRequest)request);
                    this.clearPortletMessages((PortletRequest)request, (PortletResponse)response);
                }
            } else if (save != null) {
                String siteName = request.getParameter("site.name");
                String siteUrl = request.getParameter("site.url");
                String ssoUsername = request.getParameter("ssoUsername");
                String ssoPassword = request.getParameter("ssoPassword");
                if (!(StringUtils.isEmpty((String)siteName) || StringUtils.isEmpty((String)siteUrl) || StringUtils.isEmpty((String)ssoUsername) || StringUtils.isEmpty((String)ssoPassword))) {
                    SSOSite site3 = null;
                    String old = (String)PortletMessaging.receive((PortletRequest)request, (String)"site", (String)"selectedName");
                    site3 = this.sso.getSiteByName(old != null ? old : siteName);
                    this.addOrUpdateRemoteUser((PortletRequest)request, site3, ssoUsername, ssoPassword);
                    this.clearBrowserIterator((PortletRequest)request);
                    PortletMessaging.publish((PortletRequest)request, (String)"SSOChangePassword", (String)"selectedName", (Object)siteName);
                    PortletMessaging.publish((PortletRequest)request, (String)"SSOChangePassword", (String)"selectedUrl", (Object)siteUrl);
                    PortletMessaging.publish((PortletRequest)request, (String)"SSOChangePassword", (String)"ssoUsername", (Object)ssoUsername);
                }
            }
        }
        request.getPortletSession().removeAttribute("org.apache.jetspeed.portlets.sso.ssoSiteCredsOfSubject", 1);
        super.processAction(request, response);
    }

    private String getRemoteUserName(PortletRequest request, SSOSite site) {
        String remoteUsername = null;
        try {
            Subject subject = JSSubject.getSubject((AccessControlContext)AccessController.getContext());
            Collection remoteUsers = this.sso.getRemoteUsers(site, subject);
            if (remoteUsers != null && !remoteUsers.isEmpty()) {
                remoteUsername = ((SSOUser)remoteUsers.iterator().next()).getName();
            }
        }
        catch (SSOException e) {
            this.publishStatusMessage(request, "SSOChangePassword", "status", (Throwable)e, "Could not retrieve sso user name");
        }
        return remoteUsername;
    }

    private void removeRemoteUser(PortletRequest request, SSOSite site) {
        try {
            Subject subject = JSSubject.getSubject((AccessControlContext)AccessController.getContext());
            Collection remoteUsers = this.sso.getRemoteUsers(site, subject);
            if (remoteUsers != null && !remoteUsers.isEmpty()) {
                this.sso.removeUser((SSOUser)remoteUsers.iterator().next());
            }
        }
        catch (SSOException e) {
            this.publishStatusMessage(request, "SSOChangePassword", "status", (Throwable)e, "Could not remove sso user");
        }
    }

    private void addOrUpdateRemoteUser(PortletRequest request, SSOSite site, String username, String password) {
        try {
            Subject subject = JSSubject.getSubject((AccessControlContext)AccessController.getContext());
            Collection remoteUsers = this.sso.getRemoteUsers(site, subject);
            if (remoteUsers != null && !remoteUsers.isEmpty()) {
                SSOUser ssoUser = (SSOUser)remoteUsers.iterator().next();
                if (!StringUtils.equals((String)ssoUser.getName(), (String)username)) {
                    ssoUser.setName(username);
                    this.sso.updateUser(ssoUser);
                }
                this.sso.setPassword(ssoUser, password);
            } else {
                User user = this.userManager.getUser(request.getUserPrincipal().getName());
                this.sso.addUser(site, (JetspeedPrincipal)user, username, password);
            }
        }
        catch (SSOException e) {
            this.publishStatusMessage(request, "SSOChangePassword", "status", (Throwable)e, "Could not remove sso user");
        }
        catch (SecurityException e) {
            this.publishStatusMessage(request, "SSOChangePassword", "status", (Throwable)e, "Could not retrieve jetspeed user");
        }
    }
}

