/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.spaces;

import java.io.IOException;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.administration.PortalAdministration;
import org.apache.jetspeed.portlets.spaces.SpaceAdminUtils;
import org.apache.jetspeed.portlets.spaces.SpaceBean;
import org.apache.jetspeed.portlets.spaces.SpaceChangeContext;
import org.apache.jetspeed.portlets.spaces.UserSpaceBeanList;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.spaces.Space;
import org.apache.jetspeed.spaces.Spaces;
import org.apache.jetspeed.spaces.SpacesException;
import org.apache.portals.bridges.common.GenericServletPortlet;
import org.apache.portals.messaging.PortletMessaging;

/*
 * Exception performing whole class analysis ignored.
 */
public class SpaceNavigator
extends GenericServletPortlet {
    public static final String ATTRIBUTE_SPACES = "spaces";
    public static final String ATTRIBUTE_SPACE = "space";
    public static final String ATTRIBUTE_IS_SPACES_ADMIN = "isSpacesAdmin";
    public static final String SPACE_EDIT_PATH_PREF = "spaceEditPath";
    public static final String SPACE_EDIT_PATH_DEFAULT = "/spaces.psml";
    private Spaces spacesService;
    private PortalAdministration admin;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        PortletContext context = this.getPortletContext();
        this.spacesService = (Spaces)context.getAttribute("cps:SpacesService");
        if (this.spacesService == null) {
            throw new PortletException("Could not get instance of portal spaces service component");
        }
        this.admin = (PortalAdministration)context.getAttribute("cps:PortalAdministration");
        if (this.admin == null) {
            throw new PortletException("Failed to find the Portal Administration on portlet initialization");
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String spaceName = (String)PortletMessaging.consume((PortletRequest)request, (String)"SpaceNavigator", (String)"spaceChange");
        if (spaceName != null) {
            request.getPortletSession().removeAttribute("spaces", 1);
            request.getPortletSession().removeAttribute("space", 1);
        }
        SpaceChangeContext scc = SpaceNavigator.changeSpace((RenderRequest)request, (Spaces)this.spacesService, (String)spaceName);
        SpaceBean spaceBean = scc.getSpace();
        List spaceBeans = scc.getSpaces();
        request.setAttribute("space", (Object)spaceBean);
        request.setAttribute("spaces", (Object)spaceBeans);
        if (SpaceAdminUtils.isUserSpaceOwner((SpaceBean)spaceBean, (PortletRequest)request) || SpaceAdminUtils.isUserSpaceAdmin((SpaceBean)spaceBean, (PortalAdministration)this.admin, (PortletRequest)request)) {
            request.setAttribute("spaceEditable", (Object)Boolean.TRUE);
        }
        if (SpaceAdminUtils.isUserSpaceAdmin((SpaceBean)spaceBean, (PortalAdministration)this.admin, (PortletRequest)request)) {
            request.setAttribute("spaceCreatable", (Object)Boolean.TRUE);
        }
        super.doView(request, response);
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        String navAction = actionRequest.getParameter("navAction");
        Space space = null;
        String spaceName = actionRequest.getParameter("space");
        if (spaceName != null) {
            space = this.getSpaceFromName(spaceName, (PortletRequest)actionRequest);
        }
        if ("addSpace".equals(navAction)) {
            PortletMessaging.cancel((PortletRequest)actionRequest, (String)"SpaceList", (String)"spaceChange");
            String spaceEditPath = actionRequest.getPreferences().getValue("spaceEditPath", "/spaces.psml");
            String path = this.admin.getPortalURL((PortletRequest)actionRequest, (PortletResponse)actionResponse, spaceEditPath);
            actionResponse.sendRedirect(path);
            return;
        }
        if ("editSpace".equals(navAction) && space != null) {
            if (space != null) {
                PortletMessaging.publish((PortletRequest)actionRequest, (String)"SpaceList", (String)"spaceChange", (Object)spaceName);
                String spaceEditPath = actionRequest.getPreferences().getValue("spaceEditPath", "/spaces.psml");
                String path = this.admin.getPortalURL((PortletRequest)actionRequest, (PortletResponse)actionResponse, spaceEditPath);
                actionResponse.sendRedirect(path);
                return;
            }
        } else if (space != null && space != null) {
            String path = this.admin.getPortalURL((PortletRequest)actionRequest, (PortletResponse)actionResponse, space.getPath());
            actionRequest.getPortletSession().setAttribute("space", (Object)new SpaceBean(space));
            PortletMessaging.publish((PortletRequest)actionRequest, (String)"PageNavigator", (String)"spaceChange", (Object)spaceName);
            actionResponse.sendRedirect(path);
            return;
        }
    }

    protected Space getSpaceFromName(String spaceName, PortletRequest request) {
        Space home;
        List spaces = this.spacesService.listSpaces();
        if (request.getUserPrincipal() != null && (home = this.spacesService.lookupUserSpace(request.getUserPrincipal().getName())) != null && home.getName().equals(spaceName)) {
            return home;
        }
        Space space = null;
        for (Space sp : spaces) {
            if (!sp.getName().equals(spaceName)) continue;
            space = sp;
            break;
        }
        return space;
    }

    protected static SpaceBean findSpaceByName(List<SpaceBean> spaces, String spaceName) {
        for (SpaceBean space : spaces) {
            if (!space.getName().equals(spaceName)) continue;
            return space;
        }
        return null;
    }

    protected static UserSpaceBeanList createSpaceBeanList(Spaces spacesService, String userName, String env) {
        List sl = spacesService.listSpaces();
        UserSpaceBeanList spaces = new UserSpaceBeanList(userName);
        for (Space s : sl) {
            spaces.add((Object)new SpaceBean(s));
        }
        return spaces;
    }

    protected static SpaceChangeContext changeSpace(RenderRequest request, Spaces spacesService, String spaceName) throws PortletException {
        RequestContext rc;
        String portalPagePath;
        String portalPageFolderPath;
        boolean isRootSpace;
        String userName = request.getUserPrincipal() != null ? request.getUserPrincipal().getName() : null;
        UserSpaceBeanList spaces = (UserSpaceBeanList)request.getPortletSession().getAttribute("spaces", 1);
        if (spaces != null && !StringUtils.equals((String)spaces.getUserName(), (String)userName)) {
            request.getPortletSession().removeAttribute("spaces", 1);
            spaces = null;
        }
        if (spaces == null) {
            String username;
            Space home;
            spaces = SpaceNavigator.createSpaceBeanList((Spaces)spacesService, (String)userName, null);
            if (request.getUserPrincipal() != null && (home = spacesService.lookupUserSpace(username = request.getUserPrincipal().getName())) != null) {
                if (home.getOwner() == null) {
                    try {
                        home.setOwner(username);
                        spacesService.storeSpace(home);
                    }
                    catch (SpacesException e) {
                        throw new PortletException((Throwable)e);
                    }
                }
                SpaceBean userHome = new SpaceBean(home);
                userHome.setDescription(home.getDescription());
                userHome.setTitle(home.getTitle());
                userHome.setUserHomePath(home.getPath());
                userHome.setUserHomeName(home.getName());
                spaces.add((Object)userHome);
            }
            request.getPortletSession().setAttribute("spaces", (Object)spaces, 1);
        }
        boolean changed = false;
        SpaceBean space = (SpaceBean)request.getPortletSession().getAttribute("space", 1);
        if (space == null && spaceName != null) {
            space = SpaceNavigator.findSpaceByName((List)spaces, (String)spaceName);
            boolean bl = changed = space != null;
        }
        if (isRootSpace = StringUtils.isEmpty((String)(portalPageFolderPath = StringUtils.substringBeforeLast((String)(portalPagePath = (rc = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext")).getPage().getPath()), (String)"/")))) {
            for (SpaceBean spaceBean : spaces) {
                if (!"/".equals(spaceBean.getPath())) continue;
                if (spaceBean.equals((Object)space)) break;
                space = spaceBean;
                changed = true;
                break;
            }
        } else {
            for (SpaceBean spaceBean : spaces) {
                if ("/".equals(spaceBean.getPath()) || !portalPageFolderPath.equals(spaceBean.getPath()) && !portalPageFolderPath.startsWith(spaceBean.getPath() + "/")) continue;
                if (spaceBean.equals((Object)space)) break;
                space = spaceBean;
                changed = true;
                break;
            }
        }
        if (space == null && !spaces.isEmpty()) {
            space = (SpaceBean)spaces.get(0);
            changed = true;
        }
        if (changed) {
            request.getPortletSession().setAttribute("space", (Object)space, 1);
        }
        return new SpaceChangeContext(space, (List)spaces);
    }
}

