/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.sso;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.jetspeed.portlets.sso.JetspeedSSOSiteCredentials;
import org.apache.portals.applications.webcontent2.proxy.HttpClientContextBuilder;
import org.apache.portals.applications.webcontent2.proxy.ProxyContext;
import org.apache.portals.applications.webcontent2.proxy.impl.ServletRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JetspeedHttpClientContextBuilder
implements HttpClientContextBuilder {
    private static Logger log = LoggerFactory.getLogger(JetspeedHttpClientContextBuilder.class);

    public HttpClientContext build() {
        ProxyContext proxyContext = ProxyContext.getCurrentProxyContext();
        HttpServletRequest request = ((ServletRequestContext)proxyContext.getRequestContext()).getServletRequest();
        List ssoCredsList = (List)request.getAttribute("org.apache.jetspeed.portlets.sso.ssoSiteCredsOfSubject");
        if (ssoCredsList == null) {
            HttpSession session = request.getSession(false);
            if (session == null) {
                return null;
            }
            ssoCredsList = (List)session.getAttribute("org.apache.jetspeed.portlets.sso.ssoSiteCredsOfSubject");
        }
        if (ssoCredsList == null || ssoCredsList.isEmpty()) {
            return null;
        }
        HttpClientContext httpClientContext = HttpClientContext.create();
        try {
            httpClientContext.setCredentialsProvider((CredentialsProvider)new BasicCredentialsProvider());
            httpClientContext.setAuthCache((AuthCache)new BasicAuthCache());
            for (JetspeedSSOSiteCredentials ssoCreds : ssoCredsList) {
                HttpHost targetHost = new HttpHost(ssoCreds.getHost(), ssoCreds.getPort(), ssoCreds.getScheme());
                httpClientContext.getAuthCache().put(targetHost, (AuthScheme)new BasicScheme());
                httpClientContext.getCredentialsProvider().setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort(), ssoCreds.getRealm()), (Credentials)new UsernamePasswordCredentials(ssoCreds.getUsername(), ssoCreds.getPassword()));
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.warn("Failed to retrieve sso site credentials.", (Throwable)e);
            }
            log.warn("Failed to retrieve sso site credentials. {}", (Object)e.toString());
        }
        return httpClientContext;
    }
}

