/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mfa.portlets;

import java.io.IOException;
import java.io.NotSerializableException;
import java.util.Map;
import java.util.Random;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.jetspeed.audit.AuditActivity;
import org.apache.jetspeed.login.LoginConstants;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.AuthenticatedUser;
import org.apache.jetspeed.security.AuthenticationProvider;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.SecurityAttribute;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserCredential;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.mfa.impl.CaptchaImageResource;
import org.apache.jetspeed.security.mfa.portlets.StatusMessage;
import org.apache.jetspeed.security.mfa.portlets.UserBean;
import org.apache.jetspeed.security.mfa.util.QuestionFactory;
import org.apache.jetspeed.security.mfa.util.SecurityHelper;
import org.apache.portals.bridges.common.GenericServletPortlet;
import org.apache.portals.messaging.PortletMessaging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MFALogin
extends GenericServletPortlet {
    static final Logger logger = LoggerFactory.getLogger(MFALogin.class);
    private UserManager userManager;
    private AuditActivity audit;
    private AuthenticationProvider authorization;
    private Random rand = new Random();
    private int cookieLifetime = 172800;
    private int maxNumberOfAuthenticationFailures = 3;
    private QuestionFactory questionFactory;
    public static final String RETRYCOUNT = "mfaRetryCount";
    public static final String ERRORCODE = "mfaErrorCode";
    public static final String QUESTION_FACTORY = "mfaQuestionFactory";
    public static final String LOGIN_ENROLL_ACTIVITY = "login-enroll";
    protected String[][] SUCCESS1_MAP = new String[][]{{"one", "/WEB-INF/view/mfa/login3.jsp"}, {"two", "/WEB-INF/view/mfa/login3.jsp"}, {"three", "/WEB-INF/view/mfa/login3.jsp"}, {"enroll", "/WEB-INF/view/mfa/enroll-login.jsp"}, {"enroll-login", "/WEB-INF/view/mfa/enroll.jsp"}, {"loggedon", "/WEB-INF/view/mfa/loggedon.jsp"}, {"restart", "/WEB-INF/view/mfa/login1.jsp"}};
    protected String[][] SUCCESS2_MAP = new String[][]{{"one", "/WEB-INF/view/mfa/login2.jsp"}};
    protected String[][] SUCCESS3_MAP = new String[][]{{"one", "/WEB-INF/view/mfa/enroll-login.jsp"}};
    protected String[][] FAILURE1_MAP = new String[][]{{"one", "/WEB-INF/view/mfa/login1.jsp"}, {"two", "/WEB-INF/view/mfa/login1.jsp"}, {"three", "/WEB-INF/view/mfa/login3.jsp"}, {"enroll", "/WEB-INF/view/mfa/enroll.jsp"}, {"enroll-login", "/WEB-INF/view/mfa/enroll-login.jsp"}};
    protected String[][] FAILURE2_MAP = new String[][]{{"one", "/WEB-INF/view/mfa/login2.jsp"}, {"two", "/WEB-INF/view/mfa/login1.jsp"}, {"enroll", "/WEB-INF/view/mfa/login1.jsp"}, {"enroll-login", "/WEB-INF/view/mfa/login4.jsp"}, {"three", "/WEB-INF/view/mfa/login4.jsp"}};
    protected String[][][] TRANSITIONS = new String[][][]{this.SUCCESS1_MAP, this.SUCCESS2_MAP, this.SUCCESS3_MAP, this.FAILURE1_MAP, this.FAILURE2_MAP};
    public static final String VIEW = "mfa.view";
    public static final String USERBEAN = "userBean";
    public static final String STATUS_MESSAGE = "statusMsg";
    protected static final int SUCCESS1 = 0;
    protected static final int SUCCESS2 = 1;
    protected static final int SUCCESS3 = 2;
    protected static final int FAILURE1 = 3;
    protected static final int FAILURE2 = 4;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.userManager = (UserManager)this.getPortletContext().getAttribute("cps:UserManager");
        if (null == this.userManager) {
            throw new PortletException("Failed to find the User Manager on portlet initialization");
        }
        this.audit = (AuditActivity)this.getPortletContext().getAttribute("cps:AuditActivity");
        if (null == this.audit) {
            throw new PortletException("Failed to find the Audit Activity on portlet initialization");
        }
        this.authorization = (AuthenticationProvider)this.getPortletContext().getAttribute("cps:AuthenticationProvider");
        if (null == this.authorization) {
            throw new PortletException("Failed to find the Authorization Provider on portlet initialization");
        }
        String cookie = this.getInitParameter("cookieLifetime");
        String max = this.getInitParameter("maxNumberOfAuthenticationFailures");
        if (cookie != null) {
            try {
                this.cookieLifetime = Integer.parseInt(cookie);
                this.maxNumberOfAuthenticationFailures = Integer.parseInt(max);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.questionFactory = new QuestionFactory(this.getInitParameter("randomQuestions"));
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        String view = (String)PortletMessaging.receive((PortletRequest)request, (String)VIEW);
        if (request.getUserPrincipal() != null) {
            view = this.setView((PortletRequest)request, "loggedon", 0);
            request.setAttribute("ViewPage", (Object)view);
        } else if (view != null) {
            RequestContext rc = SecurityHelper.getRequestContext((PortletRequest)request);
            Integer ecode = (Integer)rc.getSessionAttribute("org.apache.jetspeed.login.errorcode");
            if (ecode != null && (ecode.equals(LoginConstants.ERROR_USER_DISABLED) || ecode.equals(LoginConstants.ERROR_CREDENTIAL_DISABLED))) {
                view = this.setView((PortletRequest)request, "three", 4);
            }
            request.setAttribute("ViewPage", (Object)view);
        } else {
            request.setAttribute("ViewPage", (Object)this.getDefaultViewPage());
        }
        StatusMessage message = (StatusMessage)PortletMessaging.consume((PortletRequest)request, (String)STATUS_MESSAGE);
        if (message != null) {
            request.setAttribute(STATUS_MESSAGE, (Object)message);
        }
        if (view == null || view.equals("one")) {
            this.clearLoginMessages((PortletRequest)request);
        }
        request.setAttribute(QUESTION_FACTORY, (Object)this.questionFactory);
        super.doView(request, response);
    }

    protected String setView(PortletRequest request, String phase, int state) throws PortletException {
        String[][] views = this.TRANSITIONS[state];
        String result = "/WEB-INF/view/mfa/login1.jsp";
        for (int ix = 0; ix < views.length; ++ix) {
            if (!views[ix][0].equals(phase)) continue;
            try {
                PortletMessaging.publish((PortletRequest)request, (String)VIEW, (Object)views[ix][1]);
                result = views[ix][1];
                break;
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
        }
        return result;
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        String phase = actionRequest.getParameter("phase");
        UserBean userBean = (UserBean)actionRequest.getPortletSession().getAttribute(USERBEAN, 1);
        if (userBean != null && phase != null) {
            if (phase.equals("one")) {
                String captcha = actionRequest.getParameter("captcha");
                String username = actionRequest.getParameter("username");
                if (SecurityHelper.isEmpty((String)captcha) || !userBean.getCaptcha().equals(captcha)) {
                    StatusMessage msg = new StatusMessage("The text entered does not match the displayed text.", "portlet-msg-error");
                    PortletMessaging.publish((PortletRequest)actionRequest, (String)STATUS_MESSAGE, (Object)msg);
                    this.setView((PortletRequest)actionRequest, phase, 3);
                    return;
                }
                if (this.userManager.userExists(username)) {
                    User user = null;
                    try {
                        user = this.userManager.getUser(username);
                    }
                    catch (Exception e) {
                        StatusMessage msg = new StatusMessage("User not accessible.", "portlet-msg-error");
                        PortletMessaging.publish((PortletRequest)actionRequest, (String)STATUS_MESSAGE, (Object)msg);
                        userBean.setInvalidUser(true);
                        userBean.setQuestion(this.questionFactory.getRandomQuestion());
                        this.setView((PortletRequest)actionRequest, phase, 1);
                        return;
                    }
                    userBean.setUsername(username);
                    userBean.setUser(user);
                    UserCredential credential = null;
                    try {
                        credential = SecurityHelper.getCredential((UserManager)this.userManager, (User)user);
                    }
                    catch (SecurityException e) {
                        // empty catch block
                    }
                    if (credential != null && !credential.isEnabled()) {
                        userBean.setInvalidUser(true);
                        this.setView((PortletRequest)actionRequest, phase, 1);
                        userBean.setQuestion(this.questionFactory.getRandomQuestion());
                        StatusMessage msg = new StatusMessage("The account has been disabled.", "portlet-msg-error");
                        PortletMessaging.publish((PortletRequest)actionRequest, (String)STATUS_MESSAGE, (Object)msg);
                        return;
                    }
                    userBean.setUser(user);
                    userBean.setUsername(username);
                    Cookie mfaCookie = SecurityHelper.getMFACookie((PortletRequest)actionRequest, (String)username);
                    if (mfaCookie == null) {
                        if (this.generateQuestionAndAnswer(userBean)) {
                            this.setView((PortletRequest)actionRequest, phase, 1);
                        } else {
                            this.setView((PortletRequest)actionRequest, phase, 2);
                        }
                    } else {
                        Map userAttributes = userBean.getUser().getSecurityAttributes().getAttributeMap();
                        String cookie = this.getUserAttribute(userAttributes, "user.cookie", username);
                        if (mfaCookie.getValue().equals(cookie)) {
                            userBean.setHasCookie(true);
                            userBean.setPassPhrase(this.getUserAttribute(userAttributes, "user.passphrase", ""));
                            this.setView((PortletRequest)actionRequest, phase, 0);
                        } else {
                            userBean.setHasCookie(false);
                            if (this.generateQuestionAndAnswer(userBean)) {
                                this.setView((PortletRequest)actionRequest, phase, 1);
                            } else {
                                this.setView((PortletRequest)actionRequest, phase, 2);
                            }
                        }
                    }
                } else {
                    userBean.setInvalidUser(true);
                    userBean.setQuestion(this.questionFactory.getRandomQuestion());
                    StatusMessage msg = new StatusMessage("The text entered does not match the displayed text.", "portlet-msg-error");
                    PortletMessaging.publish((PortletRequest)actionRequest, (String)STATUS_MESSAGE, (Object)msg);
                    this.setView((PortletRequest)actionRequest, phase, 1);
                }
            } else if (phase.equals("two")) {
                if (userBean.isInvalidUser()) {
                    StatusMessage msg = new StatusMessage("Invalid User.", "portlet-msg-error");
                    PortletMessaging.publish((PortletRequest)actionRequest, (String)STATUS_MESSAGE, (Object)msg);
                    this.setView((PortletRequest)actionRequest, phase, 3);
                } else {
                    if (userBean.getUser() == null) {
                        StatusMessage msg = new StatusMessage("User not accessible.", "portlet-msg-error");
                        PortletMessaging.publish((PortletRequest)actionRequest, (String)STATUS_MESSAGE, (Object)msg);
                        this.setView((PortletRequest)actionRequest, phase, 3);
                        return;
                    }
                    String typedAnswer = actionRequest.getParameter("answer");
                    String publicTerminal = actionRequest.getParameter("publicTerminal");
                    userBean.setPublicTerminal(publicTerminal != null);
                    Map userAttributes = userBean.getUser().getSecurityAttributes().getAttributeMap();
                    int failures = Integer.parseInt(this.getUserAttribute(userAttributes, "user.question.failures", "0"));
                    if (SecurityHelper.isEmpty((String)typedAnswer) || !typedAnswer.equalsIgnoreCase(userBean.getAnswer())) {
                        int count = failures + 1;
                        if (count >= this.maxNumberOfAuthenticationFailures) {
                            try {
                                RequestContext rc = SecurityHelper.getRequestContext((PortletRequest)actionRequest);
                                User user = this.userManager.getUser(userBean.getUsername());
                                PasswordCredential pwc = this.userManager.getPasswordCredential(user);
                                pwc.setEnabled(false);
                                this.userManager.storePasswordCredential(pwc);
                                SecurityHelper.updateCredentialInSession((RequestContext)rc, (PasswordCredential)pwc);
                                userBean.setUser(user);
                                userAttributes = userBean.getUser().getSecurityAttributes().getAttributeMap();
                                user.getSecurityAttributes().getAttribute("user.question.failures", true).setStringValue("0");
                                this.userManager.updateUser(user);
                                this.audit.logUserActivity(userBean.getUsername(), rc.getRequest().getRemoteAddr(), "user-disable", "Failed question and answer limit reached");
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            StatusMessage msg = new StatusMessage("Disabling user after too many failed questions.", "portlet-msg-error");
                            PortletMessaging.publish((PortletRequest)actionRequest, (String)STATUS_MESSAGE, (Object)msg);
                            this.setView((PortletRequest)actionRequest, phase, 4);
                        } else {
                            try {
                                userBean.getUser().getSecurityAttributes().getAttribute("user.question.failures", true).setStringValue(Integer.toString(count));
                                this.userManager.updateUser(userBean.getUser());
                            }
                            catch (SecurityException e) {
                                // empty catch block
                            }
                            StatusMessage msg = new StatusMessage("Invalid answer to question.", "portlet-msg-error");
                            PortletMessaging.publish((PortletRequest)actionRequest, (String)STATUS_MESSAGE, (Object)msg);
                            this.setView((PortletRequest)actionRequest, phase, 3);
                        }
                    } else {
                        try {
                            userBean.setPassPhrase(this.getUserAttribute(userAttributes, "user.passphrase", ""));
                            userBean.getUser().getSecurityAttributes().getAttribute("user.question.failures", true).setStringValue("0");
                            this.userManager.updateUser(userBean.getUser());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        this.setView((PortletRequest)actionRequest, phase, 0);
                    }
                }
            } else if (phase.equals("enroll")) {
                boolean success = false;
                String password = userBean.getPassword();
                User user = userBean.getUser();
                if (user != null && password != null) {
                    AuthenticatedUser authUser = null;
                    try {
                        authUser = this.authorization.authenticate(userBean.getUsername(), password);
                    }
                    catch (SecurityException e) {
                        RequestContext rc = SecurityHelper.getRequestContext((PortletRequest)actionRequest);
                        this.audit.logUserActivity(userBean.getUsername(), rc.getRequest().getRemoteAddr(), "login-failure", "PortalFilter");
                    }
                    if (authUser != null) {
                        String question1 = actionRequest.getParameter("question1");
                        String question2 = actionRequest.getParameter("question2");
                        String question3 = actionRequest.getParameter("question3");
                        String answer1 = actionRequest.getParameter("answer1");
                        String answer2 = actionRequest.getParameter("answer2");
                        String answer3 = actionRequest.getParameter("answer3");
                        String passPhrase = actionRequest.getParameter("passphrase");
                        if (SecurityHelper.isEmpty((String)answer1) || SecurityHelper.isEmpty((String)answer2) || SecurityHelper.isEmpty((String)answer3)) {
                            StatusMessage msg = new StatusMessage("Please enter a valid answer for all 3 questions.", "portlet-msg-error");
                            PortletMessaging.publish((PortletRequest)actionRequest, (String)STATUS_MESSAGE, (Object)msg);
                            this.setView((PortletRequest)actionRequest, phase, 3);
                            return;
                        }
                        if (SecurityHelper.isEmpty((String)passPhrase)) {
                            StatusMessage msg = new StatusMessage("Please enter a valid pass phrase.", "portlet-msg-error");
                            PortletMessaging.publish((PortletRequest)actionRequest, (String)STATUS_MESSAGE, (Object)msg);
                            this.setView((PortletRequest)actionRequest, phase, 3);
                            return;
                        }
                        if (question1.equals(question2) || question1.equals(question3) || question2.equals(question3)) {
                            StatusMessage msg = new StatusMessage("Please select a unique question in all cases.", "portlet-msg-error");
                            PortletMessaging.publish((PortletRequest)actionRequest, (String)STATUS_MESSAGE, (Object)msg);
                            this.setView((PortletRequest)actionRequest, phase, 3);
                            return;
                        }
                        user = userBean.getUser();
                        try {
                            user.getSecurityAttributes().getAttribute("user.question.1", true).setStringValue(question1);
                            user.getSecurityAttributes().getAttribute("user.question.2", true).setStringValue(question2);
                            user.getSecurityAttributes().getAttribute("user.question.3", true).setStringValue(question3);
                            user.getSecurityAttributes().getAttribute("user.answer.1", true).setStringValue(answer1);
                            user.getSecurityAttributes().getAttribute("user.answer.2", true).setStringValue(answer2);
                            user.getSecurityAttributes().getAttribute("user.answer.3", true).setStringValue(answer3);
                            user.getSecurityAttributes().getAttribute("user.passphrase", true).setStringValue(passPhrase);
                            user.getSecurityAttributes().getAttribute("user.cookie", true).setStringValue(CaptchaImageResource.randomString((int)8, (int)16));
                            this.userManager.updateUser(user);
                            success = true;
                        }
                        catch (SecurityException e) {
                            success = false;
                            RequestContext rc = SecurityHelper.getRequestContext((PortletRequest)actionRequest);
                            this.audit.logUserActivity(userBean.getUsername(), rc.getRequest().getRemoteAddr(), "login-failure", "Exception updating attributes");
                            this.setView((PortletRequest)actionRequest, phase, 4);
                        }
                        if (success) {
                            String username = userBean.getUsername();
                            String redirect = actionRequest.getParameter("redirect");
                            RequestContext rc = SecurityHelper.getRequestContext((PortletRequest)actionRequest);
                            this.audit.logUserActivity(username, rc.getRequest().getRemoteAddr(), LOGIN_ENROLL_ACTIVITY, "enrolling user with questions and passphrase");
                            this.redirect(actionRequest, actionResponse, redirect, username, password);
                        }
                    }
                }
                if (!success) {
                    RequestContext rc = SecurityHelper.getRequestContext((PortletRequest)actionRequest);
                    this.audit.logUserActivity(userBean.getUsername(), rc.getRequest().getRemoteAddr(), "login-failure", "Unauthorized Attribute Modification Attempt.");
                    this.setView((PortletRequest)actionRequest, phase, 4);
                }
            } else if (phase.equals("enroll-login")) {
                String username = userBean.getUsername();
                String password = actionRequest.getParameter("org.apache.jetspeed.login.password");
                if (SecurityHelper.isEmpty((String)password)) {
                    RequestContext rc = SecurityHelper.getRequestContext((PortletRequest)actionRequest);
                    rc.setSessionAttribute(ERRORCODE, (Object)LoginConstants.ERROR_INVALID_PASSWORD);
                    this.setView((PortletRequest)actionRequest, phase, 3);
                    return;
                }
                if (SecurityHelper.isEmpty((String)userBean.getPassPhrase())) {
                    AuthenticatedUser authUser = null;
                    boolean authenticated = false;
                    try {
                        authUser = this.authorization.authenticate(username, password);
                        authenticated = true;
                    }
                    catch (SecurityException e) {
                        // empty catch block
                    }
                    if (authenticated) {
                        userBean.setPassword(password);
                        this.setView((PortletRequest)actionRequest, phase, 0);
                        this.clearLoginMessages((PortletRequest)actionRequest);
                    } else {
                        this.failedLoginProcessing(actionRequest, phase, username, userBean);
                    }
                }
            } else if (phase.equals("three")) {
                String redirect = actionRequest.getParameter("redirect");
                String username = userBean.getUsername();
                String password = actionRequest.getParameter("org.apache.jetspeed.login.password");
                if (SecurityHelper.isEmpty((String)password) || SecurityHelper.isEmpty((String)redirect)) {
                    RequestContext rc = SecurityHelper.getRequestContext((PortletRequest)actionRequest);
                    rc.setSessionAttribute(ERRORCODE, (Object)LoginConstants.ERROR_INVALID_PASSWORD);
                    this.setView((PortletRequest)actionRequest, phase, 3);
                    return;
                }
                AuthenticatedUser authUser = null;
                boolean authenticated = false;
                try {
                    authUser = this.authorization.authenticate(username, password);
                    authenticated = true;
                }
                catch (SecurityException e) {
                    // empty catch block
                }
                if (authenticated) {
                    userBean.setPassword(password);
                    this.setView((PortletRequest)actionRequest, phase, 0);
                    this.clearLoginMessages((PortletRequest)actionRequest);
                    if (!userBean.isHasCookie() && !userBean.isPublicTerminal()) {
                        Map userAttributes = userBean.getUser().getSecurityAttributes().getAttributeMap();
                        String cookie = this.getUserAttribute(userAttributes, "user.cookie", username);
                        SecurityHelper.addMFACookie((PortletRequest)actionRequest, (String)username, (String)cookie, (int)this.cookieLifetime);
                        userBean.setHasCookie(true);
                    }
                    this.setView((PortletRequest)actionRequest, phase, 0);
                    this.redirect(actionRequest, actionResponse, redirect, username, password);
                } else {
                    this.failedLoginProcessing(actionRequest, phase, username, userBean);
                }
            } else if (phase.equals("restart")) {
                this.clearLoginMessages((PortletRequest)actionRequest);
                this.setView((PortletRequest)actionRequest, phase, 0);
            }
        }
    }

    private void failedLoginProcessing(ActionRequest actionRequest, String phase, String username, UserBean userBean) throws NotSerializableException, PortletException {
        int nextView = 3;
        User user = null;
        try {
            user = this.userManager.getUser(username);
        }
        catch (Exception e) {
            logger.error("Failed to retrieve user, {}: {}", (Object)username, (Object)e.getMessage());
            return;
        }
        UserCredential pwdCredential = null;
        try {
            pwdCredential = SecurityHelper.getCredential((UserManager)this.userManager, (User)user);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        RequestContext rc = SecurityHelper.getRequestContext((PortletRequest)actionRequest);
        if (pwdCredential != null) {
            userBean.setUser(user);
            HttpSession session = rc.getRequest().getSession(true);
            Integer retryCount = (Integer)session.getAttribute(RETRYCOUNT);
            retryCount = retryCount == null ? new Integer(1) : new Integer(retryCount + 1);
            session.setAttribute(RETRYCOUNT, (Object)retryCount);
            if (pwdCredential == null || !pwdCredential.isEnabled()) {
                rc.setSessionAttribute(ERRORCODE, (Object)LoginConstants.ERROR_CREDENTIAL_DISABLED);
                nextView = 4;
            } else if (pwdCredential.isExpired()) {
                rc.setSessionAttribute(ERRORCODE, (Object)LoginConstants.ERROR_CREDENTIAL_EXPIRED);
            } else if (this.maxNumberOfAuthenticationFailures > 1 && pwdCredential.getAuthenticationFailures() == this.maxNumberOfAuthenticationFailures - 1) {
                rc.setSessionAttribute(ERRORCODE, (Object)LoginConstants.ERROR_FINAL_LOGIN_ATTEMPT);
            } else {
                rc.setSessionAttribute(ERRORCODE, (Object)LoginConstants.ERROR_INVALID_PASSWORD);
            }
        }
        this.audit.logUserActivity(username, rc.getRequest().getRemoteAddr(), "login-failure", "MFA");
        this.setView((PortletRequest)actionRequest, phase, nextView);
    }

    private void clearLoginMessages(PortletRequest actionRequest) {
        RequestContext rc = SecurityHelper.getRequestContext((PortletRequest)actionRequest);
        HttpSession session = rc.getRequest().getSession(true);
        session.removeAttribute(RETRYCOUNT);
        session.removeAttribute(ERRORCODE);
        session.removeAttribute("org.apache.jetspeed.login.retrycount");
        session.removeAttribute("org.apache.jetspeed.login.errorcode");
    }

    private void redirect(ActionRequest actionRequest, ActionResponse actionResponse, String redirect, String username, String password) throws IOException {
        StringBuffer s = new StringBuffer();
        s.append(redirect);
        if (!redirect.endsWith("/")) {
            s.append("/");
        }
        s.append("login/proxy");
        RequestContext rc = SecurityHelper.getRequestContext((PortletRequest)actionRequest);
        HttpServletRequest request = rc.getRequest();
        HttpSession session = request.getSession(true);
        session.setAttribute("org.apache.jetspeed.login.username", (Object)username);
        session.setAttribute("org.apache.jetspeed.login.password", (Object)password);
        actionResponse.sendRedirect(s.toString());
    }

    public boolean generateQuestionAndAnswer(UserBean userBean) {
        User user = userBean.getUser();
        if (user == null) {
            if (userBean.getUsername() == null) {
                return false;
            }
            try {
                user = this.userManager.getUser(userBean.getUsername());
            }
            catch (Exception e) {
                userBean.setQuestion(this.questionFactory.getRandomQuestion());
                return false;
            }
        }
        Map userAttributes = userBean.getUser().getSecurityAttributes().getAttributeMap();
        String[] questions = new String[3];
        String[] answers = new String[3];
        int max = 3;
        questions[0] = this.getUserAttribute(userAttributes, "user.question.1", null);
        answers[0] = this.getUserAttribute(userAttributes, "user.answer.1", null);
        if (SecurityHelper.isEmpty((String)questions[0]) || SecurityHelper.isEmpty((String)answers[0])) {
            return false;
        }
        questions[1] = this.getUserAttribute(userAttributes, "user.question.2", null);
        answers[1] = this.getUserAttribute(userAttributes, "user.answer.2", null);
        if (SecurityHelper.isEmpty((String)questions[1]) || SecurityHelper.isEmpty((String)answers[1])) {
            userBean.setQuestion(questions[0]);
            userBean.setAnswer(answers[0]);
            return true;
        }
        questions[2] = this.getUserAttribute(userAttributes, "user.question.3", null);
        answers[2] = this.getUserAttribute(userAttributes, "user.answer.3", null);
        if (SecurityHelper.isEmpty((String)questions[2]) || SecurityHelper.isEmpty((String)answers[2])) {
            max = 2;
        }
        int index = this.rand.nextInt(max);
        userBean.setQuestion(questions[index]);
        userBean.setAnswer(answers[index]);
        return true;
    }

    private String getUserAttribute(Map<String, SecurityAttribute> map, String name, String defaultValue) {
        String value = defaultValue;
        SecurityAttribute sa = map.get(name);
        if (sa != null && (value = sa.getStringValue()) == null) {
            value = defaultValue;
        }
        return value;
    }
}

