/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mfa.util;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class ServerData {
    private String serverName = null;
    private int serverPort = 0;
    private String serverScheme = null;
    private String scriptName = null;
    private String contextPath = null;

    public ServerData(String serverName, int serverPort, String serverScheme, String scriptName, String contextPath) {
        this.setServerName(serverName);
        this.setServerPort(serverPort);
        this.setServerScheme(serverScheme);
        this.setScriptName(scriptName);
        this.setContextPath(contextPath);
    }

    public ServerData(ServerData serverData) {
        this.setServerName(serverData.getServerName());
        this.setServerPort(serverData.getServerPort());
        this.setServerScheme(serverData.getServerScheme());
        this.setScriptName(serverData.getScriptName());
        this.setContextPath(serverData.getContextPath());
    }

    public ServerData(HttpServletRequest req) {
        this.setServerName(req.getServerName());
        this.setServerPort(req.getServerPort());
        this.setServerScheme(req.getScheme());
        this.setScriptName(req.getServletPath());
        this.setContextPath(req.getContextPath());
    }

    public Object clone() {
        return new ServerData(this);
    }

    public String getServerName() {
        return StringUtils.isEmpty((String)this.serverName) ? "" : this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public String getServerScheme() {
        return StringUtils.isEmpty((String)this.serverScheme) ? "" : this.serverScheme;
    }

    public void setServerScheme(String serverScheme) {
        this.serverScheme = serverScheme;
    }

    public String getScriptName() {
        return StringUtils.isEmpty((String)this.scriptName) ? "" : this.scriptName;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public String getContextPath() {
        return StringUtils.isEmpty((String)this.contextPath) ? "" : this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getBasePath() {
        StringBuffer buf = new StringBuffer();
        this.getHostUrl(buf);
        return buf.toString();
    }

    public void getHostUrl(StringBuffer url) {
        url.append(this.getServerScheme());
        url.append("://");
        url.append(this.getServerName());
        if (this.getServerScheme().equals("http") && this.getServerPort() != 80 || this.getServerScheme().equals("https") && this.getServerPort() != 443) {
            url.append(":");
            url.append(this.getServerPort());
        }
    }

    public String toString() {
        StringBuffer url = new StringBuffer();
        this.getHostUrl(url);
        url.append(this.getContextPath());
        url.append(this.getScriptName());
        return url.toString();
    }
}

