/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller;

import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.ResultContainer;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.renderer.swing.SizeConstants;
import org.tp23.antinstaller.runtime.IfPropertyHelper;
import org.tp23.antinstaller.runtime.VersionHelper;
import org.tp23.antinstaller.runtime.exe.ExecuteRunnerFilter;

public class Installer {
    private static ResourceBundle langPack = null;
    private String name;
    private String minJavaVersion = "1.4";
    private String ui;
    private boolean verbose;
    private boolean debug;
    private String lookAndFeel;
    private String wide;
    private String windowIcon;
    private String defaultImageResource;
    private String finishButtonText = "Install";
    private String antialiased;
    private String loadDefaults;
    private String version = "0.0";
    private Page[] pages;
    private ResultContainer resultContainer = new ResultContainer();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMinJavaVersion() {
        return this.minJavaVersion;
    }

    public void setMinJavaVersion(String minJavaVersion) throws ExecuteRunnerFilter.AbortException {
        VersionHelper helper;
        if (minJavaVersion != null && !"".equals(minJavaVersion) && !(helper = new VersionHelper()).equalOrHigher(System.getProperty("java.version"), minJavaVersion, true)) {
            throw new ExecuteRunnerFilter.AbortException("Incorrect Java version, installer requires: " + minJavaVersion);
        }
        this.minJavaVersion = minJavaVersion;
    }

    public Page[] getPages() {
        return this.pages;
    }

    public void setPages(Page[] pages) {
        this.pages = pages;
    }

    public String getUi() {
        return this.ui;
    }

    public void setUi(String ui) {
        this.ui = ui.replaceAll("\\s", "");
    }

    public boolean supportsAutoBuild() {
        return this.ui != null && this.ui.indexOf("-auto") > -1;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setVerbose(String strVerbose) {
        this.verbose = OutputField.isTrue(strVerbose);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setDebug(String strDebug) {
        this.debug = OutputField.isTrue(strDebug);
    }

    public String getLookAndFeel() {
        return this.lookAndFeel;
    }

    public void setLookAndFeel(String lookAndFeel) {
        this.lookAndFeel = lookAndFeel;
    }

    public String getWindowIcon() {
        return this.windowIcon;
    }

    public void setWindowIcon(String windowIcon) {
        this.windowIcon = windowIcon;
    }

    public String getDefaultImageResource() {
        return this.defaultImageResource;
    }

    public void setDefaultImageResource(String defaultImageResource) {
        this.defaultImageResource = defaultImageResource;
    }

    public String getFinishButtonText() {
        if (langPack != null) {
            return langPack.getString("finishButtonText");
        }
        return this.finishButtonText;
    }

    public void setFinishButtonText(String finishButtonText) {
        this.finishButtonText = finishButtonText;
    }

    public ResultContainer getResultContainer() {
        return this.resultContainer;
    }

    public String getAntialiased() {
        return this.antialiased;
    }

    public void setAntialiased(String antialiased) {
        this.antialiased = antialiased;
    }

    public String getWide() {
        return this.wide;
    }

    public void setWide(String wide) {
        try {
            this.wide = wide;
            this.parseWideValue(wide);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void parseWideValue(String wide) throws NumberFormatException, StringIndexOutOfBoundsException {
        int pageWidth = Integer.parseInt(wide.substring(0, wide.indexOf(58)));
        int labelWidth = Integer.parseInt(wide.substring(wide.indexOf(58) + 1, wide.length()));
        SizeConstants.PAGE_WIDTH = pageWidth;
        SizeConstants.LABEL_WIDTH = labelWidth;
    }

    public String getLoadDefaults() {
        return this.loadDefaults;
    }

    public void setLoadDefaults(String loadDefaults) {
        this.loadDefaults = loadDefaults;
    }

    public Vector getTargets(InstallerContext ctx) {
        Vector<String> argsList = new Vector<String>();
        for (int i = 0; i < this.getPages().length; ++i) {
            Page page = this.getPages()[i];
            List pageTargets = page.getPageTargets();
            boolean shown = this.conditionalDisplay(page, ctx);
            for (int pt = 0; pt < pageTargets.size(); ++pt) {
                Page.IndexedTarget target = (Page.IndexedTarget)pageTargets.get(pt);
                if (argsList.contains(target.getTarget()) || !shown) continue;
                argsList.add(target.getTarget());
            }
            List elementTargets = page.getElementTargets();
            for (int pt = 0; pt < elementTargets.size(); ++pt) {
                Page.IndexedTarget target = (Page.IndexedTarget)elementTargets.get(pt);
                if (argsList.contains(target.getTarget())) continue;
                argsList.add(target.getTarget());
            }
        }
        return argsList;
    }

    private boolean conditionalDisplay(Page page, InstallerContext ctx) {
        try {
            IfPropertyHelper helper = new IfPropertyHelper(ctx);
            return helper.ifProperty(page) && helper.ifTarget(page, ctx.getInstaller().getPages());
        }
        catch (InstallException e) {
            throw new RuntimeException("ifProperty runtime exception");
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    static {
        try {
            langPack = ResourceBundle.getBundle("resources.LanguagePack");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

