/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.page;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.TargetInput;
import org.tp23.antinstaller.runtime.IfPropertyHelper;

public abstract class Page {
    private static ResourceBundle langPack = null;
    private String name;
    private String displayText;
    private String imageResource;
    private OutputField[] outputField;
    private boolean abort;
    private String postDisplayTarget;
    private Set targets = new TreeSet();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayText() {
        if (langPack != null) {
            return langPack.getString("page." + this.getName() + ".displayText");
        }
        return this.displayText;
    }

    public void setDisplayText(String displayText) {
        this.displayText = displayText;
    }

    public String getImageResource() {
        return this.imageResource;
    }

    public void setImageResource(String imageResource) {
        this.imageResource = imageResource;
    }

    public OutputField[] getOutputField() {
        return this.outputField;
    }

    public void setOutputField(OutputField[] outputField) {
        this.outputField = outputField;
    }

    public String getPostDisplayTarget() {
        return this.postDisplayTarget;
    }

    public void setPostDisplayTarget(String runtimeTarget) {
        this.postDisplayTarget = runtimeTarget;
    }

    public List getTargets(InstallerContext ctx) {
        ArrayList<String> results = new ArrayList<String>(this.targets.size());
        try {
            Iterator iter = this.targets.iterator();
            IfPropertyHelper helper = new IfPropertyHelper(ctx);
            while (iter.hasNext()) {
                IndexedTarget idxTarget = (IndexedTarget)iter.next();
                if ("page".equals(idxTarget.getTargetType())) {
                    if (!helper.ifProperty(this) && !helper.ifTarget(this, ctx.getInstaller().getPages())) continue;
                    results.add(idxTarget.target);
                    continue;
                }
                results.add(idxTarget.target);
            }
        }
        catch (InstallException e) {
            e.printStackTrace();
            ctx.log(ctx.getInstaller().isVerbose(), e);
            throw new RuntimeException();
        }
        return results;
    }

    public List getAllTargets() {
        ArrayList<String> results = new ArrayList<String>(this.targets.size());
        Iterator iter = this.targets.iterator();
        while (iter.hasNext()) {
            IndexedTarget idxTarget = (IndexedTarget)iter.next();
            results.add(idxTarget.target);
        }
        return results;
    }

    public void setTarget(String targetList) {
        StringTokenizer st = new StringTokenizer(targetList, ",");
        while (st.hasMoreTokens()) {
            this.targets.add(new IndexedTarget(TargetInput.getGlobalIdx(), st.nextToken(), "page"));
        }
    }

    public void addTarget(int idx, String target) {
        this.targets.add(new IndexedTarget(idx, target, "input"));
    }

    public void removeTarget(int idx) {
        this.targets.remove(new IndexedTarget(idx, null));
    }

    public boolean isTarget(String target) {
        if (target == null) {
            return false;
        }
        Iterator iter = this.targets.iterator();
        while (iter.hasNext()) {
            IndexedTarget idxTarget = (IndexedTarget)iter.next();
            if (!idxTarget.target.equals(target)) continue;
            return true;
        }
        return false;
    }

    public List getPageTargets() {
        ArrayList<IndexedTarget> toReturn = new ArrayList<IndexedTarget>(this.targets.size());
        Iterator iter = this.targets.iterator();
        while (iter.hasNext()) {
            IndexedTarget idxTarget = (IndexedTarget)iter.next();
            if (!"page".equals(idxTarget.targetType)) continue;
            toReturn.add(idxTarget);
        }
        return toReturn;
    }

    public List getElementTargets() {
        ArrayList<IndexedTarget> toReturn = new ArrayList<IndexedTarget>(this.targets.size());
        Iterator iter = this.targets.iterator();
        while (iter.hasNext()) {
            IndexedTarget idxTarget = (IndexedTarget)iter.next();
            if (!"input".equals(idxTarget.targetType)) continue;
            toReturn.add(idxTarget);
        }
        return toReturn;
    }

    public boolean isAbort() {
        return this.abort;
    }

    public void setAbort(boolean abort) {
        this.abort = abort;
    }

    static {
        try {
            langPack = ResourceBundle.getBundle("LanguagePack");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public static class IndexedTarget
    implements Comparable {
        private static final String PAGE = "page";
        private static final String INPUT = "input";
        int idx;
        String target;
        String targetType = "input";

        IndexedTarget(int idx, String target) {
            this.idx = idx;
            this.target = target;
        }

        IndexedTarget(int idx, String target, String targetType) {
            this.idx = idx;
            this.target = target;
            this.targetType = targetType;
        }

        public boolean equals(Object target) {
            IndexedTarget test = (IndexedTarget)target;
            return test.idx == this.idx;
        }

        public int hashCode() {
            return this.idx;
        }

        public int compareTo(Object o) {
            IndexedTarget test = (IndexedTarget)o;
            return this.idx - test.idx;
        }

        public String getTarget() {
            return this.target;
        }

        public String getTargetType() {
            return this.targetType;
        }
    }
}

