/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.gui.widget;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class DefaultingDirectoryChooser
extends JFileChooser {
    public static final boolean CREATE_MODE = true;
    public static final boolean EXISTING_MODE = false;
    private boolean createMode = false;
    private File selectedFile = null;
    private String desiredName = null;

    public DefaultingDirectoryChooser(boolean createMode) {
        this.createMode = createMode;
        if (createMode) {
            this.setFileSelectionMode(2);
            this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
            this.addChoosableFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    if (f.exists() && f.isDirectory()) {
                        return true;
                    }
                    return !f.exists() && DefaultingDirectoryChooser.this.getFileSystemView().getParentDirectory(f).isDirectory();
                }

                public String getDescription() {
                    return "Directories";
                }
            });
            this.addPropertyChangeListener("directoryChanged", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    File directory = (File)evt.getNewValue();
                    DefaultingDirectoryChooser.this.setCurrentDirectory(new File(directory, "newfolder"));
                    DefaultingDirectoryChooser.this.setSelectedFile(new File(directory, DefaultingDirectoryChooser.this.desiredName));
                }
            });
        } else {
            this.setFileSelectionMode(1);
        }
    }

    public void setDefaultDirectory(File dir) {
        if (dir == null) {
            return;
        }
        if (this.createMode) {
            if (this.desiredName == null) {
                this.desiredName = dir.getName();
            }
            File selected = this.determineCreateDir(dir);
            super.setCurrentDirectory(selected.getParentFile());
            this.setSelectedFile(selected);
        } else {
            super.setCurrentDirectory(this.determineExistingDir(dir));
        }
    }

    private File determineExistingDir(File defaultDir) {
        if (defaultDir.exists()) {
            return defaultDir;
        }
        FileSystemView fsv = this.getFileSystemView();
        File validParent = this.getFSVParent(fsv, defaultDir);
        if (validParent != null) {
            return validParent;
        }
        return fsv.getHomeDirectory();
    }

    private File determineCreateDir(File defaultDir) {
        if (defaultDir.exists()) {
            return defaultDir;
        }
        FileSystemView fsv = this.getFileSystemView();
        String dirName = defaultDir.getName();
        File validParent = this.getFSVParent(fsv, defaultDir);
        if (validParent != null) {
            return new File(validParent, dirName);
        }
        return new File(fsv.getHomeDirectory(), dirName);
    }

    private File getFSVParent(FileSystemView fsv, File dir) {
        File parent = dir.getParentFile();
        if (fsv.isRoot(parent) && !parent.exists()) {
            return null;
        }
        if (!parent.exists() || !fsv.isFileSystem(parent)) {
            parent = this.getFSVParent(fsv, parent);
        }
        return parent;
    }

    public static void main(String[] args) {
        DefaultingDirectoryChooser chooser = new DefaultingDirectoryChooser(true);
        chooser.setDefaultDirectory(new File("/usr/local/dibble/MyApp"));
        chooser.showDialog(null, "Select");
        System.out.println("Selected:" + chooser.getSelectedFile().getAbsolutePath());
        System.exit(0);
    }
}

