package org.apache.jetspeed.portlet;

import org.apache.jetspeed.portlet.*;

import java.util.Hashtable;
import java.util.Map;

/**
 * The <CODE>DefaultPortletAction</CODE> is a portlet action with
 * default parameters. You can use this portlet action to pass
 * parameters in your action or create your own portlet action. This
 * default implementation demonstrates how to implement it.
 * 
 * @author <A HREF="mailto:shesmer@raleigh.ibm.com">Stephan Hesmer</A>
 * @see PortletAction
 */
public final class DefaultPortletAction implements PortletAction, java.io.Serializable
{
    /**
     * the name of this action
     */
    private String name = null;
    /**
     * all parameters passed by this action
     */
    private Hashtable parameters = null;

    public DefaultPortletAction(String name)
    {
        this.name = name;
        parameters = new Hashtable();
    }

    /**
     * Returns the name of this action
     * 
     * @return the name as a string
     */
    public String getName()
    {
        return name;
    }

    /**
     * Adds a parameters to this action
     * 
     * @param name   the name of the new parameter
     * @param value  the value of the new parameter
     */
    public void addParameter(String name, Object value)
    {
        parameters.put(name, value);
    }

    /**
     * Returns all parameters
     * 
     * @return all parameters as map
     */
    public Map getParameters()
    {
        return parameters;
    }

}
