package org.apache.jetspeed.portlet.event;

import org.apache.jetspeed.portlet.*;

/**
 * Implementations of this interface receive notifications of changes to the
 * attribute list on the portlet settings of a concrete portlet.
 * To recieve notification events, this interface has to be implemented
 * additionally to the <CODE>Portlet</CODE> interface.
 * <P>
 * <I>Still under discussion: This is not really similar to the servlet context.
 * The portlet settings are only available to one "portlet" and can not be changed
 * by another portlet as in the case of the context. So, it is hard to explain in
 * this case, why the portlet settings can be changed from someone else as the
 * portlet itself. The servlet concept would call destroy and init.</I>
 * </P>
 * 
 * @author <A HREF="mailto:shesmer@apache.org">Stephan Hesmer</A>
 * @since Version 1.1
 */
public interface PortletSettingsAttributesListener
{

    /**
     * Notification that a new attribute was added to the portlet settings.
     * Called after the attribute is added.
     * 
     * @param event the attribute event
     */
    public void attributeAdded(PortletSettingsAttributeEvent event);

    /**
     * Notification that an existing attribute has been remved from the portlet settings.
     * Called after the attribute is removed.
     * 
     * @param event the attribute event
     */
    public void attributeRemoved(PortletSettingsAttributeEvent event);

    /**
     * Notification that an attribute in the portlet settings has been replaced.
     * Called after the attribute is replaced.
     * 
     * @param event the attribute event
     */
    public void attributeReplaced(PortletSettingsAttributeEvent event);

}
