package org.apache.jetspeed.portletcontainer;

// jetspeed
import org.apache.jetspeed.portlet.*;
import org.apache.jetspeed.portlet.event.*;
import org.apache.jetspeed.portletcontainer.om.applicationregistry.*;
import org.apache.jetspeed.portletcontainer.om.portletregistry.*;
import org.apache.jetspeed.portletcontainer.util.*;
import org.apache.jetspeed.portletcontainer.information.*;
import org.apache.jetspeed.portletcontainer.filter.*;

// turbine
import org.apache.turbine.util.Log;
import org.apache.turbine.services.resources.TurbineResources;

// java
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.HashMap;
import java.util.Map;
import java.util.Locale;
import java.io.IOException;
import javax.servlet.*;

public class PortletApplicationSettingsImpl implements PortletApplicationSettings
{
    private int                         caidInt;
    private ConcreteApplicationEntry    concreteApplicationEntry = null;
    private PortletEntry                rootPortlet = null;
    private PortalInformationProvider   provider = null;
    private boolean                     isDirty = false;
    private HashMap                     attributes = null;
    
    public PortletApplicationSettingsImpl(ConcretePortletEntry concretePortletEntry,
                                          PortalInformationProvider provider)
    {
        this.provider = provider;
        this.concreteApplicationEntry = concretePortletEntry.getConcreteApplication();
        this.rootPortlet = concretePortletEntry.getRootPortlet();
        caidInt = concreteApplicationEntry.getAid().intValue();
    }
    
    public void setAttribute (String name, String value) throws AccessDeniedException
    {
        if (!isAllowed())
            throw new AccessDeniedException();
        
        if (!isInitialized())
            init();

        attributes.put( name, value );
        setDirty(true);
    }

    public String getAttribute (String name)
    {
        if (!isInitialized())
            init();

        return (String)attributes.get( name );
    }

    public Enumeration getAttributeNames ()
    {
        if (!isInitialized())
            init();

        return new Hashtable(attributes).keys();
    }

    public void removeAttribute (String name) throws AccessDeniedException
    {
        if (!isAllowed())
            throw new AccessDeniedException();
        
        if (!isInitialized())
            init();

        attributes.remove( name );        
        setDirty(true);
    }

    public void store () throws AccessDeniedException, IOException
    {
        if (!isAllowed())
            throw new AccessDeniedException();
        
        if (!isInitialized())
            init();

        if (isDirty())
        {
            if (concreteApplicationEntry!=null)
            {
                HashMap orgSettings = new HashMap();
                orgSettings.putAll(concreteApplicationEntry.getParameters());
                
                try
                {
                    concreteApplicationEntry.setParameters(attributes);
                    provider.setConcretePortletApplicationEntry(concreteApplicationEntry);
                }
                catch (IOException e)
                {
                    org.apache.turbine.util.Log.error("PortletApplicationSettingsImpl.store: Unable to store portlet application settings for AID="+hashCode(),e);
                    throw e;
                }
                setDirty(false);

                // send events to all portlets of this application
                PortletRequestImpl request = 
                    (PortletRequestImpl)ThreadAttributesManager.getAttribute(
                        org.apache.jetspeed.portlet.spi.Constants.PARAM_PORTLETREQUEST);
                
                if (request!=null)
                {
                    ConcretePortletEntry concretePortlet = request.getPortletInstanceEntry().getConcretePortlet();
                    org.apache.jetspeed.services.portletregistry.PortletRegistryAccess.
                        applicationSettingsChanged(concretePortlet,
                                                   orgSettings);
                }

            }
        }
    }

    // additional methods

    /**
     * Returns true if the data was changed
     * 
     * @return a boolean indicating a change of the data
     */
    public boolean isDirty()
    {
        return isDirty;
    }

    private void addAllFrom (Map parameters)
    {
        attributes.putAll(parameters);
        setDirty(false);
    }

    private void setDirty(boolean dirty)
    {
        isDirty = dirty;
    }

    private boolean isInitialized()
    {
        return attributes!=null;
    }

    private boolean isAllowed()
    {
        if (org.apache.turbine.services.resources.TurbineResources.getBoolean(
            Constants.RESTRICT_ACCESS,true))
        {
            if (!com.ibm.wps.util.ListenerConverter.isIgnoreModeToStoreData(
                ((com.ibm.wps.portletcontainer.PortletEntryImpl)rootPortlet).getListeners()) )
            {
                Portlet.Mode portletMode = 
                    (Portlet.Mode)ThreadAttributesManager.getAttribute(Constants.PORTLET_MODE);
                if (portletMode==null)
                    return false;
                if (portletMode!=Portlet.Mode.CONFIGURE)
                    return false;
            }
        }
        return true;
    }

    private void init()
    {
        // allow late initialization of attributes
        if (!isInitialized())
        {
            attributes = new HashMap();
            if (this.concreteApplicationEntry!=null)
            {
                addAllFrom(this.concreteApplicationEntry.getParameters());
            }
        }
    }

    // needs to be overwritten, because the Portlet API depends on equal Settings objects for
    // one Concrete Portlet

    public boolean equals( Object obj ) {
        if ( this == obj) {
            return true;
        }
        
        if (obj instanceof PortletApplicationSettingsImpl) {
            PortletApplicationSettingsImpl comp = (PortletApplicationSettingsImpl)obj;
            return this.hashCode()==comp.hashCode();
        } else {
            return false;
        }
    }

    public int hashCode()
    {
        return caidInt;
    }
}
