/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.driver;

import java.io.InputStream;
import java.util.Set;
import javax.portlet.annotations.PortletApplication;
import javax.portlet.annotations.PortletConfiguration;
import javax.portlet.annotations.PortletConfigurations;
import javax.portlet.annotations.PortletLifecycleFilter;
import javax.portlet.annotations.PortletListener;
import javax.portlet.annotations.PortletPreferencesValidator;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.HandlesTypes;
import org.apache.pluto.container.driver.PortletServlet3;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.impl.ConfigurationHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HandlesTypes(value={PortletApplication.class, PortletConfiguration.class, PortletLifecycleFilter.class, PortletConfigurations.class, PortletListener.class, PortletPreferencesValidator.class})
public class PortletContainerInitializer
implements ServletContainerInitializer {
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private static final String PORTLET_XML = "/WEB-INF/portlet.xml";
    private static final Logger LOG = LoggerFactory.getLogger(PortletContainerInitializer.class);
    private static boolean isDebug = LOG.isDebugEnabled();

    public void onStartup(Set<Class<?>> classes, ServletContext ctx) throws ServletException {
        try {
            ConfigurationHolder holder = new ConfigurationHolder();
            holder.scanMethodAnnotations(ctx);
            if (classes != null) {
                holder.processConfigAnnotations(classes);
            }
            InputStream win = ctx.getResourceAsStream(WEB_XML);
            InputStream pin = ctx.getResourceAsStream(PORTLET_XML);
            if (isDebug) {
                StringBuilder txt = new StringBuilder(128);
                txt.append("$$$ ServletContainerInitializer. ctx path: ").append(ctx.getContextPath());
                txt.append(", servlet ctx name: ").append(ctx.getServletContextName());
                txt.append(", # portlet annotations: ").append(classes != null ? Integer.valueOf(classes.size()) : "null");
                txt.append(", found web.xml: ").append(win != null);
                txt.append(", found portlet.xml: ").append(pin != null);
                LOG.debug(txt.toString());
            }
            if (pin != null) {
                holder.processPortletDD(pin);
            }
            if (win != null) {
                holder.processWebDD(win);
            }
            holder.validate();
            holder.reconcileBeanConfig();
            if (holder.getPad().getPortlets().size() > 0) {
                ctx.setAttribute("PortletAppConfig", (Object)holder);
                for (PortletDefinition pd : holder.getPad().getPortlets()) {
                    String pn = pd.getPortletName();
                    String mapping = "/PlutoInvoker3/" + pn;
                    String servletName = pn + "_PS3";
                    if (isDebug) {
                        StringBuilder txt = new StringBuilder();
                        txt.append("Adding PortletServlet3. Portlet name: ");
                        txt.append(pn);
                        txt.append(", servlet name: ").append(servletName);
                        txt.append(", mapping: ").append(mapping);
                        LOG.debug(txt.toString());
                    }
                    ServletRegistration.Dynamic sr = ctx.addServlet(servletName, PortletServlet3.class);
                    sr.addMapping(new String[]{mapping});
                    sr.setInitParameter("portlet-name", pn);
                    sr.setAsyncSupported(true);
                    if (pd.isMultipartSupported()) {
                        MultipartConfigElement mce = new MultipartConfigElement(pd.getLocation(), pd.getMaxFileSize().longValue(), pd.getMaxRequestSize().longValue(), pd.getFileSizeThreshold().intValue());
                        sr.setMultipartConfig(mce);
                    }
                    sr.setLoadOnStartup(100);
                }
                LOG.debug("Completed deployment of servlets & filters for context: " + ctx.getContextPath());
            } else {
                LOG.debug("No portlet definitions for context: " + ctx.getServletContextName());
            }
        }
        catch (Exception e) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Exception processing portlet application configuration");
            txt.append(", Servlet ctx name: ").append(ctx.getServletContextName());
            txt.append(", Exception: ").append(e.toString());
            LOG.info(txt.toString());
        }
    }
}

