/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.weld.logging.MetadataLogger;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Formats;

public class AnnotatedTypeValidator {
    private AnnotatedTypeValidator() {
    }

    public static void validateAnnotated(Annotated annotated) {
        AnnotatedTypeValidator.checkNotNull(annotated.getAnnotations(), "getAnnotations()", annotated);
        AnnotatedTypeValidator.checkNotNull(annotated.getBaseType(), "getBaseType()", annotated);
        AnnotatedTypeValidator.checkNotNull(annotated.getTypeClosure(), "getTypeClosure()", annotated);
    }

    public static void validateAnnotatedParameter(AnnotatedParameter<?> parameter) {
        AnnotatedTypeValidator.validateAnnotated(parameter);
        if (parameter.getPosition() < 0) {
            throw MetadataLogger.LOG.invalidParameterPosition(parameter.getPosition(), parameter);
        }
        AnnotatedTypeValidator.checkNotNull(parameter.getDeclaringCallable(), "getDeclaringCallable()", parameter);
    }

    public static void validateAnnotatedMember(AnnotatedMember<?> member) {
        AnnotatedTypeValidator.validateAnnotated(member);
        AnnotatedTypeValidator.checkNotNull(member.getJavaMember(), "getJavaMember()", member);
        AnnotatedTypeValidator.checkNotNull(member.getDeclaringType(), "getDeclaringType()", member);
    }

    public static void validateAnnotatedType(AnnotatedType<?> type) {
        AnnotatedTypeValidator.validateAnnotated(type);
        AnnotatedTypeValidator.checkNotNull(type.getJavaClass(), "getJavaClass()", type);
        AnnotatedTypeValidator.checkNotNull(type.getFields(), "getFields()", type);
        AnnotatedTypeValidator.checkNotNull(type.getConstructors(), "getConstructors()", type);
        AnnotatedTypeValidator.checkNotNull(type.getMethods(), "getMethods()", type);
        AnnotatedTypeValidator.checkSensibility(type);
    }

    private static void checkNotNull(Object expression, String methodName, Object target) {
        if (expression == null) {
            throw MetadataLogger.LOG.metadataSourceReturnedNull(methodName, target);
        }
    }

    private static void checkSensibility(AnnotatedType<?> type) {
        if (type.getConstructors().isEmpty() && !type.getJavaClass().isInterface()) {
            MetadataLogger.LOG.noConstructor(type);
        }
        HashSet hierarchy = new HashSet();
        for (Class<?> clazz = type.getJavaClass(); clazz != null; clazz = clazz.getSuperclass()) {
            hierarchy.add(clazz);
            WeldCollections.addAll(hierarchy, clazz.getInterfaces());
        }
        AnnotatedTypeValidator.checkMembersBelongToHierarchy(type.getConstructors(), hierarchy, type);
        AnnotatedTypeValidator.checkMembersBelongToHierarchy(type.getMethods(), hierarchy, type);
        AnnotatedTypeValidator.checkMembersBelongToHierarchy(type.getFields(), hierarchy, type);
    }

    private static void checkMembersBelongToHierarchy(Iterable<? extends AnnotatedMember<?>> members, Set<Class<?>> hierarchy, AnnotatedType<?> type) {
        for (AnnotatedMember<?> member : members) {
            if (hierarchy.contains(member.getJavaMember().getDeclaringClass())) continue;
            MetadataLogger.LOG.notInHierarchy(member.getJavaMember().getName(), member.toString(), type.getJavaClass().getName(), type.toString(), Formats.formatAsStackTraceElement(member.getJavaMember()));
        }
    }
}

