/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.processor;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletRequestScopedBeanHolder
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(PortletRequestScopedBeanHolder.class);
    private static final boolean isTrace = LOG.isTraceEnabled();
    private static final long serialVersionUID = 6014843414216617217L;
    private static final ThreadLocal<PortletRequestScopedBeanHolder> holders = new ThreadLocal();
    private Map<Contextual<?>, BeanInstance<?>> beans = new ConcurrentHashMap();

    private PortletRequestScopedBeanHolder() {
    }

    public static void setBeanHolder() {
        if (isTrace) {
            StringBuilder txt = new StringBuilder(80);
            txt.append("Setting portlet request bean holder.");
            txt.append(" ThreadId=").append(Thread.currentThread().getId());
            LOG.trace(txt.toString());
        }
        PortletRequestScopedBeanHolder holder = new PortletRequestScopedBeanHolder();
        holders.set(holder);
    }

    public static void removeBeanHolder() {
        PortletRequestScopedBeanHolder bh = PortletRequestScopedBeanHolder.getBeanHolder();
        if (bh != null) {
            bh.removeAll();
        }
        holders.remove();
        if (isTrace) {
            StringBuilder txt = new StringBuilder(80);
            txt.append("Removed portlet request bean holder.");
            txt.append(" ThreadId=").append(Thread.currentThread().getId());
            LOG.trace(txt.toString());
        }
    }

    public static PortletRequestScopedBeanHolder getBeanHolder() {
        return holders.get();
    }

    public static PortletRequestScopedBeanHolder deregister() {
        PortletRequestScopedBeanHolder holder = holders.get();
        holders.remove();
        return holder;
    }

    public static void register(PortletRequestScopedBeanHolder holder) {
        holders.set(holder);
    }

    public <T> T getBean(Contextual<T> bean) {
        BeanInstance<?> bi = this.beans.get(bean);
        return bi == null ? null : (T)bi.instance;
    }

    public <T> T getBean(Contextual<T> bean, CreationalContext<T> crco) {
        BeanInstance<Object> bi = this.beans.get(bean);
        if (bi == null) {
            BeanInstance newbi = new BeanInstance();
            newbi.crco = crco;
            newbi.instance = bean.create(crco);
            bi = newbi;
            this.beans.put(bean, newbi);
            if (isTrace) {
                StringBuilder txt = new StringBuilder(80);
                txt.append("Created bean: ");
                txt.append(((Bean)bean).getBeanClass().getSimpleName());
                LOG.trace(txt.toString());
            }
        }
        return bi.instance;
    }

    protected <T> void remove(Contextual<T> bean) {
        BeanInstance<?> bi = this.beans.get(bean);
        if (isTrace) {
            StringBuilder txt = new StringBuilder(80);
            txt.append("Removing portlet request scoped bean: ");
            if (bean instanceof Bean) {
                Bean b = (Bean)bean;
                txt.append(b.getBeanClass().getSimpleName());
            }
            if (bi == null) {
                txt.append(", instance is null.");
            }
            LOG.trace(txt.toString());
        }
        if (bi != null) {
            this.beans.remove(bean);
            bi.crco.release();
            bean.destroy(bi.instance, bi.crco);
        }
    }

    protected void removeAll() {
        for (Contextual<?> bean : this.beans.keySet()) {
            this.remove(bean);
        }
    }

    private class BeanInstance<T>
    implements Serializable {
        private static final long serialVersionUID = -4173708394115905180L;
        CreationalContext<T> crco;
        T instance;

        private BeanInstance() {
        }
    }
}

