/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.mvc;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.mvc.MvcContext;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.QueryParam;
import org.apache.pluto.container.bean.mvc.BeanValidationInterceptorBinding;
import org.apache.pluto.container.bean.mvc.BeanValidationMessageInterpolator;
import org.apache.pluto.container.bean.mvc.MessageInterpolatorContextImpl;
import org.apache.pluto.container.bean.mvc.MutableBindingResult;
import org.apache.pluto.container.bean.mvc.ValidationErrorImpl;

@Interceptor
@BeanValidationInterceptorBinding
@Priority(value=1000)
public class BeanValidationInterceptor
implements Serializable {
    private static final long serialVersionUID = 2378576156374329311L;
    @BeanValidationMessageInterpolator
    @Inject
    private MessageInterpolator messageInterpolator;
    @Inject
    private MutableBindingResult mutableBindingResult;
    @Inject
    private MvcContext mvcContext;
    @Inject
    private ValidatorFactory validatorFactory;

    /*
     * WARNING - void declaration
     */
    @AroundInvoke
    public Object validateMethodInvocation(InvocationContext invocationContext) throws Exception {
        Validator validator = this.validatorFactory.getValidator();
        if (validator == null) {
            return invocationContext.proceed();
        }
        Set constraintViolations = validator.validate(invocationContext.getTarget(), new Class[0]);
        for (ConstraintViolation constraintViolation : constraintViolations) {
            void var15_17;
            Annotation[] annotations;
            PropertyDescriptor[] propertyDescriptors;
            Path propertyPath = constraintViolation.getPropertyPath();
            Path.Node lastPathNode = null;
            Iterator iterator = propertyPath.iterator();
            while (iterator.hasNext()) {
                Path.Node pathNode;
                lastPathNode = pathNode = (Path.Node)iterator.next();
            }
            if (lastPathNode == null || lastPathNode.getKind() != ElementKind.PROPERTY) continue;
            Object leafBean = constraintViolation.getLeafBean();
            Class leafBeanClass = leafBean.getClass();
            BeanInfo beanInfo = Introspector.getBeanInfo(leafBean.getClass());
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String propertyDescriptorName = propertyDescriptor.getName();
                if (!propertyDescriptorName.equals("targetClass")) continue;
                Method readMethod = propertyDescriptor.getReadMethod();
                leafBeanClass = (Class)readMethod.invoke(leafBean, new Object[0]);
            }
            Field leafBeanField = leafBeanClass.getDeclaredField(lastPathNode.getName());
            String paramName = null;
            for (Annotation annotation : annotations = leafBeanField.getAnnotations()) {
                if (annotation instanceof CookieParam) {
                    CookieParam cookieParam = (CookieParam)annotation;
                    paramName = cookieParam.value();
                    break;
                }
                if (annotation instanceof FormParam) {
                    FormParam formParam = (FormParam)annotation;
                    paramName = formParam.value();
                    break;
                }
                if (annotation instanceof HeaderParam) {
                    HeaderParam headerParam = (HeaderParam)annotation;
                    paramName = headerParam.value();
                    break;
                }
                if (!(annotation instanceof QueryParam)) continue;
                QueryParam queryParam = (QueryParam)annotation;
                paramName = queryParam.value();
            }
            String string = constraintViolation.getMessage();
            if (this.messageInterpolator != null) {
                String string2 = this.messageInterpolator.interpolate(constraintViolation.getMessageTemplate(), (MessageInterpolator.Context)new MessageInterpolatorContextImpl(constraintViolation), this.mvcContext.getLocale());
            }
            this.mutableBindingResult.addValidationError(new ValidationErrorImpl(paramName, (String)var15_17, constraintViolation));
        }
        return invocationContext.proceed();
    }
}

