/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.mvc;

import javax.mvc.engine.ViewEngine;
import javax.mvc.engine.ViewEngineContext;
import javax.mvc.engine.ViewEngineException;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.ws.rs.core.Configuration;

public class ViewEngineJspImpl
implements ViewEngine {
    private final Configuration configuration;
    private final PortletContext portletContext;

    public ViewEngineJspImpl(Configuration configuration, PortletContext portletContext) {
        this.configuration = configuration;
        this.portletContext = portletContext;
    }

    public void processView(ViewEngineContext viewEngineContext) throws ViewEngineException {
        String view = viewEngineContext.getView();
        String viewFolder = (String)this.configuration.getProperty("javax.mvc.engine.ViewEngine.viewFolder");
        if (viewFolder == null) {
            viewFolder = "/WEB-INF/views/";
        }
        String viewPath = viewFolder.concat(view);
        PortletRequestDispatcher requestDispatcher = this.portletContext.getRequestDispatcher(viewPath);
        try {
            requestDispatcher.include((PortletRequest)viewEngineContext.getRequest(PortletRequest.class), (PortletResponse)viewEngineContext.getResponse(PortletResponse.class));
        }
        catch (Exception e) {
            throw new ViewEngineException((Throwable)e);
        }
    }

    public boolean supports(String view) {
        return view != null && (view.endsWith(".jsp") || view.endsWith(".jspx"));
    }
}

