/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.processor;

import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.mvc.RedirectScoped;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.annotations.ActionMethod;
import javax.portlet.annotations.DestroyMethod;
import javax.portlet.annotations.EventMethod;
import javax.portlet.annotations.HeaderMethod;
import javax.portlet.annotations.InitMethod;
import javax.portlet.annotations.PortletSerializable;
import javax.portlet.annotations.PortletSessionScoped;
import javax.portlet.annotations.RenderMethod;
import javax.portlet.annotations.RenderStateScoped;
import javax.portlet.annotations.ServeResourceMethod;
import org.apache.pluto.container.bean.processor.AnnotatedMethod;
import org.apache.pluto.container.bean.processor.AnnotatedMethodStore;
import org.apache.pluto.container.bean.processor.AnnotationRecognizer;
import org.apache.pluto.container.bean.processor.ConfigSummary;
import org.apache.pluto.container.bean.processor.InvalidAnnotationException;
import org.apache.pluto.container.bean.processor.MethodDescription;
import org.apache.pluto.container.bean.processor.MethodIdentifier;
import org.apache.pluto.container.bean.processor.MethodType;
import org.apache.pluto.container.bean.processor.PortletRequestScopedAnnotatedType;
import org.apache.pluto.container.bean.processor.PortletSessionScopedAnnotatedType;
import org.apache.pluto.container.bean.processor.PortletSessionScopedConfig;
import org.apache.pluto.container.bean.processor.PortletStateScopedConfig;
import org.apache.pluto.container.bean.processor.RedirectScopedConfig;
import org.apache.pluto.container.bean.processor.SignatureVariant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletAnnotationRecognizer
extends AnnotationRecognizer {
    private static final Logger LOG = LoggerFactory.getLogger(PortletAnnotationRecognizer.class);
    private static final Set<Class<? extends Annotation>> classAnnotations = new HashSet<Class<? extends Annotation>>();
    private static final Map<Class<? extends Annotation>, List<MethodDescription>> descriptions;
    private final AnnotatedMethodStore ams;
    private final boolean mvc;
    private final RedirectScopedConfig redirectScopedConfig = new RedirectScopedConfig();
    private final PortletStateScopedConfig stateScopedConfig = new PortletStateScopedConfig();
    private final PortletSessionScopedConfig sessionScopedConfig = new PortletSessionScopedConfig();

    public PortletAnnotationRecognizer(AnnotatedMethodStore pms, ConfigSummary summary) {
        this(pms, summary, true);
    }

    public PortletAnnotationRecognizer(AnnotatedMethodStore pms, ConfigSummary summary, boolean mvc) {
        super(classAnnotations, PortletAnnotationRecognizer.filterDescriptions(descriptions, mvc), summary);
        this.ams = pms;
        this.mvc = mvc;
        LOG.trace("Created the PortletAnnotationRecognizer.");
    }

    private static Map<Class<? extends Annotation>, List<MethodDescription>> filterDescriptions(Map<Class<? extends Annotation>, List<MethodDescription>> descriptions, boolean mvc) {
        if (mvc) {
            return descriptions;
        }
        HashMap<Class<? extends Annotation>, List<MethodDescription>> filteredDescriptions = new HashMap<Class<? extends Annotation>, List<MethodDescription>>();
        for (Map.Entry<Class<? extends Annotation>, List<MethodDescription>> entry : descriptions.entrySet()) {
            ArrayList<MethodDescription> filteredMethodDescriptions = new ArrayList<MethodDescription>();
            for (MethodDescription methodDescription : entry.getValue()) {
                if (methodDescription.isMvc()) continue;
                filteredMethodDescriptions.add(methodDescription);
            }
            filteredDescriptions.put(entry.getKey(), filteredMethodDescriptions);
        }
        return filteredDescriptions;
    }

    @Override
    protected AnnotatedType<?> handleClassAnnotation(Annotation anno, AnnotatedType<?> aType) throws InvalidAnnotationException {
        String typeName = aType.getJavaClass().getCanonicalName();
        Class theClass = aType.getJavaClass();
        if (anno instanceof RedirectScoped) {
            if (!Serializable.class.isAssignableFrom(theClass)) {
                StringBuilder txt = new StringBuilder(128);
                txt.append("Annotation problem: An @RedirectScoped bean must implement java.io.Serializable.");
                txt.append("Annotation: ").append(anno.annotationType().getSimpleName());
                txt.append(", Class: ").append(typeName);
                LOG.debug(txt.toString());
                this.summary.addStateBeanErrorString(theClass, txt.toString());
            } else {
                this.redirectScopedConfig.addAnnotation(theClass, (RedirectScoped)anno);
            }
        } else if (anno instanceof RenderStateScoped) {
            if (!PortletSerializable.class.isAssignableFrom(theClass)) {
                StringBuilder txt = new StringBuilder(128);
                txt.append("Annotation problem: An @RenderStateScoped bean must implement PortletSerializable. ");
                txt.append("Annotation: ").append(anno.annotationType().getSimpleName());
                txt.append(", Class: ").append(typeName);
                LOG.debug(txt.toString());
                this.summary.addStateBeanErrorString(theClass, txt.toString());
            } else {
                this.stateScopedConfig.addAnnotation(theClass, (RenderStateScoped)anno);
            }
        } else if (anno instanceof PortletSessionScoped) {
            PortletSessionScoped pss = (PortletSessionScoped)anno;
            if (pss.value() != 1 && pss.value() != 2) {
                StringBuilder txt = new StringBuilder(128);
                txt.append("Annotation problem: A @PortletSessionScoped bean scope must be APPLICATION_SCOPE or PORTLET_SCOPE. ");
                txt.append("Annotation: ").append(anno.annotationType().getSimpleName());
                txt.append(", Scope: ").append(pss.value());
                txt.append(", Class: ").append(typeName);
                LOG.debug(txt.toString());
                this.summary.addSessionBeanErrorString(theClass, txt.toString());
            } else {
                this.sessionScopedConfig.addAnnotation(theClass, pss);
            }
        } else {
            if (anno instanceof RequestScoped) {
                PortletRequestScopedAnnotatedType at = new PortletRequestScopedAnnotatedType(aType);
                this.summary.addReqScopedType(at);
                return at;
            }
            if (anno instanceof SessionScoped) {
                PortletSessionScopedAnnotatedType at = new PortletSessionScopedAnnotatedType(aType);
                PortletSessionScoped pss = at.getAnnotation(PortletSessionScoped.class);
                this.sessionScopedConfig.addAnnotation(theClass, pss);
                this.summary.addAppScopedType(at);
                return at;
            }
            StringBuilder txt = new StringBuilder(128);
            txt.append("Unrecognized class annotation: ").append(anno.annotationType().getSimpleName());
            txt.append(", Class: ").append(typeName);
            LOG.warn(txt.toString());
        }
        return null;
    }

    @Override
    protected void handleMethod(Annotation anno, Class<?> beanClass, Method meth, MethodDescription desc) {
        RenderMethod tcc;
        ArrayList<String> portletNames = new ArrayList<String>();
        String dispatchId = "";
        MethodType type = desc.getType();
        if (anno instanceof RenderMethod) {
            tcc = (RenderMethod)anno;
            portletNames.addAll(Arrays.asList(tcc.portletNames()));
            dispatchId = tcc.portletMode().toUpperCase();
        } else if (anno instanceof HeaderMethod) {
            tcc = (HeaderMethod)anno;
            portletNames.addAll(Arrays.asList(tcc.portletNames()));
            dispatchId = tcc.portletMode().toUpperCase();
        } else if (anno instanceof ActionMethod) {
            tcc = (ActionMethod)anno;
            portletNames.add(tcc.portletName());
            dispatchId = tcc.actionName();
        } else if (anno instanceof EventMethod) {
            tcc = (EventMethod)anno;
            portletNames.add(tcc.portletName());
        } else if (anno instanceof ServeResourceMethod) {
            tcc = (ServeResourceMethod)anno;
            portletNames.addAll(Arrays.asList(tcc.portletNames()));
            dispatchId = tcc.resourceID();
        } else if (anno instanceof DestroyMethod) {
            tcc = (DestroyMethod)anno;
            portletNames.add(tcc.value());
        } else if (anno instanceof InitMethod) {
            tcc = (InitMethod)anno;
            portletNames.add(tcc.value());
        } else {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Unrecognized method annotation: ").append(anno.annotationType().getSimpleName());
            txt.append(", Method: ").append(meth.getName());
            txt.append(", Class: ").append(beanClass.getCanonicalName());
            LOG.debug(txt.toString());
            for (String n : this.getDisplayNames(anno)) {
                this.summary.addErrorString(n, txt.toString());
            }
            return;
        }
        AnnotatedMethod pm = new AnnotatedMethod(anno, beanClass, meth, desc);
        for (String portletName : portletNames) {
            StringBuilder txt;
            if (portletName.length() == 0) {
                txt = new StringBuilder(128);
                txt.append("Bad portlet name. Name may not be of length 0.");
                txt.append(" Annotation: ").append(anno.annotationType().getSimpleName());
                txt.append(", Method: ").append(meth.getName());
                txt.append(", Class: ").append(beanClass.getCanonicalName());
                LOG.debug(txt.toString());
                this.summary.addErrorString(portletName, txt.toString());
                return;
            }
            if (portletName.equals("*") && portletNames.size() > 1) {
                txt = new StringBuilder(128);
                txt.append("Wildcard character '*' must be first and only array element. Will be ignored.");
                txt.append(" Annotation: ").append(anno.annotationType().getSimpleName());
                txt.append(", Method: ").append(meth.getName());
                txt.append(", Class: ").append(beanClass.getCanonicalName());
                LOG.debug(txt.toString());
                this.summary.addErrorString(portletName, txt.toString());
                continue;
            }
            MethodIdentifier mi = new MethodIdentifier(portletName, dispatchId, type);
            this.ams.addMethod(mi, pm);
        }
    }

    @Override
    protected void activateCustomScopes(BeanManager bm) {
        this.redirectScopedConfig.activate(bm);
        this.stateScopedConfig.activate(bm);
        this.sessionScopedConfig.activate(bm);
    }

    public RedirectScopedConfig getRedirectScopedConfig() {
        return this.redirectScopedConfig;
    }

    public PortletStateScopedConfig getStateScopedConfig() {
        return this.stateScopedConfig;
    }

    public PortletSessionScopedConfig getSessionScopedConfig() {
        return this.sessionScopedConfig;
    }

    static {
        classAnnotations.add(RedirectScoped.class);
        classAnnotations.add(RenderStateScoped.class);
        classAnnotations.add(PortletSessionScoped.class);
        classAnnotations.add(SessionScoped.class);
        classAnnotations.add(RequestScoped.class);
        descriptions = new HashMap<Class<? extends Annotation>, List<MethodDescription>>();
        ArrayList<MethodDescription> list = new ArrayList<MethodDescription>();
        list.add(MethodDescription.METH_INI);
        descriptions.put(InitMethod.class, list);
        list = new ArrayList();
        list.add(MethodDescription.METH_DES);
        descriptions.put(DestroyMethod.class, list);
        list = new ArrayList();
        list.add(MethodDescription.METH_ACT);
        MethodDescription md = new MethodDescription(String.class, new Class[]{ActionRequest.class, ActionResponse.class}, new Class[]{PortletException.class, IOException.class}, MethodType.ACTION);
        md.setMvc(true);
        md.setVariant(SignatureVariant.STRING_ACTIONREQ_ACTIONRESP);
        list.add(md);
        descriptions.put(ActionMethod.class, list);
        list = new ArrayList();
        list.add(MethodDescription.METH_EVT);
        descriptions.put(EventMethod.class, list);
        list = new ArrayList();
        list.add(MethodDescription.METH_RES);
        md = new MethodDescription(String.class, new Class[]{ResourceRequest.class, ResourceResponse.class}, new Class[]{PortletException.class, IOException.class}, MethodType.RESOURCE);
        md.setAllowMultiple(true);
        md.setMvc(true);
        md.setVariant(SignatureVariant.STRING_RESOURCEREQ_RESOURCERESP);
        list.add(md);
        md = new MethodDescription(String.class, new Class[0], new Class[]{PortletException.class, IOException.class}, MethodType.RESOURCE);
        md.setAllowMultiple(true);
        md.setVariant(SignatureVariant.STRING_VOID);
        list.add(md);
        md = new MethodDescription(Void.TYPE, new Class[0], new Class[]{PortletException.class, IOException.class}, MethodType.RESOURCE);
        md.setAllowMultiple(true);
        md.setVariant(SignatureVariant.VOID_VOID);
        list.add(md);
        descriptions.put(ServeResourceMethod.class, list);
        list = new ArrayList();
        list.add(MethodDescription.METH_REN);
        md = new MethodDescription(String.class, new Class[0], new Class[]{PortletException.class, IOException.class}, MethodType.RENDER);
        md.setAllowMultiple(true);
        md.setVariant(SignatureVariant.STRING_VOID);
        list.add(md);
        md = new MethodDescription(String.class, new Class[]{RenderRequest.class, RenderResponse.class}, new Class[]{PortletException.class, IOException.class}, MethodType.RENDER);
        md.setAllowMultiple(true);
        md.setMvc(true);
        md.setVariant(SignatureVariant.STRING_RENDERREQ_RENDERRESP);
        list.add(md);
        md = new MethodDescription(Void.TYPE, new Class[0], new Class[]{PortletException.class, IOException.class}, MethodType.RENDER);
        md.setAllowMultiple(true);
        md.setVariant(SignatureVariant.VOID_VOID);
        list.add(md);
        descriptions.put(RenderMethod.class, list);
        list = new ArrayList();
        list.add(MethodDescription.METH_HDR);
        md = new MethodDescription(String.class, new Class[0], new Class[]{PortletException.class, IOException.class}, MethodType.HEADER);
        md.setAllowMultiple(true);
        md.setVariant(SignatureVariant.STRING_VOID);
        list.add(md);
        md = new MethodDescription(Void.TYPE, new Class[0], new Class[]{PortletException.class, IOException.class}, MethodType.HEADER);
        md.setAllowMultiple(true);
        md.setVariant(SignatureVariant.VOID_VOID);
        list.add(md);
        descriptions.put(HeaderMethod.class, list);
    }
}

