/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.processor;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.mvc.RedirectScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectScopedConfig
implements Serializable {
    private static final long serialVersionUID = 4387223464722335532L;
    private final Logger LOG = LoggerFactory.getLogger(RedirectScopedConfig.class);
    private final boolean isTrace = this.LOG.isTraceEnabled();
    private final List<String> sortedAnnotatedClassNames = new ArrayList<String>();
    private final Map<Contextual<?>, PSSDescription> context2Anno = new HashMap();
    private final Map<Class<?>, PSSDescription> class2Anno = new HashMap();

    public void addAnnotation(Class<?> beanClass, RedirectScoped anno) {
        PSSDescription desc = new PSSDescription();
        desc.pssAnno = anno;
        this.class2Anno.put(beanClass, desc);
    }

    public void activate(BeanManager bm) {
        for (Class<?> c : this.class2Anno.keySet()) {
            this.sortedAnnotatedClassNames.add(c.getCanonicalName());
        }
        Collections.sort(this.sortedAnnotatedClassNames);
        for (Class<?> cls : this.class2Anno.keySet()) {
            Set beans = bm.getBeans(cls, new Annotation[0]);
            Bean bean = bm.resolve(beans);
            assert (bean != null);
            this.context2Anno.put((Contextual<?>)bean, this.class2Anno.get(cls));
        }
        if (this.isTrace) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("RedirectScopedBeanHolder configuration.");
            txt.append(" Annotated Beans: ");
            txt.append(this.getConfigAsString());
            this.LOG.debug(txt.toString());
        }
    }

    public Set<Class<?>> getBeanClasses() {
        return this.class2Anno.keySet();
    }

    public String getConfigAsString() {
        StringBuilder txt = new StringBuilder(128);
        for (Class<?> c : this.class2Anno.keySet()) {
            txt.append("\n\tClass: ").append(c.getCanonicalName());
        }
        return txt.toString();
    }

    private class PSSDescription
    implements Serializable {
        private static final long serialVersionUID = 3289471768384711112L;
        RedirectScoped pssAnno;

        private PSSDescription() {
        }
    }
}

