/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.out.BrokerOuterAPI;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.EpochEntry;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.protocol.body.SyncStateSet;
import org.apache.rocketmq.common.protocol.header.namesrv.controller.GetMetaDataResponseHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.controller.GetReplicaInfoResponseHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.controller.RegisterBrokerToControllerResponseHeader;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.ha.autoswitch.AutoSwitchHAService;

public class ReplicasManager {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
    private static final int RETRY_INTERVAL_SECOND = 5;
    private final ScheduledExecutorService scheduledService;
    private final ExecutorService executorService;
    private final BrokerController brokerController;
    private final AutoSwitchHAService haService;
    private final BrokerConfig brokerConfig;
    private final String localAddress;
    private final BrokerOuterAPI brokerOuterAPI;
    private final List<String> controllerAddresses;
    private volatile String controllerLeaderAddress = "";
    private volatile State state = State.INITIAL;
    private ScheduledFuture<?> checkSyncStateSetTaskFuture;
    private ScheduledFuture<?> slaveSyncFuture;
    private Set<String> syncStateSet;
    private int syncStateSetEpoch = 0;
    private String masterAddress = "";
    private int masterEpoch = 0;
    private long lastSyncTimeMs = System.currentTimeMillis();

    public ReplicasManager(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.brokerOuterAPI = brokerController.getBrokerOuterAPI();
        this.scheduledService = Executors.newScheduledThreadPool(3, (ThreadFactory)new ThreadFactoryImpl("ReplicasManager_ScheduledService_", brokerController.getBrokerIdentity()));
        this.executorService = Executors.newFixedThreadPool(3, (ThreadFactory)new ThreadFactoryImpl("ReplicasManager_ExecutorService_", brokerController.getBrokerIdentity()));
        this.haService = (AutoSwitchHAService)brokerController.getMessageStore().getHaService();
        this.brokerConfig = brokerController.getBrokerConfig();
        String controllerPaths = this.brokerConfig.getControllerAddr();
        String[] controllers = controllerPaths.split(";");
        assert (controllers.length > 0);
        this.controllerAddresses = new ArrayList<String>(Arrays.asList(controllers));
        this.syncStateSet = new HashSet<String>();
        this.localAddress = brokerController.getBrokerAddr();
        this.haService.setLocalAddress(this.localAddress);
    }

    public long getConfirmOffset() {
        return this.haService.getConfirmOffset();
    }

    public void start() {
        if (!this.startBasicService()) {
            LOGGER.error("Failed to start replicasManager");
            this.executorService.submit(() -> {
                int retryTimes = 0;
                do {
                    try {
                        TimeUnit.SECONDS.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    LOGGER.warn("Failed to start replicasManager, retry times:{}, current state:{}, try it again", (Object)(++retryTimes), (Object)this.state);
                } while (!this.startBasicService());
                LOGGER.info("Start replicasManager success, retry times:{}", (Object)retryTimes);
            });
        }
    }

    private boolean startBasicService() {
        if (this.state == State.INITIAL) {
            if (this.schedulingSyncControllerMetadata()) {
                LOGGER.info("First time sync controller metadata success");
                this.state = State.FIRST_TIME_SYNC_CONTROLLER_METADATA_DONE;
            } else {
                return false;
            }
        }
        if (this.state == State.FIRST_TIME_SYNC_CONTROLLER_METADATA_DONE) {
            if (this.registerBrokerToController()) {
                LOGGER.info("First time register broker success");
                this.state = State.RUNNING;
            } else {
                return false;
            }
        }
        this.schedulingSyncBrokerMetadata();
        this.haService.registerSyncStateSetChangedListener(this::doReportSyncStateSetChanged);
        return true;
    }

    public void shutdown() {
        this.state = State.SHUTDOWN;
        this.executorService.shutdown();
        this.scheduledService.shutdown();
    }

    public synchronized void changeBrokerRole(String newMasterAddress, int newMasterEpoch, int syncStateSetEpoch, long brokerId) {
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{newMasterAddress}) && newMasterEpoch > this.masterEpoch) {
            if (StringUtils.equals((CharSequence)newMasterAddress, (CharSequence)this.localAddress)) {
                this.changeToMaster(newMasterEpoch, syncStateSetEpoch);
            } else {
                this.changeToSlave(newMasterAddress, newMasterEpoch, brokerId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeToMaster(int newMasterEpoch, int syncStateSetEpoch) {
        ReplicasManager replicasManager = this;
        synchronized (replicasManager) {
            if (newMasterEpoch > this.masterEpoch) {
                LOGGER.info("Begin to change to master, brokerName:{}, replicas:{}, new Epoch:{}", new Object[]{this.brokerConfig.getBrokerName(), this.localAddress, newMasterEpoch});
                this.masterEpoch = newMasterEpoch;
                HashSet<String> newSyncStateSet = new HashSet<String>();
                newSyncStateSet.add(this.localAddress);
                this.changeSyncStateSet(newSyncStateSet, syncStateSetEpoch);
                this.masterAddress = this.localAddress;
                this.handleSlaveSynchronize(BrokerRole.SYNC_MASTER);
                this.haService.changeToMaster(newMasterEpoch);
                this.brokerController.getBrokerConfig().setBrokerId(0L);
                this.brokerController.getMessageStoreConfig().setBrokerRole(BrokerRole.SYNC_MASTER);
                this.brokerController.changeSpecialServiceStatus(true);
                this.schedulingCheckSyncStateSet();
                this.executorService.submit(() -> {
                    try {
                        this.brokerController.registerBrokerAll(true, false, this.brokerController.getBrokerConfig().isForceRegister());
                    }
                    catch (Throwable e) {
                        LOGGER.error("Error happen when register broker to name-srv, Failed to change broker to master", e);
                        return;
                    }
                    LOGGER.info("Change broker {} to master success, masterEpoch {}, syncStateSetEpoch:{}", new Object[]{this.localAddress, newMasterEpoch, syncStateSetEpoch});
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeToSlave(String newMasterAddress, int newMasterEpoch, long brokerId) {
        ReplicasManager replicasManager = this;
        synchronized (replicasManager) {
            if (newMasterEpoch > this.masterEpoch) {
                LOGGER.info("Begin to change to slave, brokerName={}, replicas={}, brokerId={}", new Object[]{this.brokerConfig.getBrokerName(), this.localAddress, brokerId});
                this.masterAddress = newMasterAddress;
                this.masterEpoch = newMasterEpoch;
                this.stopCheckSyncStateSet();
                this.brokerController.getMessageStoreConfig().setBrokerRole(BrokerRole.SLAVE);
                this.brokerController.changeSpecialServiceStatus(false);
                this.brokerConfig.setBrokerId(brokerId);
                this.handleSlaveSynchronize(BrokerRole.SLAVE);
                this.haService.changeToSlave(newMasterAddress, newMasterEpoch, Long.valueOf(this.brokerConfig.getBrokerId()));
                this.executorService.submit(() -> {
                    try {
                        this.brokerController.registerBrokerAll(true, false, this.brokerController.getBrokerConfig().isForceRegister());
                    }
                    catch (Throwable e) {
                        LOGGER.error("Error happen when register broker to name-srv, Failed to change broker to slave", e);
                        return;
                    }
                    LOGGER.info("Change broker {} to slave, newMasterAddress:{}, newMasterEpoch:{}", new Object[]{this.localAddress, newMasterAddress, newMasterEpoch});
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeSyncStateSet(Set<String> newSyncStateSet, int newSyncStateSetEpoch) {
        ReplicasManager replicasManager = this;
        synchronized (replicasManager) {
            if (newSyncStateSetEpoch > this.syncStateSetEpoch) {
                LOGGER.info("Sync state set changed from {} to {}", this.syncStateSet, newSyncStateSet);
                this.syncStateSetEpoch = newSyncStateSetEpoch;
                this.syncStateSet = new HashSet<String>(newSyncStateSet);
                this.haService.setSyncStateSet(newSyncStateSet);
            }
        }
    }

    private void handleSlaveSynchronize(BrokerRole role) {
        if (role == BrokerRole.SLAVE) {
            if (this.slaveSyncFuture != null) {
                this.slaveSyncFuture.cancel(false);
            }
            this.brokerController.getSlaveSynchronize().setMasterAddr(this.masterAddress);
            this.slaveSyncFuture = this.brokerController.getScheduledExecutorService().scheduleAtFixedRate(() -> {
                try {
                    if (System.currentTimeMillis() - this.lastSyncTimeMs > 10000L) {
                        this.brokerController.getSlaveSynchronize().syncAll();
                        this.lastSyncTimeMs = System.currentTimeMillis();
                    }
                    this.brokerController.getSlaveSynchronize().syncTimerCheckPoint();
                }
                catch (Throwable e) {
                    LOGGER.error("ScheduledTask SlaveSynchronize syncAll error.", e);
                }
            }, 3000L, 3000L, TimeUnit.MILLISECONDS);
        } else {
            if (this.slaveSyncFuture != null) {
                this.slaveSyncFuture.cancel(false);
            }
            this.brokerController.getSlaveSynchronize().setMasterAddr(null);
        }
    }

    private boolean registerBrokerToController() {
        try {
            RegisterBrokerToControllerResponseHeader registerResponse = this.brokerOuterAPI.registerBrokerToController(this.controllerLeaderAddress, this.brokerConfig.getBrokerClusterName(), this.brokerConfig.getBrokerName(), this.localAddress, this.haService.getLastEpoch(), this.brokerController.getMessageStore().getMaxPhyOffset());
            String newMasterAddress = registerResponse.getMasterAddress();
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{newMasterAddress})) {
                if (StringUtils.equals((CharSequence)newMasterAddress, (CharSequence)this.localAddress)) {
                    this.changeToMaster(registerResponse.getMasterEpoch(), registerResponse.getSyncStateSetEpoch());
                } else {
                    this.changeToSlave(newMasterAddress, registerResponse.getMasterEpoch(), registerResponse.getBrokerId());
                }
            } else {
                LOGGER.warn("No master in controller");
                return false;
            }
            this.brokerController.setIsolated(false);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to register broker to controller", (Throwable)e);
            return false;
        }
    }

    private void schedulingSyncBrokerMetadata() {
        this.scheduledService.scheduleAtFixedRate(() -> {
            try {
                Pair<GetReplicaInfoResponseHeader, SyncStateSet> result = this.brokerOuterAPI.getReplicaInfo(this.controllerLeaderAddress, this.brokerConfig.getBrokerName(), this.localAddress);
                GetReplicaInfoResponseHeader info = (GetReplicaInfoResponseHeader)result.getObject1();
                SyncStateSet syncStateSet = (SyncStateSet)result.getObject2();
                String newMasterAddress = info.getMasterAddress();
                int newMasterEpoch = info.getMasterEpoch();
                long brokerId = info.getBrokerId();
                ReplicasManager replicasManager = this;
                synchronized (replicasManager) {
                    if (newMasterEpoch > this.masterEpoch) {
                        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{newMasterAddress})) {
                            if (StringUtils.equals((CharSequence)newMasterAddress, (CharSequence)this.localAddress)) {
                                this.changeToMaster(newMasterEpoch, syncStateSet.getSyncStateSetEpoch());
                            } else if (brokerId > 0L) {
                                this.changeToSlave(newMasterAddress, newMasterEpoch, brokerId);
                            } else if (brokerId < 0L) {
                                this.registerBrokerToController();
                            }
                        } else {
                            this.registerBrokerToController();
                        }
                    } else if (newMasterEpoch == this.masterEpoch && this.isMasterState()) {
                        this.changeSyncStateSet(syncStateSet.getSyncStateSet(), syncStateSet.getSyncStateSetEpoch());
                    }
                }
            }
            catch (MQBrokerException exception) {
                LOGGER.warn("Error happen when get broker {}'s metadata", (Object)this.brokerConfig.getBrokerName(), (Object)exception);
                if (exception.getResponseCode() == 2008) {
                    try {
                        this.registerBrokerToController();
                        TimeUnit.SECONDS.sleep(2L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error happen when get broker {}'s metadata", (Object)this.brokerConfig.getBrokerName(), (Object)e);
            }
        }, 3000L, this.brokerConfig.getSyncBrokerMetadataPeriod(), TimeUnit.MILLISECONDS);
    }

    private boolean schedulingSyncControllerMetadata() {
        for (int tryTimes = 0; tryTimes < 3; ++tryTimes) {
            boolean flag = this.updateControllerMetadata();
            if (flag) {
                this.scheduledService.scheduleAtFixedRate(this::updateControllerMetadata, 3000L, this.brokerConfig.getSyncControllerMetadataPeriod(), TimeUnit.MILLISECONDS);
                return true;
            }
            try {
                TimeUnit.SECONDS.sleep(1L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        LOGGER.error("Failed to init controller metadata, maybe the controllers in {} is not available", this.controllerAddresses);
        return false;
    }

    private boolean updateControllerMetadata() {
        for (String address : this.controllerAddresses) {
            try {
                GetMetaDataResponseHeader responseHeader = this.brokerOuterAPI.getControllerMetaData(address);
                if (responseHeader == null || !StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{responseHeader.getControllerLeaderAddress()})) continue;
                this.controllerLeaderAddress = responseHeader.getControllerLeaderAddress();
                LOGGER.info("Update controller leader address to {}", (Object)this.controllerLeaderAddress);
                return true;
            }
            catch (Exception e) {
                LOGGER.error("Failed to update controller metadata", (Throwable)e);
            }
        }
        return false;
    }

    private void schedulingCheckSyncStateSet() {
        if (this.checkSyncStateSetTaskFuture != null) {
            this.checkSyncStateSetTaskFuture.cancel(false);
        }
        this.checkSyncStateSetTaskFuture = this.scheduledService.scheduleAtFixedRate(() -> {
            Set newSyncStateSet = this.haService.maybeShrinkInSyncStateSet();
            newSyncStateSet.add(this.localAddress);
            ReplicasManager replicasManager = this;
            synchronized (replicasManager) {
                if (this.syncStateSet != null && this.syncStateSet.size() == newSyncStateSet.size() && this.syncStateSet.containsAll(newSyncStateSet)) {
                    return;
                }
            }
            this.doReportSyncStateSetChanged(newSyncStateSet);
        }, 3000L, this.brokerConfig.getCheckSyncStateSetPeriod(), TimeUnit.MILLISECONDS);
    }

    private void doReportSyncStateSetChanged(Set<String> newSyncStateSet) {
        try {
            SyncStateSet result = this.brokerOuterAPI.alterSyncStateSet(this.controllerLeaderAddress, this.brokerConfig.getBrokerName(), this.masterAddress, this.masterEpoch, newSyncStateSet, this.syncStateSetEpoch);
            if (result != null) {
                this.changeSyncStateSet(result.getSyncStateSet(), result.getSyncStateSetEpoch());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error happen when change sync state set, broker:{}, masterAddress:{}, masterEpoch:{}, oldSyncStateSet:{}, newSyncStateSet:{}, syncStateSetEpoch:{}", new Object[]{this.brokerConfig.getBrokerName(), this.masterAddress, this.masterEpoch, this.syncStateSet, newSyncStateSet, this.syncStateSetEpoch, e});
        }
    }

    private void stopCheckSyncStateSet() {
        if (this.checkSyncStateSetTaskFuture != null) {
            this.checkSyncStateSetTaskFuture.cancel(false);
        }
    }

    public int getLastEpoch() {
        return this.haService.getLastEpoch();
    }

    public BrokerRole getBrokerRole() {
        return this.brokerController.getMessageStoreConfig().getBrokerRole();
    }

    public boolean isMasterState() {
        return this.getBrokerRole() == BrokerRole.SYNC_MASTER;
    }

    public SyncStateSet getSyncStateSet() {
        return new SyncStateSet(this.syncStateSet, this.syncStateSetEpoch);
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public String getMasterAddress() {
        return this.masterAddress;
    }

    public int getMasterEpoch() {
        return this.masterEpoch;
    }

    public List<String> getControllerAddresses() {
        return this.controllerAddresses;
    }

    public List<EpochEntry> getEpochEntries() {
        return this.haService.getEpochEntries();
    }

    static enum State {
        INITIAL,
        FIRST_TIME_SYNC_CONTROLLER_METADATA_DONE,
        RUNNING,
        SHUTDOWN;

    }
}

