/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.offset;

import com.alibaba.fastjson.annotation.JSONField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.BrokerPathConfigHelper;
import org.apache.rocketmq.common.ConfigManager;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;

public class ConsumerOrderInfoManager
extends ConfigManager {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
    private static final String TOPIC_GROUP_SEPARATOR = "@";
    private static final long CLEAN_SPAN_FROM_LAST = 86400000L;
    private ConcurrentHashMap<String, ConcurrentHashMap<Integer, OrderInfo>> table = new ConcurrentHashMap(128);
    private transient BrokerController brokerController;

    public ConsumerOrderInfoManager() {
    }

    public ConsumerOrderInfoManager(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public ConcurrentHashMap<String, ConcurrentHashMap<Integer, OrderInfo>> getTable() {
        return this.table;
    }

    public void setTable(ConcurrentHashMap<String, ConcurrentHashMap<Integer, OrderInfo>> table) {
        this.table = table;
    }

    public int update(String topic, String group, int queueId, List<Long> msgOffsetList) {
        ConcurrentHashMap<Integer, OrderInfo> old;
        String key = topic + TOPIC_GROUP_SEPARATOR + group;
        ConcurrentHashMap<Integer, OrderInfo> qs = this.table.get(key);
        if (qs == null && (old = this.table.putIfAbsent(key, qs = new ConcurrentHashMap(16))) != null) {
            qs = old;
        }
        OrderInfo orderInfo = qs.get(queueId);
        List<Long> simple = OrderInfo.simpleO(msgOffsetList);
        if (orderInfo != null && simple.get(0).equals(orderInfo.getOffsetList().get(0))) {
            if (simple.equals(orderInfo.getOffsetList())) {
                orderInfo.setConsumedCount(orderInfo.getConsumedCount() + 1);
            } else {
                orderInfo.setConsumedCount(0);
            }
            orderInfo.setLastConsumeTimestamp(System.currentTimeMillis());
            orderInfo.setOffsetList(simple);
            orderInfo.setCommitOffsetBit(0L);
        } else {
            orderInfo = new OrderInfo();
            orderInfo.setOffsetList(simple);
            orderInfo.setLastConsumeTimestamp(System.currentTimeMillis());
            orderInfo.setConsumedCount(0);
            orderInfo.setCommitOffsetBit(0L);
            qs.put(queueId, orderInfo);
        }
        return orderInfo.getConsumedCount();
    }

    public boolean checkBlock(String topic, String group, int queueId, long invisibleTime) {
        OrderInfo orderInfo;
        ConcurrentHashMap<Integer, OrderInfo> old;
        String key = topic + TOPIC_GROUP_SEPARATOR + group;
        ConcurrentHashMap<Integer, OrderInfo> qs = this.table.get(key);
        if (qs == null && (old = this.table.putIfAbsent(key, qs = new ConcurrentHashMap(16))) != null) {
            qs = old;
        }
        if ((orderInfo = qs.get(queueId)) == null) {
            return false;
        }
        boolean isBlock = System.currentTimeMillis() - orderInfo.getLastConsumeTimestamp() < invisibleTime;
        return isBlock && !orderInfo.isDone();
    }

    public long commitAndNext(String topic, String group, int queueId, long offset) {
        long temp;
        int i;
        String key = topic + TOPIC_GROUP_SEPARATOR + group;
        ConcurrentHashMap<Integer, OrderInfo> qs = this.table.get(key);
        if (qs == null) {
            return offset + 1L;
        }
        OrderInfo orderInfo = qs.get(queueId);
        if (orderInfo == null) {
            log.warn("OrderInfo is null, {}, {}, {}", new Object[]{key, offset, orderInfo});
            return offset + 1L;
        }
        List<Long> offsetList = orderInfo.getOffsetList();
        if (offsetList == null || offsetList.isEmpty()) {
            log.warn("OrderInfo is empty, {}, {}, {}", new Object[]{key, offset, orderInfo});
            return -1L;
        }
        Long first = offsetList.get(0);
        int size = offsetList.size();
        for (i = 0; i < size && offset != (temp = i == 0 ? first : first + offsetList.get(i)); ++i) {
        }
        if (i >= size) {
            log.warn("OrderInfo not found commit offset, {}, {}, {}", new Object[]{key, offset, orderInfo});
            return -1L;
        }
        orderInfo.setCommitOffsetBit(orderInfo.getCommitOffsetBit() | 1L << i);
        if (orderInfo.isDone()) {
            if (size == 1) {
                return offsetList.get(0) + 1L;
            }
            return offsetList.get(size - 1) + first + 1L;
        }
        return -2L;
    }

    public OrderInfo get(String topic, String group, int queueId) {
        String key = topic + TOPIC_GROUP_SEPARATOR + group;
        ConcurrentHashMap<Integer, OrderInfo> qs = this.table.get(key);
        if (qs == null) {
            return null;
        }
        return qs.get(queueId);
    }

    public int getConsumeCount(String topic, String group, int queueId) {
        OrderInfo orderInfo = this.get(topic, group, queueId);
        return orderInfo == null ? 0 : orderInfo.getConsumedCount();
    }

    private void autoClean() {
        if (this.brokerController == null) {
            return;
        }
        Iterator<Map.Entry<String, ConcurrentHashMap<Integer, OrderInfo>>> iterator = this.table.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ConcurrentHashMap<Integer, OrderInfo>> entry = iterator.next();
            String topicAtGroup = entry.getKey();
            ConcurrentHashMap<Integer, OrderInfo> qs = entry.getValue();
            String[] arrays = topicAtGroup.split(TOPIC_GROUP_SEPARATOR);
            if (arrays.length != 2) continue;
            String topic = arrays[0];
            String group = arrays[1];
            TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(topic);
            if (topicConfig == null) {
                iterator.remove();
                log.info("Topic not exist, Clean order info, {}:{}", (Object)topicAtGroup, qs);
                continue;
            }
            if (this.brokerController.getSubscriptionGroupManager().getSubscriptionGroupTable().get(group) == null) {
                iterator.remove();
                log.info("Group not exist, Clean order info, {}:{}", (Object)topicAtGroup, qs);
                continue;
            }
            if (qs.isEmpty()) {
                iterator.remove();
                log.info("Order table is empty, Clean order info, {}:{}", (Object)topicAtGroup, qs);
                continue;
            }
            Iterator<Map.Entry<Integer, OrderInfo>> qsIterator = qs.entrySet().iterator();
            while (qsIterator.hasNext()) {
                Map.Entry<Integer, OrderInfo> qsEntry = qsIterator.next();
                if (qsEntry.getKey() >= topicConfig.getReadQueueNums()) {
                    qsIterator.remove();
                    log.info("Queue not exist, Clean order info, {}:{}, {}", new Object[]{topicAtGroup, entry.getValue(), topicConfig});
                    continue;
                }
                if (System.currentTimeMillis() - qsEntry.getValue().getLastConsumeTimestamp() <= 86400000L) continue;
                qsIterator.remove();
                log.info("Not consume long time, Clean order info, {}:{}, {}", new Object[]{topicAtGroup, entry.getValue(), topicConfig});
            }
        }
    }

    public String encode() {
        return this.encode(false);
    }

    public String configFilePath() {
        if (this.brokerController != null) {
            return BrokerPathConfigHelper.getConsumerOrderInfoPath(this.brokerController.getMessageStoreConfig().getStorePathRootDir());
        }
        return BrokerPathConfigHelper.getConsumerOrderInfoPath("~");
    }

    public void decode(String jsonString) {
        ConsumerOrderInfoManager obj;
        if (jsonString != null && (obj = (ConsumerOrderInfoManager)((Object)RemotingSerializable.fromJson((String)jsonString, ConsumerOrderInfoManager.class))) != null) {
            this.table = obj.table;
        }
    }

    public String encode(boolean prettyFormat) {
        this.autoClean();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\n").append("\t\"table\":{");
        Iterator<Map.Entry<String, ConcurrentHashMap<Integer, OrderInfo>>> iterator = this.table.entrySet().iterator();
        int count1 = 0;
        while (iterator.hasNext()) {
            Map.Entry<String, ConcurrentHashMap<Integer, OrderInfo>> entry = iterator.next();
            if (count1 > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("\n\t\t\"").append(entry.getKey()).append("\":{");
            Iterator<Map.Entry<Integer, OrderInfo>> qsIterator = entry.getValue().entrySet().iterator();
            int count2 = 0;
            while (qsIterator.hasNext()) {
                Map.Entry<Integer, OrderInfo> qsEntry = qsIterator.next();
                if (count2 > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("\n\t\t\t").append(qsEntry.getKey()).append(":").append(qsEntry.getValue().encode());
                ++count2;
            }
            stringBuilder.append("\n\t\t}");
            ++count1;
        }
        stringBuilder.append("\n\t}").append("\n}");
        return stringBuilder.toString();
    }

    public static class OrderInfo {
        private List<Long> offsetList;
        private int consumedCount;
        private long lastConsumeTimestamp;
        private long commitOffsetBit;

        public List<Long> getOffsetList() {
            return this.offsetList;
        }

        public void setOffsetList(List<Long> offsetList) {
            this.offsetList = offsetList;
        }

        public static List<Long> simpleO(List<Long> offsetList) {
            ArrayList<Long> simple = new ArrayList<Long>();
            if (offsetList.size() == 1) {
                simple.addAll(offsetList);
                return simple;
            }
            Long first = offsetList.get(0);
            simple.add(first);
            for (int i = 1; i < offsetList.size(); ++i) {
                simple.add(offsetList.get(i) - first);
            }
            return simple;
        }

        public int getConsumedCount() {
            return this.consumedCount;
        }

        public void setConsumedCount(int consumedCount) {
            this.consumedCount = consumedCount;
        }

        public long getLastConsumeTimestamp() {
            return this.lastConsumeTimestamp;
        }

        public void setLastConsumeTimestamp(long lastConsumeTimestamp) {
            this.lastConsumeTimestamp = lastConsumeTimestamp;
        }

        public long getCommitOffsetBit() {
            return this.commitOffsetBit;
        }

        public void setCommitOffsetBit(long commitOffsetBit) {
            this.commitOffsetBit = commitOffsetBit;
        }

        @JSONField(serialize=false, deserialize=false)
        public boolean isDone() {
            if (this.offsetList == null || this.offsetList.isEmpty()) {
                return true;
            }
            int num = this.offsetList.size();
            for (int i = 0; i < num; i = (int)((byte)(i + 1))) {
                if ((this.commitOffsetBit & 1L << i) != 0L) continue;
                return false;
            }
            return true;
        }

        @JSONField(serialize=false, deserialize=false)
        public String encode() {
            StringBuilder sb = new StringBuilder();
            sb.append("{").append("\"c\":").append(this.getConsumedCount());
            sb.append(",").append("\"cm\":").append(this.getCommitOffsetBit());
            sb.append(",").append("\"l\":").append(this.getLastConsumeTimestamp());
            sb.append(",").append("\"o\":[");
            if (this.getOffsetList() != null) {
                for (int i = 0; i < this.getOffsetList().size(); ++i) {
                    sb.append(this.getOffsetList().get(i));
                    if (i >= this.getOffsetList().size() - 1) continue;
                    sb.append(",");
                }
            }
            sb.append("]").append("}");
            return sb.toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("OrderInfo");
            sb.append(ConsumerOrderInfoManager.TOPIC_GROUP_SEPARATOR).append(this.hashCode());
            sb.append("{offsetList=").append(this.offsetList);
            sb.append(", consumedCount=").append(this.consumedCount);
            sb.append(", lastConsumeTimestamp=").append(this.lastConsumeTimestamp);
            sb.append(", commitOffsetBit=").append(this.commitOffsetBit);
            sb.append(", isDone=").append(this.isDone());
            sb.append('}');
            return sb.toString();
        }
    }
}

