/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.rocketmq.common.BrokerIdentity;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;

public class StoreStatsService
extends ServiceThread {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqStore");
    private static final int FREQUENCY_OF_SAMPLING = 1000;
    private static final int MAX_RECORDS_OF_SAMPLING = 600;
    private static final String[] PUT_MESSAGE_ENTIRE_TIME_MAX_DESC = new String[]{"[<=0ms]", "[0~10ms]", "[10~50ms]", "[50~100ms]", "[100~200ms]", "[200~500ms]", "[500ms~1s]", "[1~2s]", "[2~3s]", "[3~4s]", "[4~5s]", "[5~10s]", "[10s~]"};
    private static final Map<Integer, Integer> PUT_MESSAGE_ENTIRE_TIME_BUCKETS = new TreeMap<Integer, Integer>();
    private TreeMap<Long, LongAdder> buckets = new TreeMap();
    private Map<Long, LongAdder> lastBuckets = new TreeMap<Long, LongAdder>();
    private static int printTPSInterval = 60;
    private final LongAdder putMessageFailedTimes = new LongAdder();
    private final ConcurrentMap<String, LongAdder> putMessageTopicTimesTotal = new ConcurrentHashMap<String, LongAdder>(128);
    private final ConcurrentMap<String, LongAdder> putMessageTopicSizeTotal = new ConcurrentHashMap<String, LongAdder>(128);
    private final LongAdder getMessageTimesTotalFound = new LongAdder();
    private final LongAdder getMessageTransferredMsgCount = new LongAdder();
    private final LongAdder getMessageTimesTotalMiss = new LongAdder();
    private final LinkedList<CallSnapshot> putTimesList = new LinkedList();
    private final LinkedList<CallSnapshot> getTimesFoundList = new LinkedList();
    private final LinkedList<CallSnapshot> getTimesMissList = new LinkedList();
    private final LinkedList<CallSnapshot> transferredMsgCountList = new LinkedList();
    private volatile LongAdder[] putMessageDistributeTime;
    private volatile LongAdder[] lastPutMessageDistributeTime;
    private long messageStoreBootTimestamp = System.currentTimeMillis();
    private volatile long putMessageEntireTimeMax = 0L;
    private volatile long getMessageEntireTimeMax = 0L;
    private ReentrantLock putLock = new ReentrantLock();
    private ReentrantLock getLock = new ReentrantLock();
    private volatile long dispatchMaxBuffer = 0L;
    private ReentrantLock samplingLock = new ReentrantLock();
    private long lastPrintTimestamp = System.currentTimeMillis();
    private BrokerIdentity brokerIdentity;

    public StoreStatsService(BrokerIdentity brokerIdentity) {
        this();
        this.brokerIdentity = brokerIdentity;
    }

    public StoreStatsService() {
        PUT_MESSAGE_ENTIRE_TIME_BUCKETS.put(1, 20);
        PUT_MESSAGE_ENTIRE_TIME_BUCKETS.put(2, 15);
        PUT_MESSAGE_ENTIRE_TIME_BUCKETS.put(5, 10);
        PUT_MESSAGE_ENTIRE_TIME_BUCKETS.put(10, 10);
        PUT_MESSAGE_ENTIRE_TIME_BUCKETS.put(50, 6);
        PUT_MESSAGE_ENTIRE_TIME_BUCKETS.put(100, 5);
        PUT_MESSAGE_ENTIRE_TIME_BUCKETS.put(1000, 9);
        this.resetPutMessageTimeBuckets();
        this.resetPutMessageDistributeTime();
    }

    private void resetPutMessageTimeBuckets() {
        TreeMap<Long, LongAdder> nextBuckets = new TreeMap<Long, LongAdder>();
        AtomicLong index = new AtomicLong(0L);
        PUT_MESSAGE_ENTIRE_TIME_BUCKETS.forEach((interval, times) -> {
            for (int i = 0; i < times; ++i) {
                nextBuckets.put(index.addAndGet(interval.intValue()), new LongAdder());
            }
        });
        nextBuckets.put(Long.MAX_VALUE, new LongAdder());
        this.lastBuckets = this.buckets;
        this.buckets = nextBuckets;
    }

    public void incPutMessageEntireTime(long value) {
        Map.Entry<Long, LongAdder> targetBucket = this.buckets.ceilingEntry(value);
        if (targetBucket != null) {
            targetBucket.getValue().add(1L);
        }
    }

    public double findPutMessageEntireTimePX(double px) {
        Map<Long, LongAdder> lastBuckets = this.lastBuckets;
        long start = System.currentTimeMillis();
        double result = 0.0;
        long totalRequest = lastBuckets.values().stream().mapToLong(LongAdder::longValue).sum();
        long pxIndex = (long)((double)totalRequest * px);
        long passCount = 0L;
        ArrayList<Long> bucketValue = new ArrayList<Long>(lastBuckets.keySet());
        for (int i = 0; i < bucketValue.size(); ++i) {
            long count = lastBuckets.get(bucketValue.get(i)).longValue();
            if (pxIndex <= passCount + count) {
                long relativeIndex = pxIndex - passCount;
                if (i == 0) {
                    result = count == 0L ? 0.0 : (double)((Long)bucketValue.get(i) * relativeIndex) / (double)count;
                    break;
                }
                long lastBucket = (Long)bucketValue.get(i - 1);
                result = (double)lastBucket + (count == 0L ? 0.0 : (double)(((Long)bucketValue.get(i) - lastBucket) * relativeIndex) / (double)count);
                break;
            }
            passCount += count;
        }
        log.info("findPutMessageEntireTimePX {}={}ms cost {}ms", new Object[]{px, String.format("%.2f", result), System.currentTimeMillis() - start});
        return result;
    }

    private LongAdder[] resetPutMessageDistributeTime() {
        LongAdder[] next = new LongAdder[13];
        for (int i = 0; i < next.length; ++i) {
            next[i] = new LongAdder();
        }
        this.lastPutMessageDistributeTime = this.putMessageDistributeTime;
        this.putMessageDistributeTime = next;
        return this.lastPutMessageDistributeTime;
    }

    public long getPutMessageEntireTimeMax() {
        return this.putMessageEntireTimeMax;
    }

    public void setPutMessageEntireTimeMax(long value) {
        this.incPutMessageEntireTime(value);
        LongAdder[] times = this.putMessageDistributeTime;
        if (null == times) {
            return;
        }
        if (value <= 0L) {
            times[0].add(1L);
        } else if (value < 10L) {
            times[1].add(1L);
        } else if (value < 50L) {
            times[2].add(1L);
        } else if (value < 100L) {
            times[3].add(1L);
        } else if (value < 200L) {
            times[4].add(1L);
        } else if (value < 500L) {
            times[5].add(1L);
        } else if (value < 1000L) {
            times[6].add(1L);
        } else if (value < 2000L) {
            times[7].add(1L);
        } else if (value < 3000L) {
            times[8].add(1L);
        } else if (value < 4000L) {
            times[9].add(1L);
        } else if (value < 5000L) {
            times[10].add(1L);
        } else if (value < 10000L) {
            times[11].add(1L);
        } else {
            times[12].add(1L);
        }
        if (value > this.putMessageEntireTimeMax) {
            this.putLock.lock();
            this.putMessageEntireTimeMax = value > this.putMessageEntireTimeMax ? value : this.putMessageEntireTimeMax;
            this.putLock.unlock();
        }
    }

    public long getGetMessageEntireTimeMax() {
        return this.getMessageEntireTimeMax;
    }

    public void setGetMessageEntireTimeMax(long value) {
        if (value > this.getMessageEntireTimeMax) {
            this.getLock.lock();
            this.getMessageEntireTimeMax = value > this.getMessageEntireTimeMax ? value : this.getMessageEntireTimeMax;
            this.getLock.unlock();
        }
    }

    public long getDispatchMaxBuffer() {
        return this.dispatchMaxBuffer;
    }

    public void setDispatchMaxBuffer(long value) {
        this.dispatchMaxBuffer = value > this.dispatchMaxBuffer ? value : this.dispatchMaxBuffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        Long totalTimes = this.getPutMessageTimesTotal();
        if (0L == totalTimes) {
            totalTimes = 1L;
        }
        sb.append("\truntime: " + this.getFormatRuntime() + "\r\n");
        sb.append("\tputMessageEntireTimeMax: " + this.putMessageEntireTimeMax + "\r\n");
        sb.append("\tputMessageTimesTotal: " + totalTimes + "\r\n");
        sb.append("\tgetPutMessageFailedTimes: " + this.getPutMessageFailedTimes() + "\r\n");
        sb.append("\tputMessageSizeTotal: " + this.getPutMessageSizeTotal() + "\r\n");
        sb.append("\tputMessageDistributeTime: " + this.getPutMessageDistributeTimeStringInfo(totalTimes) + "\r\n");
        sb.append("\tputMessageAverageSize: " + (double)this.getPutMessageSizeTotal() / totalTimes.doubleValue() + "\r\n");
        sb.append("\tdispatchMaxBuffer: " + this.dispatchMaxBuffer + "\r\n");
        sb.append("\tgetMessageEntireTimeMax: " + this.getMessageEntireTimeMax + "\r\n");
        sb.append("\tputTps: " + this.getPutTps() + "\r\n");
        sb.append("\tgetFoundTps: " + this.getGetFoundTps() + "\r\n");
        sb.append("\tgetMissTps: " + this.getGetMissTps() + "\r\n");
        sb.append("\tgetTotalTps: " + this.getGetTotalTps() + "\r\n");
        sb.append("\tgetTransferredTps: " + this.getGetTransferredTps() + "\r\n");
        return sb.toString();
    }

    public long getPutMessageTimesTotal() {
        ConcurrentMap<String, LongAdder> map = this.putMessageTopicTimesTotal;
        return map.values().parallelStream().mapToLong(LongAdder::longValue).sum();
    }

    private String getFormatRuntime() {
        long millisecond = 1L;
        long second = 1000L;
        long minute = 60000L;
        long hour = 3600000L;
        long day = 86400000L;
        MessageFormat messageFormat = new MessageFormat("[ {0} days, {1} hours, {2} minutes, {3} seconds ]");
        long time = System.currentTimeMillis() - this.messageStoreBootTimestamp;
        long days = time / 86400000L;
        long hours = time % 86400000L / 3600000L;
        long minutes = time % 3600000L / 60000L;
        long seconds = time % 60000L / 1000L;
        return messageFormat.format(new Long[]{days, hours, minutes, seconds});
    }

    public long getPutMessageSizeTotal() {
        ConcurrentMap<String, LongAdder> map = this.putMessageTopicSizeTotal;
        return map.values().parallelStream().mapToLong(LongAdder::longValue).sum();
    }

    private String getPutMessageDistributeTimeStringInfo(Long total) {
        return this.putMessageDistributeTimeToString();
    }

    private String getPutTps() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPutTps(10));
        sb.append(" ");
        sb.append(this.getPutTps(60));
        sb.append(" ");
        sb.append(this.getPutTps(600));
        return sb.toString();
    }

    private String getGetFoundTps() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGetFoundTps(10));
        sb.append(" ");
        sb.append(this.getGetFoundTps(60));
        sb.append(" ");
        sb.append(this.getGetFoundTps(600));
        return sb.toString();
    }

    private String getGetMissTps() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGetMissTps(10));
        sb.append(" ");
        sb.append(this.getGetMissTps(60));
        sb.append(" ");
        sb.append(this.getGetMissTps(600));
        return sb.toString();
    }

    private String getGetTotalTps() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGetTotalTps(10));
        sb.append(" ");
        sb.append(this.getGetTotalTps(60));
        sb.append(" ");
        sb.append(this.getGetTotalTps(600));
        return sb.toString();
    }

    private String getGetTransferredTps() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGetTransferredTps(10));
        sb.append(" ");
        sb.append(this.getGetTransferredTps(60));
        sb.append(" ");
        sb.append(this.getGetTransferredTps(600));
        return sb.toString();
    }

    private String putMessageDistributeTimeToString() {
        LongAdder[] times = this.lastPutMessageDistributeTime;
        if (null == times) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < times.length; ++i) {
            long value = times[i].longValue();
            sb.append(String.format("%s:%d", PUT_MESSAGE_ENTIRE_TIME_MAX_DESC[i], value));
            sb.append(" ");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPutTps(int time) {
        String result = "";
        this.samplingLock.lock();
        try {
            CallSnapshot last = this.putTimesList.getLast();
            if (this.putTimesList.size() > time) {
                CallSnapshot lastBefore = this.putTimesList.get(this.putTimesList.size() - (time + 1));
                result = result + CallSnapshot.getTPS(lastBefore, last);
            }
        }
        finally {
            this.samplingLock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGetFoundTps(int time) {
        String result = "";
        this.samplingLock.lock();
        try {
            CallSnapshot last = this.getTimesFoundList.getLast();
            if (this.getTimesFoundList.size() > time) {
                CallSnapshot lastBefore = this.getTimesFoundList.get(this.getTimesFoundList.size() - (time + 1));
                result = result + CallSnapshot.getTPS(lastBefore, last);
            }
        }
        finally {
            this.samplingLock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGetMissTps(int time) {
        String result = "";
        this.samplingLock.lock();
        try {
            CallSnapshot last = this.getTimesMissList.getLast();
            if (this.getTimesMissList.size() > time) {
                CallSnapshot lastBefore = this.getTimesMissList.get(this.getTimesMissList.size() - (time + 1));
                result = result + CallSnapshot.getTPS(lastBefore, last);
            }
        }
        finally {
            this.samplingLock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGetTotalTps(int time) {
        this.samplingLock.lock();
        double found = 0.0;
        double miss = 0.0;
        try {
            CallSnapshot lastBefore;
            CallSnapshot last = this.getTimesFoundList.getLast();
            if (this.getTimesFoundList.size() > time) {
                lastBefore = this.getTimesFoundList.get(this.getTimesFoundList.size() - (time + 1));
                found = CallSnapshot.getTPS(lastBefore, last);
            }
            last = this.getTimesMissList.getLast();
            if (this.getTimesMissList.size() > time) {
                lastBefore = this.getTimesMissList.get(this.getTimesMissList.size() - (time + 1));
                miss = CallSnapshot.getTPS(lastBefore, last);
            }
        }
        finally {
            this.samplingLock.unlock();
        }
        return Double.toString(found + miss);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGetTransferredTps(int time) {
        String result = "";
        this.samplingLock.lock();
        try {
            CallSnapshot last = this.transferredMsgCountList.getLast();
            if (this.transferredMsgCountList.size() > time) {
                CallSnapshot lastBefore = this.transferredMsgCountList.get(this.transferredMsgCountList.size() - (time + 1));
                result = result + CallSnapshot.getTPS(lastBefore, last);
            }
        }
        finally {
            this.samplingLock.unlock();
        }
        return result;
    }

    public HashMap<String, String> getRuntimeInfo() {
        HashMap<String, String> result = new HashMap<String, String>(64);
        Long totalTimes = this.getPutMessageTimesTotal();
        if (0L == totalTimes) {
            totalTimes = 1L;
        }
        result.put("bootTimestamp", String.valueOf(this.messageStoreBootTimestamp));
        result.put("runtime", this.getFormatRuntime());
        result.put("putMessageEntireTimeMax", String.valueOf(this.putMessageEntireTimeMax));
        result.put("putMessageTimesTotal", String.valueOf(totalTimes));
        result.put("putMessageFailedTimes", String.valueOf(this.putMessageFailedTimes));
        result.put("putMessageSizeTotal", String.valueOf(this.getPutMessageSizeTotal()));
        result.put("putMessageDistributeTime", String.valueOf(this.getPutMessageDistributeTimeStringInfo(totalTimes)));
        result.put("putMessageAverageSize", String.valueOf((double)this.getPutMessageSizeTotal() / totalTimes.doubleValue()));
        result.put("dispatchMaxBuffer", String.valueOf(this.dispatchMaxBuffer));
        result.put("getMessageEntireTimeMax", String.valueOf(this.getMessageEntireTimeMax));
        result.put("putTps", this.getPutTps());
        result.put("getFoundTps", this.getGetFoundTps());
        result.put("getMissTps", this.getGetMissTps());
        result.put("getTotalTps", this.getGetTotalTps());
        result.put("getTransferredTps", this.getGetTransferredTps());
        result.put("putLatency99", String.format("%.2f", this.findPutMessageEntireTimePX(0.99)));
        result.put("putLatency999", String.format("%.2f", this.findPutMessageEntireTimePX(0.999)));
        return result;
    }

    public void run() {
        log.info(this.getServiceName() + " service started");
        while (!this.isStopped()) {
            try {
                this.waitForRunning(1000L);
                this.sampling();
                this.printTps();
            }
            catch (Exception e) {
                log.warn(this.getServiceName() + " service has exception. ", (Throwable)e);
            }
        }
        log.info(this.getServiceName() + " service end");
    }

    public String getServiceName() {
        if (this.brokerIdentity != null && this.brokerIdentity.isInBrokerContainer()) {
            return this.brokerIdentity.getLoggerIdentifier() + StoreStatsService.class.getSimpleName();
        }
        return StoreStatsService.class.getSimpleName();
    }

    private void sampling() {
        this.samplingLock.lock();
        try {
            this.putTimesList.add(new CallSnapshot(System.currentTimeMillis(), this.getPutMessageTimesTotal()));
            if (this.putTimesList.size() > 601) {
                this.putTimesList.removeFirst();
            }
            this.getTimesFoundList.add(new CallSnapshot(System.currentTimeMillis(), this.getMessageTimesTotalFound.longValue()));
            if (this.getTimesFoundList.size() > 601) {
                this.getTimesFoundList.removeFirst();
            }
            this.getTimesMissList.add(new CallSnapshot(System.currentTimeMillis(), this.getMessageTimesTotalMiss.longValue()));
            if (this.getTimesMissList.size() > 601) {
                this.getTimesMissList.removeFirst();
            }
            this.transferredMsgCountList.add(new CallSnapshot(System.currentTimeMillis(), this.getMessageTransferredMsgCount.longValue()));
            if (this.transferredMsgCountList.size() > 601) {
                this.transferredMsgCountList.removeFirst();
            }
        }
        finally {
            this.samplingLock.unlock();
        }
    }

    private void printTps() {
        if (System.currentTimeMillis() > this.lastPrintTimestamp + (long)(printTPSInterval * 1000)) {
            this.lastPrintTimestamp = System.currentTimeMillis();
            log.info("[STORETPS] put_tps {} get_found_tps {} get_miss_tps {} get_transferred_tps {}", new Object[]{this.getPutTps(printTPSInterval), this.getGetFoundTps(printTPSInterval), this.getGetMissTps(printTPSInterval), this.getGetTransferredTps(printTPSInterval)});
            LongAdder[] times = this.resetPutMessageDistributeTime();
            if (null == times) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            long totalPut = 0L;
            for (int i = 0; i < times.length; ++i) {
                long value = times[i].longValue();
                totalPut += value;
                sb.append(String.format("%s:%d", PUT_MESSAGE_ENTIRE_TIME_MAX_DESC[i], value));
                sb.append(" ");
            }
            this.resetPutMessageTimeBuckets();
            this.findPutMessageEntireTimePX(0.99);
            this.findPutMessageEntireTimePX(0.999);
            log.info("[PAGECACHERT] TotalPut {}, PutMessageDistributeTime {}", (Object)totalPut, (Object)sb.toString());
        }
    }

    public LongAdder getGetMessageTimesTotalFound() {
        return this.getMessageTimesTotalFound;
    }

    public LongAdder getGetMessageTimesTotalMiss() {
        return this.getMessageTimesTotalMiss;
    }

    public LongAdder getGetMessageTransferredMsgCount() {
        return this.getMessageTransferredMsgCount;
    }

    public LongAdder getPutMessageFailedTimes() {
        return this.putMessageFailedTimes;
    }

    public LongAdder getSinglePutMessageTopicSizeTotal(String topic) {
        LongAdder previous;
        LongAdder rs = (LongAdder)this.putMessageTopicSizeTotal.get(topic);
        if (null == rs && (previous = this.putMessageTopicSizeTotal.putIfAbsent(topic, rs = new LongAdder())) != null) {
            rs = previous;
        }
        return rs;
    }

    public LongAdder getSinglePutMessageTopicTimesTotal(String topic) {
        LongAdder previous;
        LongAdder rs = (LongAdder)this.putMessageTopicTimesTotal.get(topic);
        if (null == rs && (previous = this.putMessageTopicTimesTotal.putIfAbsent(topic, rs = new LongAdder())) != null) {
            rs = previous;
        }
        return rs;
    }

    public Map<String, LongAdder> getPutMessageTopicTimesTotal() {
        return this.putMessageTopicTimesTotal;
    }

    public Map<String, LongAdder> getPutMessageTopicSizeTotal() {
        return this.putMessageTopicSizeTotal;
    }

    static class CallSnapshot {
        public final long timestamp;
        public final long callTimesTotal;

        public CallSnapshot(long timestamp, long callTimesTotal) {
            this.timestamp = timestamp;
            this.callTimesTotal = callTimesTotal;
        }

        public static double getTPS(CallSnapshot begin, CallSnapshot end) {
            long total = end.callTimesTotal - begin.callTimesTotal;
            Long time = end.timestamp - begin.timestamp;
            double tps = (double)total / time.doubleValue();
            return tps * 1000.0;
        }
    }
}

