/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.admin;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.admin.ConsumeStats;
import org.apache.rocketmq.common.admin.OffsetWrapper;
import org.apache.rocketmq.common.admin.TopicOffset;
import org.apache.rocketmq.common.admin.TopicStatsTable;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.protocol.body.ClusterInfo;
import org.apache.rocketmq.common.protocol.route.BrokerData;
import org.apache.rocketmq.common.protocol.route.TopicRouteData;
import org.apache.rocketmq.common.rpc.ClientMetadata;
import org.apache.rocketmq.common.statictopic.LogicQueueMappingItem;
import org.apache.rocketmq.common.statictopic.TopicConfigAndQueueMapping;
import org.apache.rocketmq.common.statictopic.TopicQueueMappingDetail;
import org.apache.rocketmq.common.statictopic.TopicQueueMappingOne;
import org.apache.rocketmq.common.statictopic.TopicQueueMappingUtils;
import org.apache.rocketmq.remoting.exception.RemotingConnectException;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.remoting.exception.RemotingSendRequestException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;

public class MQAdminUtils {
    public static ClientMetadata getBrokerMetadata(DefaultMQAdminExt defaultMQAdminExt) throws InterruptedException, RemotingConnectException, RemotingTimeoutException, RemotingSendRequestException, MQBrokerException {
        ClientMetadata clientMetadata = new ClientMetadata();
        MQAdminUtils.refreshClusterInfo(defaultMQAdminExt, clientMetadata);
        return clientMetadata;
    }

    public static ClientMetadata getBrokerAndTopicMetadata(String topic, DefaultMQAdminExt defaultMQAdminExt) throws InterruptedException, RemotingException, MQBrokerException {
        ClientMetadata clientMetadata = new ClientMetadata();
        MQAdminUtils.refreshClusterInfo(defaultMQAdminExt, clientMetadata);
        MQAdminUtils.refreshTopicRouteInfo(topic, defaultMQAdminExt, clientMetadata);
        return clientMetadata;
    }

    public static void refreshClusterInfo(DefaultMQAdminExt defaultMQAdminExt, ClientMetadata clientMetadata) throws InterruptedException, MQBrokerException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException {
        ClusterInfo clusterInfo = defaultMQAdminExt.examineBrokerClusterInfo();
        if (clusterInfo == null || clusterInfo.getClusterAddrTable().isEmpty()) {
            throw new RuntimeException("The Cluster info is empty");
        }
        clientMetadata.refreshClusterInfo(clusterInfo);
    }

    public static void refreshTopicRouteInfo(String topic, DefaultMQAdminExt defaultMQAdminExt, ClientMetadata clientMetadata) throws RemotingException, InterruptedException, MQBrokerException {
        TopicRouteData routeData;
        block3: {
            routeData = null;
            try {
                routeData = defaultMQAdminExt.examineTopicRouteInfo(topic);
            }
            catch (MQClientException exception) {
                if (exception.getResponseCode() == 17) break block3;
                throw new MQBrokerException(exception.getResponseCode(), exception.getErrorMessage());
            }
        }
        if (routeData != null && !routeData.getQueueDatas().isEmpty()) {
            clientMetadata.freshTopicRoute(topic, routeData);
        }
    }

    public static Set<String> getAllBrokersInSameCluster(Collection<String> brokers, DefaultMQAdminExt defaultMQAdminExt) throws InterruptedException, MQBrokerException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException {
        ClusterInfo clusterInfo = defaultMQAdminExt.examineBrokerClusterInfo();
        if (clusterInfo == null || clusterInfo.getClusterAddrTable().isEmpty()) {
            throw new RuntimeException("The Cluster info is empty");
        }
        HashSet<String> allBrokers = new HashSet<String>();
        block0: for (String broker : brokers) {
            if (allBrokers.contains(broker)) continue;
            for (Set clusterBrokers : clusterInfo.getClusterAddrTable().values()) {
                if (!clusterBrokers.contains(broker)) continue;
                allBrokers.addAll(clusterBrokers);
                continue block0;
            }
        }
        return allBrokers;
    }

    public static void completeNoTargetBrokers(Map<String, TopicConfigAndQueueMapping> brokerConfigMap, DefaultMQAdminExt defaultMQAdminExt) throws InterruptedException, RemotingConnectException, RemotingTimeoutException, RemotingSendRequestException, MQBrokerException {
        TopicConfigAndQueueMapping configMapping = brokerConfigMap.values().iterator().next();
        String topic = configMapping.getTopicName();
        int queueNum = configMapping.getMappingDetail().getTotalQueues();
        long newEpoch = configMapping.getMappingDetail().getEpoch();
        Set<String> allBrokers = MQAdminUtils.getAllBrokersInSameCluster(brokerConfigMap.keySet(), defaultMQAdminExt);
        for (String broker : allBrokers) {
            if (brokerConfigMap.containsKey(broker)) continue;
            brokerConfigMap.put(broker, new TopicConfigAndQueueMapping(new TopicConfig(topic, 0, 0), new TopicQueueMappingDetail(topic, queueNum, broker, newEpoch)));
        }
    }

    public static void checkIfMasterAlive(Collection<String> brokers, DefaultMQAdminExt defaultMQAdminExt, ClientMetadata clientMetadata) {
        for (String broker : brokers) {
            String addr = clientMetadata.findMasterBrokerAddr(broker);
            if (addr != null) continue;
            throw new RuntimeException("Can't find addr for broker " + broker);
        }
    }

    public static void updateTopicConfigMappingAll(Map<String, TopicConfigAndQueueMapping> brokerConfigMap, DefaultMQAdminExt defaultMQAdminExt, boolean force) throws Exception {
        ClientMetadata clientMetadata = MQAdminUtils.getBrokerMetadata(defaultMQAdminExt);
        MQAdminUtils.checkIfMasterAlive(brokerConfigMap.keySet(), defaultMQAdminExt, clientMetadata);
        for (Map.Entry<String, TopicConfigAndQueueMapping> entry : brokerConfigMap.entrySet()) {
            String broker = entry.getKey();
            String addr = clientMetadata.findMasterBrokerAddr(broker);
            TopicConfigAndQueueMapping configMapping = entry.getValue();
            defaultMQAdminExt.createStaticTopic(addr, defaultMQAdminExt.getCreateTopicKey(), (TopicConfig)configMapping, configMapping.getMappingDetail(), force);
        }
    }

    public static void remappingStaticTopic(String topic, Set<String> brokersToMapIn, Set<String> brokersToMapOut, Map<String, TopicConfigAndQueueMapping> brokerConfigMap, int blockSeqSize, boolean force, DefaultMQAdminExt defaultMQAdminExt) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        TopicConfigAndQueueMapping configMapping;
        String addr;
        ClientMetadata clientMetadata = MQAdminUtils.getBrokerMetadata(defaultMQAdminExt);
        MQAdminUtils.checkIfMasterAlive(brokerConfigMap.keySet(), defaultMQAdminExt, clientMetadata);
        for (String broker : brokersToMapIn) {
            addr = clientMetadata.findMasterBrokerAddr(broker);
            configMapping = brokerConfigMap.get(broker);
            defaultMQAdminExt.createStaticTopic(addr, defaultMQAdminExt.getCreateTopicKey(), (TopicConfig)configMapping, configMapping.getMappingDetail(), force);
        }
        for (String broker : brokersToMapOut) {
            addr = clientMetadata.findMasterBrokerAddr(broker);
            configMapping = brokerConfigMap.get(broker);
            defaultMQAdminExt.createStaticTopic(addr, defaultMQAdminExt.getCreateTopicKey(), (TopicConfig)configMapping, configMapping.getMappingDetail(), force);
        }
        for (String broker : brokersToMapOut) {
            addr = clientMetadata.findMasterBrokerAddr(broker);
            TopicStatsTable statsTable = defaultMQAdminExt.examineTopicStats(addr, topic);
            TopicConfigAndQueueMapping mapOutConfig = brokerConfigMap.get(broker);
            for (Map.Entry entry : mapOutConfig.getMappingDetail().getHostedQueues().entrySet()) {
                List items = (List)entry.getValue();
                Integer globalId = (Integer)entry.getKey();
                if (items.size() < 2) continue;
                LogicQueueMappingItem newLeader = (LogicQueueMappingItem)items.get(items.size() - 1);
                LogicQueueMappingItem oldLeader = (LogicQueueMappingItem)items.get(items.size() - 2);
                if (newLeader.getLogicOffset() > 0L) continue;
                TopicOffset topicOffset = (TopicOffset)statsTable.getOffsetTable().get(new MessageQueue(topic, oldLeader.getBname(), oldLeader.getQueueId()));
                if (topicOffset == null) {
                    throw new RuntimeException("Cannot get the max offset for old leader " + oldLeader);
                }
                if (topicOffset.getMaxOffset() < oldLeader.getStartOffset()) {
                    throw new RuntimeException("The max offset is smaller then the start offset " + oldLeader + " " + topicOffset.getMaxOffset());
                }
                newLeader.setLogicOffset(TopicQueueMappingUtils.blockSeqRoundUp((long)oldLeader.computeStaticQueueOffsetStrictly(topicOffset.getMaxOffset()), (long)blockSeqSize));
                TopicConfigAndQueueMapping mapInConfig = brokerConfigMap.get(newLeader.getBname());
                TopicQueueMappingDetail.putMappingInfo((TopicQueueMappingDetail)mapInConfig.getMappingDetail(), (Integer)globalId, (List)items);
            }
        }
        for (String broker : brokersToMapIn) {
            addr = clientMetadata.findMasterBrokerAddr(broker);
            configMapping = brokerConfigMap.get(broker);
            defaultMQAdminExt.createStaticTopic(addr, defaultMQAdminExt.getCreateTopicKey(), (TopicConfig)configMapping, configMapping.getMappingDetail(), force);
        }
        for (String broker : brokerConfigMap.keySet()) {
            if (brokersToMapIn.contains(broker) || brokersToMapOut.contains(broker)) continue;
            addr = clientMetadata.findMasterBrokerAddr(broker);
            configMapping = brokerConfigMap.get(broker);
            defaultMQAdminExt.createStaticTopic(addr, defaultMQAdminExt.getCreateTopicKey(), (TopicConfig)configMapping, configMapping.getMappingDetail(), force);
        }
    }

    public static Map<String, TopicConfigAndQueueMapping> examineTopicConfigAll(String topic, DefaultMQAdminExt defaultMQAdminExt) throws RemotingException, InterruptedException, MQBrokerException {
        HashMap<String, TopicConfigAndQueueMapping> brokerConfigMap = new HashMap<String, TopicConfigAndQueueMapping>();
        ClientMetadata clientMetadata = new ClientMetadata();
        ClusterInfo clusterInfo = defaultMQAdminExt.examineBrokerClusterInfo();
        if (clusterInfo != null && clusterInfo.getBrokerAddrTable() != null) {
            clientMetadata.refreshClusterInfo(clusterInfo);
        }
        for (String broker : clientMetadata.getBrokerAddrTable().keySet()) {
            String addr = clientMetadata.findMasterBrokerAddr(broker);
            try {
                TopicConfigAndQueueMapping mapping = (TopicConfigAndQueueMapping)defaultMQAdminExt.examineTopicConfig(addr, topic);
                if (mapping == null) continue;
                if (mapping.getMappingDetail() != null) assert (mapping.getMappingDetail().getBname().equals(broker));
                brokerConfigMap.put(broker, mapping);
            }
            catch (MQBrokerException exception1) {
                if (exception1.getResponseCode() == 17) continue;
                throw exception1;
            }
        }
        return brokerConfigMap;
    }

    public static Map<String, TopicConfigAndQueueMapping> examineTopicConfigFromRoute(String topic, TopicRouteData topicRouteData, DefaultMQAdminExt defaultMQAdminExt) throws RemotingException, InterruptedException, MQBrokerException {
        HashMap<String, TopicConfigAndQueueMapping> brokerConfigMap = new HashMap<String, TopicConfigAndQueueMapping>();
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            String broker = bd.getBrokerName();
            String addr = bd.selectBrokerAddr();
            if (addr == null) continue;
            try {
                TopicConfigAndQueueMapping mapping = (TopicConfigAndQueueMapping)defaultMQAdminExt.examineTopicConfig(addr, topic);
                if (mapping == null) continue;
                if (mapping.getMappingDetail() != null) assert (mapping.getMappingDetail().getBname().equals(broker));
                brokerConfigMap.put(broker, mapping);
            }
            catch (MQBrokerException exception) {
                if (exception.getResponseCode() == 17) continue;
                throw exception;
            }
        }
        return brokerConfigMap;
    }

    public static void convertPhysicalTopicStats(String topic, Map<String, TopicConfigAndQueueMapping> brokerConfigMap, TopicStatsTable topicStatsTable) {
        Map globalIdMap = TopicQueueMappingUtils.checkAndBuildMappingItems((List)TopicQueueMappingUtils.getMappingDetailFromConfig(brokerConfigMap.values()), (boolean)true, (boolean)false);
        for (Map.Entry entry : globalIdMap.entrySet()) {
            long max;
            Integer qid = (Integer)entry.getKey();
            TopicQueueMappingOne mappingOne = (TopicQueueMappingOne)entry.getValue();
            LogicQueueMappingItem minItem = TopicQueueMappingUtils.findLogicQueueMappingItem((List)mappingOne.getItems(), (long)0L, (boolean)true);
            LogicQueueMappingItem maxItem = TopicQueueMappingUtils.findLogicQueueMappingItem((List)mappingOne.getItems(), (long)Long.MAX_VALUE, (boolean)true);
            assert (minItem != null && maxItem != null);
            TopicOffset minTopicOffset = (TopicOffset)topicStatsTable.getOffsetTable().get(new MessageQueue(topic, minItem.getBname(), minItem.getQueueId()));
            TopicOffset maxTopicOffset = (TopicOffset)topicStatsTable.getOffsetTable().get(new MessageQueue(topic, maxItem.getBname(), maxItem.getQueueId()));
            if (minTopicOffset == null || maxTopicOffset == null) continue;
            long min = minItem.computeStaticQueueOffsetLoosely(minTopicOffset.getMinOffset());
            if (min < 0L) {
                min = 0L;
            }
            if ((max = maxItem.computeStaticQueueOffsetStrictly(maxTopicOffset.getMaxOffset())) < 0L) {
                max = 0L;
            }
            long timestamp = maxTopicOffset.getLastUpdateTimestamp();
            TopicOffset topicOffset = new TopicOffset();
            topicOffset.setMinOffset(min);
            topicOffset.setMaxOffset(max);
            topicOffset.setLastUpdateTimestamp(timestamp);
            topicStatsTable.getOffsetTable().put(new MessageQueue(topic, TopicQueueMappingUtils.getMockBrokerName((String)mappingOne.getMappingDetail().getScope()), qid.intValue()), topicOffset);
        }
    }

    public static ConsumeStats convertPhysicalConsumeStats(Map<String, TopicConfigAndQueueMapping> brokerConfigMap, ConsumeStats physicalResult) {
        Map globalIdMap = TopicQueueMappingUtils.checkAndBuildMappingItems((List)TopicQueueMappingUtils.getMappingDetailFromConfig(brokerConfigMap.values()), (boolean)true, (boolean)false);
        ConsumeStats result = new ConsumeStats();
        result.setConsumeTps(physicalResult.getConsumeTps());
        for (Map.Entry entry : globalIdMap.entrySet()) {
            Integer qid = (Integer)entry.getKey();
            TopicQueueMappingOne mappingOne = (TopicQueueMappingOne)entry.getValue();
            MessageQueue messageQueue = new MessageQueue(mappingOne.getTopic(), TopicQueueMappingUtils.getMockBrokerName((String)mappingOne.getMappingDetail().getScope()), qid.intValue());
            OffsetWrapper offsetWrapper = new OffsetWrapper();
            long brokerOffset = -1L;
            long consumerOffset = -1L;
            long lastTimestamp = -1L;
            for (int i = mappingOne.getItems().size() - 1; i >= 0; --i) {
                LogicQueueMappingItem item = (LogicQueueMappingItem)mappingOne.getItems().get(i);
                MessageQueue phyQueue = new MessageQueue(mappingOne.getTopic(), item.getBname(), item.getQueueId());
                OffsetWrapper phyOffsetWrapper = (OffsetWrapper)physicalResult.getOffsetTable().get(phyQueue);
                if (phyOffsetWrapper == null) continue;
                if (consumerOffset == -1L && phyOffsetWrapper.getConsumerOffset() >= 0L) {
                    consumerOffset = phyOffsetWrapper.getConsumerOffset();
                    lastTimestamp = phyOffsetWrapper.getLastTimestamp();
                }
                if (brokerOffset == -1L && item.getLogicOffset() >= 0L) {
                    brokerOffset = item.computeStaticQueueOffsetStrictly(phyOffsetWrapper.getBrokerOffset());
                }
                if (consumerOffset >= 0L && brokerOffset >= 0L) break;
            }
            if (brokerOffset < 0L || consumerOffset < 0L) continue;
            offsetWrapper.setBrokerOffset(brokerOffset);
            offsetWrapper.setConsumerOffset(consumerOffset);
            offsetWrapper.setLastTimestamp(lastTimestamp);
            result.getOffsetTable().put(messageQueue, offsetWrapper);
        }
        return result;
    }
}

