/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.transaction;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ComparisonChain;

public class TransactionData
implements Comparable<TransactionData> {
    private final String brokerName;
    private final long tranStateTableOffset;
    private final long commitLogOffset;
    private final String transactionId;
    private final long checkTimestamp;
    private final long expireMs;

    public TransactionData(String brokerName, long tranStateTableOffset, long commitLogOffset, String transactionId, long checkTimestamp, long expireMs) {
        this.brokerName = brokerName;
        this.tranStateTableOffset = tranStateTableOffset;
        this.commitLogOffset = commitLogOffset;
        this.transactionId = transactionId;
        this.checkTimestamp = checkTimestamp;
        this.expireMs = expireMs;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public long getTranStateTableOffset() {
        return this.tranStateTableOffset;
    }

    public long getCommitLogOffset() {
        return this.commitLogOffset;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public long getCheckTimestamp() {
        return this.checkTimestamp;
    }

    public long getExpireMs() {
        return this.expireMs;
    }

    public long getExpireTime() {
        return this.checkTimestamp + this.expireMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionData data = (TransactionData)o;
        return this.tranStateTableOffset == data.tranStateTableOffset && this.commitLogOffset == data.commitLogOffset && this.getExpireTime() == data.getExpireTime() && Objects.equal((Object)this.brokerName, (Object)data.brokerName) && Objects.equal((Object)this.transactionId, (Object)data.transactionId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.brokerName, this.transactionId, this.tranStateTableOffset, this.commitLogOffset, this.getExpireTime()});
    }

    @Override
    public int compareTo(TransactionData o) {
        return ComparisonChain.start().compare(this.getExpireTime(), o.getExpireTime()).compare((Comparable)((Object)this.brokerName), (Comparable)((Object)o.brokerName)).compare(this.commitLogOffset, o.commitLogOffset).compare(this.tranStateTableOffset, o.tranStateTableOffset).compare((Comparable)((Object)this.transactionId), (Comparable)((Object)o.transactionId)).result();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("brokerName", (Object)this.brokerName).add("tranStateTableOffset", this.tranStateTableOffset).add("commitLogOffset", this.commitLogOffset).add("transactionId", (Object)this.transactionId).add("checkTimestamp", this.checkTimestamp).add("expireMs", this.expireMs).toString();
    }
}

