/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.acl;

import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.srvutil.ServerUtil;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.CommandUtil;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class DeleteAccessConfigSubCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "deleteAclConfig";
    }

    @Override
    public String commandAlias() {
        return "deleteAccessConfig";
    }

    @Override
    public String commandDesc() {
        return "Delete Acl Config Account in broker";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        OptionGroup optionGroup = new OptionGroup();
        Option opt = new Option("b", "brokerAddr", true, "delete acl config account from which broker");
        optionGroup.addOption(opt);
        opt = new Option("c", "clusterName", true, "delete acl config account from which cluster");
        optionGroup.addOption(opt);
        optionGroup.setRequired(true);
        options.addOptionGroup(optionGroup);
        opt = new Option("a", "accessKey", true, "set accessKey in acl config file for deleting which account");
        opt.setRequired(true);
        options.addOption(opt);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            String accessKey = commandLine.getOptionValue('a').trim();
            if (commandLine.hasOption('b')) {
                String addr = commandLine.getOptionValue('b').trim();
                defaultMQAdminExt.start();
                defaultMQAdminExt.deletePlainAccessConfig(addr, accessKey);
                System.out.printf("delete plain access config account from %s success.%n", addr);
                System.out.printf("account's accessKey is:%s", accessKey);
                return;
            }
            if (commandLine.hasOption('c')) {
                String clusterName = commandLine.getOptionValue('c').trim();
                defaultMQAdminExt.start();
                Set<String> brokerAddrSet = CommandUtil.fetchMasterAndSlaveAddrByClusterName(defaultMQAdminExt, clusterName);
                for (String addr : brokerAddrSet) {
                    defaultMQAdminExt.deletePlainAccessConfig(addr, accessKey);
                    System.out.printf("delete plain access config account from %s success.%n", addr);
                }
                System.out.printf("account's accessKey is:%s", accessKey);
                return;
            }
            ServerUtil.printCommandLineHelp((String)("mqadmin " + this.commandName()), (Options)options);
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }
}

