/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.message;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class DumpCompactionLogCommand
implements SubCommand {
    @Override
    public String commandDesc() {
        return "Parse compaction log to message.";
    }

    @Override
    public String commandName() {
        return "dumpCompactionLog";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("f", "file", true, "to dump file name");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        if (commandLine.hasOption("f")) {
            String fileName = commandLine.getOptionValue("f");
            Path filePath = Paths.get(fileName, new String[0]);
            if (!Files.exists(filePath, new LinkOption[0])) {
                throw new SubCommandException("file " + fileName + " not exist.");
            }
            if (Files.isDirectory(filePath, new LinkOption[0])) {
                throw new SubCommandException("file " + fileName + " is a directory.");
            }
            try {
                long fileSize = Files.size(filePath);
                FileChannel fileChannel = new RandomAccessFile(fileName, "rw").getChannel();
                MappedByteBuffer buf = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, fileSize);
                int current = 0;
                while ((long)current < fileSize) {
                    ((ByteBuffer)buf).position(current);
                    ByteBuffer bb = ((ByteBuffer)buf).slice();
                    int size = bb.getInt();
                    if (size > buf.capacity() || size < 0) break;
                    bb.limit(size);
                    bb.rewind();
                    try {
                        MessageExt messageExt = MessageDecoder.decode((ByteBuffer)bb, (boolean)false, (boolean)false);
                        if (messageExt == null) break;
                        current += size;
                        System.out.printf(messageExt + "\n", new Object[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                UtilAll.cleanBuffer((ByteBuffer)buf);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.print("miss dump log file name\n");
        }
    }
}

