/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.transaction;

import io.netty.channel.Channel;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.header.CheckTransactionStateRequestHeader;

public abstract class AbstractTransactionalMessageCheckListener {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqTransaction");
    private BrokerController brokerController;
    protected static final int TCMT_QUEUE_NUMS = 1;
    private static volatile ExecutorService executorService;

    public AbstractTransactionalMessageCheckListener() {
    }

    public AbstractTransactionalMessageCheckListener(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public void sendCheckMessage(MessageExt msgExt) throws Exception {
        CheckTransactionStateRequestHeader checkTransactionStateRequestHeader = new CheckTransactionStateRequestHeader();
        checkTransactionStateRequestHeader.setCommitLogOffset(Long.valueOf(msgExt.getCommitLogOffset()));
        checkTransactionStateRequestHeader.setOffsetMsgId(msgExt.getMsgId());
        checkTransactionStateRequestHeader.setMsgId(msgExt.getUserProperty("UNIQ_KEY"));
        checkTransactionStateRequestHeader.setTransactionId(checkTransactionStateRequestHeader.getMsgId());
        checkTransactionStateRequestHeader.setTranStateTableOffset(Long.valueOf(msgExt.getQueueOffset()));
        checkTransactionStateRequestHeader.setBname(this.brokerController.getBrokerConfig().getBrokerName());
        msgExt.setTopic(msgExt.getUserProperty("REAL_TOPIC"));
        msgExt.setQueueId(Integer.parseInt(msgExt.getUserProperty("REAL_QID")));
        msgExt.setStoreSize(0);
        String groupId = msgExt.getProperty("PGROUP");
        Channel channel = this.brokerController.getProducerManager().getAvailableChannel(groupId);
        if (channel != null) {
            this.brokerController.getBroker2Client().checkProducerTransactionState(groupId, channel, checkTransactionStateRequestHeader, msgExt);
        } else {
            LOGGER.warn("Check transaction failed, channel is null. groupId={}", (Object)groupId);
        }
    }

    public void resolveHalfMsg(final MessageExt msgExt) {
        if (executorService != null) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractTransactionalMessageCheckListener.this.sendCheckMessage(msgExt);
                    }
                    catch (Exception e) {
                        LOGGER.error("Send check message error!", (Throwable)e);
                    }
                }
            });
        } else {
            LOGGER.error("TransactionalMessageCheckListener not init");
        }
    }

    public BrokerController getBrokerController() {
        return this.brokerController;
    }

    public void shutDown() {
        if (executorService != null) {
            executorService.shutdown();
        }
    }

    public synchronized void initExecutorService() {
        if (executorService == null) {
            executorService = ThreadUtils.newThreadPoolExecutor((int)2, (int)5, (long)100L, (TimeUnit)TimeUnit.SECONDS, new ArrayBlockingQueue(2000), (ThreadFactory)new ThreadFactoryImpl("Transaction-msg-check-thread", this.brokerController.getBrokerIdentity()), (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        }
    }

    public void setBrokerController(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.initExecutorService();
    }

    public abstract void resolveDiscardMsg(MessageExt var1);
}

