/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import apache.rocketmq.v2.AckMessageRequest;
import apache.rocketmq.v2.AckMessageResponse;
import apache.rocketmq.v2.ChangeInvisibleDurationRequest;
import apache.rocketmq.v2.ChangeInvisibleDurationResponse;
import apache.rocketmq.v2.ReceiveMessageRequest;
import apache.rocketmq.v2.Status;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.javacrumbs.futureconverter.java8guava.FutureConverter;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.consumer.FilterExpression;
import org.apache.rocketmq.client.apis.consumer.SimpleConsumer;
import org.apache.rocketmq.client.apis.message.MessageView;
import org.apache.rocketmq.client.java.exception.StatusChecker;
import org.apache.rocketmq.client.java.impl.Settings;
import org.apache.rocketmq.client.java.impl.consumer.ConsumerImpl;
import org.apache.rocketmq.client.java.impl.consumer.SimpleSubscriptionSettings;
import org.apache.rocketmq.client.java.impl.consumer.SubscriptionLoadBalancer;
import org.apache.rocketmq.client.java.message.MessageViewImpl;
import org.apache.rocketmq.client.java.message.protocol.Resource;
import org.apache.rocketmq.client.java.route.MessageQueueImpl;
import org.apache.rocketmq.client.java.route.TopicRouteData;
import org.apache.rocketmq.client.java.rpc.RpcFuture;
import org.apache.rocketmq.shaded.com.google.common.math.IntMath;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.Futures;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.apache.rocketmq.shaded.commons.lang3.RandomUtils;
import org.apache.rocketmq.shaded.org.slf4j.Logger;
import org.apache.rocketmq.shaded.org.slf4j.LoggerFactory;

class SimpleConsumerImpl
extends ConsumerImpl
implements SimpleConsumer {
    private static final Logger log = LoggerFactory.getLogger(SimpleConsumerImpl.class);
    private final SimpleSubscriptionSettings simpleSubscriptionSettings;
    private final String consumerGroup;
    private final Duration awaitDuration;
    private final AtomicInteger topicIndex;
    private final Map<String, FilterExpression> subscriptionExpressions;
    private final ConcurrentMap<String, SubscriptionLoadBalancer> subscriptionRouteDataCache;

    public SimpleConsumerImpl(ClientConfiguration clientConfiguration, String consumerGroup, Duration awaitDuration, Map<String, FilterExpression> subscriptionExpressions) {
        super(clientConfiguration, consumerGroup, subscriptionExpressions.keySet());
        Resource groupResource = new Resource(consumerGroup);
        this.simpleSubscriptionSettings = new SimpleSubscriptionSettings(this.clientId, this.endpoints, groupResource, clientConfiguration.getRequestTimeout(), awaitDuration, subscriptionExpressions);
        this.consumerGroup = consumerGroup;
        this.awaitDuration = awaitDuration;
        this.topicIndex = new AtomicInteger(RandomUtils.nextInt(0, Integer.MAX_VALUE));
        this.subscriptionExpressions = subscriptionExpressions;
        this.subscriptionRouteDataCache = new ConcurrentHashMap<String, SubscriptionLoadBalancer>();
    }

    @Override
    protected void startUp() throws Exception {
        try {
            log.info("Begin to start the rocketmq simple consumer, clientId={}", (Object)this.clientId);
            super.startUp();
            log.info("The rocketmq simple consumer starts successfully, clientId={}", (Object)this.clientId);
        }
        catch (Throwable t) {
            log.error("Failed to start the rocketmq simple consumer, try to shutdown it, clientId={}", (Object)this.clientId, (Object)t);
            this.shutDown();
            throw t;
        }
    }

    @Override
    protected void shutDown() throws InterruptedException {
        log.info("Begin to shutdown the rocketmq simple consumer, clientId={}", (Object)this.clientId);
        super.shutDown();
        log.info("Shutdown the rocketmq simple consumer successfully, clientId={}", (Object)this.clientId);
    }

    @Override
    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    @Override
    public SimpleConsumer subscribe(String topic, FilterExpression filterExpression) throws ClientException {
        if (!this.isRunning()) {
            log.error("Unable to add subscription because simple consumer is not running, state={}, clientId={}", (Object)this.state(), (Object)this.clientId);
            throw new IllegalStateException("Simple consumer is not running now");
        }
        ListenableFuture<TopicRouteData> future = this.getRouteData(topic);
        this.handleClientFuture(future);
        this.subscriptionExpressions.put(topic, filterExpression);
        return this;
    }

    @Override
    public SimpleConsumer unsubscribe(String topic) {
        if (!this.isRunning()) {
            log.error("Unable to remove subscription because simple consumer is not running, state={}, clientId={}", (Object)this.state(), (Object)this.clientId);
            throw new IllegalStateException("Simple consumer is not running now");
        }
        this.subscriptionExpressions.remove(topic);
        return this;
    }

    @Override
    public Map<String, FilterExpression> getSubscriptionExpressions() {
        return new HashMap<String, FilterExpression>(this.subscriptionExpressions);
    }

    @Override
    public List<MessageView> receive(int maxMessageNum, Duration invisibleDuration) throws ClientException {
        ListenableFuture<List<MessageView>> future = this.receive0(maxMessageNum, invisibleDuration);
        return this.handleClientFuture(future);
    }

    @Override
    public CompletableFuture<List<MessageView>> receiveAsync(int maxMessageNum, Duration invisibleDuration) {
        ListenableFuture<List<MessageView>> future = this.receive0(maxMessageNum, invisibleDuration);
        return FutureConverter.toCompletableFuture(future);
    }

    public ListenableFuture<List<MessageView>> receive0(int maxMessageNum, Duration invisibleDuration) {
        if (!this.isRunning()) {
            log.error("Unable to receive message because simple consumer is not running, state={}, clientId={}", (Object)this.state(), (Object)this.clientId);
            IllegalStateException e = new IllegalStateException("Simple consumer is not running now");
            return Futures.immediateFailedFuture(e);
        }
        if (maxMessageNum <= 0) {
            IllegalArgumentException e = new IllegalArgumentException("maxMessageNum must be greater than 0");
            return Futures.immediateFailedFuture(e);
        }
        HashMap<String, FilterExpression> copy = new HashMap<String, FilterExpression>(this.subscriptionExpressions);
        ArrayList<String> topics = new ArrayList<String>(copy.keySet());
        if (topics.isEmpty()) {
            IllegalArgumentException e = new IllegalArgumentException("There is no topic to receive message");
            return Futures.immediateFailedFuture(e);
        }
        String topic = topics.get(IntMath.mod(this.topicIndex.getAndIncrement(), topics.size()));
        FilterExpression filterExpression = copy.get(topic);
        ListenableFuture<SubscriptionLoadBalancer> routeFuture = this.getSubscriptionLoadBalancer(topic);
        ListenableFuture future0 = Futures.transformAsync(routeFuture, result -> {
            MessageQueueImpl mq = result.takeMessageQueue();
            ReceiveMessageRequest request = this.wrapReceiveMessageRequest(maxMessageNum, mq, filterExpression, invisibleDuration);
            return this.receiveMessage(request, mq, this.awaitDuration);
        }, MoreExecutors.directExecutor());
        return Futures.transformAsync(future0, result -> Futures.immediateFuture(result.getMessageViews()), this.clientCallbackExecutor);
    }

    @Override
    public void ack(MessageView messageView) throws ClientException {
        ListenableFuture<Void> future = this.ack0(messageView);
        this.handleClientFuture(future);
    }

    @Override
    public CompletableFuture<Void> ackAsync(MessageView messageView) {
        ListenableFuture<Void> future = this.ack0(messageView);
        return FutureConverter.toCompletableFuture(future);
    }

    private ListenableFuture<Void> ack0(MessageView messageView) {
        if (!this.isRunning()) {
            log.error("Unable to ack message because simple consumer is not running, state={}, clientId={}", (Object)this.state(), (Object)this.clientId);
            IllegalStateException e = new IllegalStateException("Simple consumer is not running now");
            return Futures.immediateFailedFuture(e);
        }
        if (!(messageView instanceof MessageViewImpl)) {
            IllegalArgumentException exception = new IllegalArgumentException("Failed downcasting for messageView");
            return Futures.immediateFailedFuture(exception);
        }
        MessageViewImpl impl = (MessageViewImpl)messageView;
        RpcFuture<AckMessageRequest, AckMessageResponse> future = this.ackMessage(impl);
        return Futures.transformAsync(future, response -> {
            Status status = response.getStatus();
            StatusChecker.check(status, future);
            return Futures.immediateVoidFuture();
        }, this.clientCallbackExecutor);
    }

    @Override
    public void changeInvisibleDuration(MessageView messageView, Duration invisibleDuration) throws ClientException {
        ListenableFuture<Void> future = this.changeInvisibleDuration0(messageView, invisibleDuration);
        this.handleClientFuture(future);
    }

    @Override
    public CompletableFuture<Void> changeInvisibleDurationAsync(MessageView messageView, Duration invisibleDuration) {
        ListenableFuture<Void> future = this.changeInvisibleDuration0(messageView, invisibleDuration);
        return FutureConverter.toCompletableFuture(future);
    }

    public ListenableFuture<Void> changeInvisibleDuration0(MessageView messageView, Duration invisibleDuration) {
        if (!this.isRunning()) {
            log.error("Unable to change invisible duration because simple consumer is not running, state={}, clientId={}", (Object)this.state(), (Object)this.clientId);
            IllegalStateException e = new IllegalStateException("Simple consumer is not running now");
            return Futures.immediateFailedFuture(e);
        }
        if (!(messageView instanceof MessageViewImpl)) {
            IllegalArgumentException exception = new IllegalArgumentException("Failed downcasting for messageView");
            return Futures.immediateFailedFuture(exception);
        }
        MessageViewImpl impl = (MessageViewImpl)messageView;
        RpcFuture<ChangeInvisibleDurationRequest, ChangeInvisibleDurationResponse> future = this.changeInvisibleDuration(impl, invisibleDuration);
        return Futures.transformAsync(future, response -> {
            impl.setReceiptHandle(response.getReceiptHandle());
            Status status = response.getStatus();
            StatusChecker.check(status, future);
            return Futures.immediateVoidFuture();
        }, MoreExecutors.directExecutor());
    }

    @Override
    public void close() {
        this.stopAsync().awaitTerminated();
    }

    @Override
    public Settings getSettings() {
        return this.simpleSubscriptionSettings;
    }

    private SubscriptionLoadBalancer updateSubscriptionLoadBalancer(String topic, TopicRouteData topicRouteData) {
        SubscriptionLoadBalancer subscriptionLoadBalancer = (SubscriptionLoadBalancer)this.subscriptionRouteDataCache.get(topic);
        subscriptionLoadBalancer = null == subscriptionLoadBalancer ? new SubscriptionLoadBalancer(topicRouteData) : subscriptionLoadBalancer.update(topicRouteData);
        this.subscriptionRouteDataCache.put(topic, subscriptionLoadBalancer);
        return subscriptionLoadBalancer;
    }

    @Override
    public void onTopicRouteDataUpdate0(String topic, TopicRouteData topicRouteData) {
        this.updateSubscriptionLoadBalancer(topic, topicRouteData);
    }

    private ListenableFuture<SubscriptionLoadBalancer> getSubscriptionLoadBalancer(String topic) {
        SubscriptionLoadBalancer loadBalancer = (SubscriptionLoadBalancer)this.subscriptionRouteDataCache.get(topic);
        if (null != loadBalancer) {
            return Futures.immediateFuture(loadBalancer);
        }
        return Futures.transform(this.getRouteData(topic), topicRouteData -> this.updateSubscriptionLoadBalancer(topic, (TopicRouteData)topicRouteData), MoreExecutors.directExecutor());
    }
}

