/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.protocol.mqtt.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribePayload;
import java.util.HashSet;
import javax.annotation.Resource;
import org.apache.rocketmq.mqtt.common.hook.HookResult;
import org.apache.rocketmq.mqtt.common.model.Subscription;
import org.apache.rocketmq.mqtt.common.util.TopicUtils;
import org.apache.rocketmq.mqtt.cs.channel.ChannelCloseFrom;
import org.apache.rocketmq.mqtt.cs.channel.ChannelInfo;
import org.apache.rocketmq.mqtt.cs.channel.ChannelManager;
import org.apache.rocketmq.mqtt.cs.protocol.mqtt.MqttPacketHandler;
import org.apache.rocketmq.mqtt.cs.protocol.mqtt.facotry.MqttMessageFactory;
import org.apache.rocketmq.mqtt.cs.session.loop.SessionLoop;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MqttUnSubscribeHandler
implements MqttPacketHandler<MqttUnsubscribeMessage> {
    private static Logger logger = LoggerFactory.getLogger(MqttUnSubscribeHandler.class);
    @Resource
    private SessionLoop sessionLoop;
    @Resource
    private ChannelManager channelManager;

    @Override
    public boolean preHandler(ChannelHandlerContext ctx, MqttUnsubscribeMessage mqttMessage) {
        return true;
    }

    @Override
    public void doHandler(ChannelHandlerContext ctx, MqttUnsubscribeMessage mqttMessage, HookResult upstreamHookResult) {
        String clientId = ChannelInfo.getClientId(ctx.channel());
        Channel channel = ctx.channel();
        String remark = upstreamHookResult.getRemark();
        if (!upstreamHookResult.isSuccess()) {
            this.channelManager.closeConnect(channel, ChannelCloseFrom.SERVER, remark);
            return;
        }
        try {
            MqttUnsubscribePayload payload = mqttMessage.payload();
            if (payload.topics() != null && !payload.topics().isEmpty()) {
                HashSet<Subscription> subscriptions = new HashSet<Subscription>();
                for (String topic : payload.topics()) {
                    subscriptions.add(new Subscription(TopicUtils.normalizeTopic((String)topic)));
                }
                this.sessionLoop.removeSubscription(ChannelInfo.getId(ctx.channel()), subscriptions);
            }
            int messageId = mqttMessage.variableHeader().messageId();
            channel.writeAndFlush((Object)MqttMessageFactory.buildUnsubAckMessage(messageId));
        }
        catch (Exception e) {
            logger.error("UnSubscribe:{}", (Object)clientId, (Object)e);
            this.channelManager.closeConnect(channel, ChannelCloseFrom.SERVER, "UnSubscribeException");
        }
    }
}

