/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.meta.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiskUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiskUtils.class);
    private static final String NO_SPACE_CN = "no space";
    private static final String NO_SPACE_EN = "No space left on device";
    private static final String DISK_QUATA_CN = "out of disk";
    private static final String DISK_QUATA_EN = "Disk quota exceeded";
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final CharsetDecoder DECODER = CHARSET.newDecoder();

    public static void touch(File file) throws IOException {
        FileUtils.touch((File)file);
    }

    public static String readFile(String path, String fileName) {
        File file = DiskUtils.openFile(path, fileName);
        if (file.exists()) {
            return DiskUtils.readFile(file);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFile(File file) {
        try (FileChannel fileChannel = new FileInputStream(file).getChannel();){
            StringBuilder text = new StringBuilder();
            ByteBuffer buffer = ByteBuffer.allocate(4096);
            CharBuffer charBuffer = CharBuffer.allocate(4096);
            while (fileChannel.read(buffer) != -1) {
                buffer.flip();
                DECODER.decode(buffer, charBuffer, false);
                charBuffer.flip();
                while (charBuffer.hasRemaining()) {
                    text.append(charBuffer.get());
                }
                buffer.clear();
                charBuffer.clear();
            }
            String string = text.toString();
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeFile(File file, byte[] content, boolean append) {
        try (FileChannel fileChannel = new FileOutputStream(file, append).getChannel();){
            ByteBuffer buffer = ByteBuffer.wrap(content);
            fileChannel.write(buffer);
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            if (ioe.getMessage() == null) return false;
            String errMsg = ioe.getMessage();
            if (!(NO_SPACE_CN.equals(errMsg) || NO_SPACE_EN.equals(errMsg) || errMsg.contains(DISK_QUATA_CN))) {
                if (!errMsg.contains(DISK_QUATA_EN)) return false;
            }
            LOGGER.warn(DISK_QUATA_CN);
            System.exit(0);
            return false;
        }
    }

    public static void deleteDirectory(String path) throws IOException {
        FileUtils.deleteDirectory((File)new File(path));
    }

    public static File openFile(String path, String fileName) {
        return DiskUtils.openFile(path, fileName, false);
    }

    public static File openFile(String path, String fileName, boolean rewrite) {
        File directory = new File(path);
        boolean mkdirs = true;
        if (!directory.exists()) {
            mkdirs = directory.mkdirs();
        }
        if (!mkdirs) {
            LOGGER.error("[DiskUtils] can't create directory");
            return null;
        }
        File file = new File(path, fileName);
        try {
            boolean create = true;
            if (!file.exists()) {
                file.createNewFile();
            }
            if (file.exists()) {
                if (rewrite) {
                    file.delete();
                } else {
                    create = false;
                }
            }
            if (create) {
                file.createNewFile();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return file;
    }
}

