/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.client.failover.impl;

import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.rhea.client.failover.FailoverClosure;
import com.alipay.sofa.jraft.rhea.client.failover.RetryRunner;
import com.alipay.sofa.jraft.rhea.errors.Errors;
import com.alipay.sofa.jraft.rhea.errors.ErrorsHelper;
import com.alipay.sofa.jraft.rhea.storage.BaseKVStoreClosure;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FailoverClosureImpl<T>
extends BaseKVStoreClosure
implements FailoverClosure<T> {
    private static final Logger LOG = LoggerFactory.getLogger(FailoverClosureImpl.class);
    private final CompletableFuture<T> future;
    private final boolean retryOnInvalidEpoch;
    private final int retriesLeft;
    private final RetryRunner retryRunner;

    public FailoverClosureImpl(CompletableFuture<T> future, int retriesLeft, RetryRunner retryRunner) {
        this(future, true, retriesLeft, retryRunner);
    }

    public FailoverClosureImpl(CompletableFuture<T> future, boolean retryOnInvalidEpoch, int retriesLeft, RetryRunner retryRunner) {
        this.future = future;
        this.retryOnInvalidEpoch = retryOnInvalidEpoch;
        this.retriesLeft = retriesLeft;
        this.retryRunner = retryRunner;
    }

    public void run(Status status) {
        if (status.isOk()) {
            this.success(this.getData());
            return;
        }
        Errors error = this.getError();
        if (this.retriesLeft > 0 && (ErrorsHelper.isInvalidPeer(error) || this.retryOnInvalidEpoch && ErrorsHelper.isInvalidEpoch(error))) {
            LOG.warn("[Failover] status: {}, error: {}, [{}] retries left.", new Object[]{status, error, this.retriesLeft});
            this.retryRunner.run(error);
        } else {
            if (this.retriesLeft <= 0) {
                LOG.error("[InvalidEpoch-Failover] status: {}, error: {}, {} retries left.", new Object[]{status, error, this.retriesLeft});
            }
            this.failure(error);
        }
    }

    @Override
    public CompletableFuture<T> future() {
        return this.future;
    }

    @Override
    public void success(T result) {
        this.future.complete(result);
    }

    @Override
    public void failure(Throwable cause) {
        this.future.completeExceptionally(cause);
    }

    @Override
    public void failure(Errors error) {
        if (error == null) {
            this.failure(new NullPointerException("The error message is missing, this should not happen, now only the stack information can be referenced."));
        } else {
            this.failure(error.exception());
        }
    }
}

