/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.storage;

import com.alipay.sofa.jraft.entity.LocalFileMetaOutter;
import com.alipay.sofa.jraft.rhea.errors.StorageException;
import com.alipay.sofa.jraft.rhea.metadata.Region;
import com.alipay.sofa.jraft.rhea.storage.AbstractKVStoreSnapshotFile;
import com.alipay.sofa.jraft.rhea.storage.MemoryRawKVStore;
import com.alipay.sofa.jraft.rhea.util.ByteArray;
import com.alipay.sofa.jraft.rhea.util.Pair;
import com.alipay.sofa.jraft.rhea.util.RegionHelper;
import com.alipay.sofa.jraft.rhea.util.concurrent.DistributedLock;
import com.alipay.sofa.jraft.util.Bits;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;

public class MemoryKVStoreSnapshotFile
extends AbstractKVStoreSnapshotFile {
    private final MemoryRawKVStore kvStore;

    MemoryKVStoreSnapshotFile(MemoryRawKVStore kvStore) {
        this.kvStore = kvStore;
    }

    @Override
    CompletableFuture<LocalFileMetaOutter.LocalFileMeta.Builder> doSnapshotSave(String snapshotPath, Region region, ExecutorService executor) throws Exception {
        this.kvStore.doSnapshotSave(this, snapshotPath, region);
        return CompletableFuture.completedFuture(this.writeMetadata(region));
    }

    @Override
    void doSnapshotLoad(String snapshotPath, LocalFileMetaOutter.LocalFileMeta meta, Region region) throws Exception {
        File file = new File(snapshotPath);
        if (!file.exists()) {
            throw new StorageException("Snapshot file [" + snapshotPath + "] not exists");
        }
        Region snapshotRegion = this.readMetadata(meta, Region.class);
        if (!RegionHelper.isSameRange(region, snapshotRegion)) {
            throw new StorageException("Invalid snapshot region: " + snapshotRegion + ", current region is: " + region);
        }
        this.kvStore.doSnapshotLoad(this, snapshotPath);
    }

    <T> void writeToFile(String rootPath, String fileName, Persistence<T> persist) throws Exception {
        Path path = Paths.get(rootPath, fileName);
        try (FileOutputStream out = new FileOutputStream(path.toFile());
             BufferedOutputStream bufOutput = new BufferedOutputStream(out);){
            byte[] bytes = this.serializer.writeObject(persist);
            byte[] lenBytes = new byte[4];
            Bits.putInt((byte[])lenBytes, (int)0, (int)bytes.length);
            bufOutput.write(lenBytes);
            bufOutput.write(bytes);
            bufOutput.flush();
            out.getFD().sync();
        }
    }

    /*
     * Exception decompiling
     */
    <T> T readFromFile(String rootPath, String fileName, Class<T> clazz) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static class TailIndex
    extends Persistence<Integer> {
        public TailIndex(Integer data) {
            super(data);
        }
    }

    static class Segment
    extends Persistence<List<Pair<byte[], byte[]>>> {
        public Segment(List<Pair<byte[], byte[]>> data) {
            super(data);
        }
    }

    static class LockerDB
    extends Persistence<Map<ByteArray, DistributedLock.Owner>> {
        public LockerDB(Map<ByteArray, DistributedLock.Owner> data) {
            super(data);
        }
    }

    static class FencingKeyDB
    extends Persistence<Map<ByteArray, Long>> {
        public FencingKeyDB(Map<ByteArray, Long> data) {
            super(data);
        }
    }

    static class SequenceDB
    extends Persistence<Map<ByteArray, Long>> {
        public SequenceDB(Map<ByteArray, Long> data) {
            super(data);
        }
    }

    static class Persistence<T> {
        private final T data;

        public Persistence(T data) {
            this.data = data;
        }

        public T data() {
            return this.data;
        }
    }
}

