/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  The ASF licenses this file to You
 * under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.  For additional information regarding
 * copyright in this work, please see the NOTICE file in the top level
 * directory of this distribution.
 */

package org.apache.roller.weblogger.ui.struts2.util;


/**
 * A simple object to maintain a key/value pair.  Normally used within a List called by the UI
 * when it is desired to specify a specific, not necessarily alphabetical, ordering of UI
 * select or radio button values.  Addresses the weakness of most Map<K,V> implementations
 * which lack an easily ability to maintain non-standard orderings.
 */
public class KeyValueObject {
    
    private Object key = null;
    private Object value = null;
    
    
    public KeyValueObject() {}
    
    public KeyValueObject(Object key, Object value) {
        this.setKey(key);
        this.setValue(value);
    }

    public Object getKey() {
        return key;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public Object getValue() {
        return value;
    }

    public void setValue(Object value) {
        this.value = value;
    }
    
}
