/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.util.internal.shared.SetOfUnknownSize;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;

final class OperationMethodSet
extends SetOfUnknownSize<OperationMethod> {
    private final Class<? extends SingleOperation> type;
    private final Iterable<? extends OperationMethod> methods;
    private Iterator<? extends OperationMethod> methodIterator;
    private final List<OperationMethod> cachedMethods;

    OperationMethodSet(Class<? extends SingleOperation> type, Iterable<? extends OperationMethod> methods) {
        this.type = type;
        this.methods = methods;
        this.cachedMethods = new ArrayList<OperationMethod>();
        this.reset();
    }

    final synchronized void reset() {
        assert (Thread.holdsLock(this.methods));
        this.cachedMethods.clear();
        this.methodIterator = this.methods.iterator();
        if (!this.methodIterator.hasNext()) {
            this.methodIterator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean transfer() {
        Class<? extends SingleOperation> c;
        OperationMethod method;
        assert (Thread.holdsLock((Object)this));
        Iterable<? extends OperationMethod> iterable = this.methods;
        synchronized (iterable) {
            method = this.methodIterator.next();
            if (!this.methodIterator.hasNext()) {
                this.methodIterator = null;
            }
        }
        if (method instanceof DefaultOperationMethod && (c = ((DefaultOperationMethod)method).getOperationType()) != null && !this.type.isAssignableFrom(c)) {
            return false;
        }
        if (!(this.methods instanceof ServiceLoader) && !(this.methods instanceof Set) && this.cachedMethods.contains(method)) {
            return false;
        }
        return this.cachedMethods.add(method);
    }

    public synchronized boolean isEmpty() {
        if (!this.cachedMethods.isEmpty()) {
            return false;
        }
        while (this.methodIterator != null) {
            if (!this.transfer()) continue;
            return false;
        }
        return true;
    }

    public synchronized int size() {
        while (this.methodIterator != null) {
            this.transfer();
        }
        return this.cachedMethods.size();
    }

    protected synchronized boolean isSizeKnown() {
        return this.methodIterator == null;
    }

    final synchronized boolean hasNext(int index) {
        if (index >= this.cachedMethods.size()) {
            do {
                if (this.methodIterator != null) continue;
                return false;
            } while (!this.transfer());
        }
        return true;
    }

    final synchronized OperationMethod next(int index) {
        if (index >= this.cachedMethods.size()) {
            do {
                if (this.methodIterator != null) continue;
                throw new NoSuchElementException();
            } while (!this.transfer());
        }
        return this.cachedMethods.get(index);
    }

    public Iterator<OperationMethod> iterator() {
        return new Iterator<OperationMethod>(){
            private int cursor;

            @Override
            public boolean hasNext() {
                return OperationMethodSet.this.hasNext(this.cursor);
            }

            @Override
            public OperationMethod next() {
                return OperationMethodSet.this.next(this.cursor++);
            }
        };
    }

    public boolean contains(Object object) {
        Class<? extends SingleOperation> c;
        if (object instanceof DefaultOperationMethod ? (c = ((DefaultOperationMethod)object).getOperationType()) != null && !this.type.isAssignableFrom(c) : !(object instanceof OperationMethod)) {
            return false;
        }
        return super.contains(object);
    }
}

