/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper.j2d;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.function.BiPredicate;
import org.apache.sis.filter.sqlmm.SQLMM;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.geometry.wrapper.j2d.Factory;
import org.apache.sis.geometry.wrapper.j2d.Wrapper;
import org.apache.sis.pending.geoapi.filter.SpatialOperatorName;
import org.opengis.geometry.DirectPosition;

final class PointWrapper
extends GeometryWrapper {
    final Point2D point;
    private static final BiPredicate<PointWrapper, Object>[] PREDICATES = new BiPredicate[SpatialOperatorName.OVERLAPS.ordinal() + 1];

    PointWrapper(Point2D point) {
        this.point = point;
    }

    protected Geometries<Shape> factory() {
        return Factory.INSTANCE;
    }

    @Override
    protected Object implementation() {
        return this.point;
    }

    @Override
    public GeneralEnvelope getEnvelope() {
        GeneralEnvelope env = this.createEnvelope();
        double x = this.point.getX();
        double y = this.point.getY();
        env.setRange(0, x, y);
        env.setRange(1, x, y);
        return env;
    }

    @Override
    public DirectPosition getCentroid() {
        return new DirectPosition2D(this.getCoordinateReferenceSystem(), this.point.getX(), this.point.getY());
    }

    @Override
    public double[] getPointCoordinates() {
        return new double[]{this.point.getX(), this.point.getY()};
    }

    @Override
    public double[] getAllCoordinates() {
        return this.getPointCoordinates();
    }

    @Override
    public Shape mergePolylines(Iterator<?> polylines) {
        return Wrapper.mergePolylines(this.point, polylines);
    }

    @Override
    protected boolean predicateSameCRS(SpatialOperatorName type, GeometryWrapper other) {
        BiPredicate<PointWrapper, Object> op;
        int ordinal = type.ordinal();
        if (ordinal >= 0 && ordinal < PREDICATES.length && (op = PREDICATES[ordinal]) != null) {
            return op.test(this, other);
        }
        return super.predicateSameCRS(type, other);
    }

    @Override
    protected Object operationSameCRS(SQLMM operation, GeometryWrapper other, Object argument) {
        switch (operation) {
            case ST_Dimension: 
            case ST_CoordDim: {
                return 2;
            }
            case ST_Is3D: 
            case ST_IsMeasured: {
                return Boolean.FALSE;
            }
            case ST_Centroid: {
                return this.point.clone();
            }
            case ST_Envelope: {
                return this.getEnvelope();
            }
            case ST_Boundary: {
                if (this.point instanceof Point) {
                    Point p = (Point)this.point;
                    Rectangle r = new Rectangle();
                    r.x = p.x;
                    r.y = p.y;
                    return r;
                }
                if (this.point instanceof Point2D.Float) {
                    Point2D.Float p = (Point2D.Float)this.point;
                    Rectangle2D.Float r = new Rectangle2D.Float();
                    r.x = p.x;
                    r.y = p.y;
                    return r;
                }
                Rectangle2D.Double r = new Rectangle2D.Double();
                r.x = this.point.getX();
                r.y = this.point.getY();
                return r;
            }
            case ST_Overlaps: 
            case ST_Within: {
                return this.within(other);
            }
            case ST_Intersects: {
                return this.intersect(other);
            }
            case ST_Disjoint: {
                return !this.intersect(other);
            }
            case ST_Contains: 
            case ST_Equals: {
                return this.equal(other);
            }
        }
        return super.operationSameCRS(operation, other, argument);
    }

    private boolean equal(Object wrapper) {
        if (wrapper instanceof PointWrapper) {
            Point2D p = ((PointWrapper)wrapper).point;
            return Double.doubleToLongBits(this.point.getX()) == Double.doubleToLongBits(p.getX()) && Double.doubleToLongBits(this.point.getY()) == Double.doubleToLongBits(p.getY());
        }
        return false;
    }

    private boolean within(Object wrapper) {
        return wrapper instanceof Wrapper && ((Wrapper)wrapper).geometry.contains(this.point);
    }

    private boolean intersect(Object wrapper) {
        if (wrapper instanceof PointWrapper) {
            return this.point.equals(((PointWrapper)wrapper).point);
        }
        return this.within(wrapper);
    }

    @Override
    public String formatWKT(double flatness) {
        return this.getCentroid().toString();
    }

    static {
        BiPredicate<PointWrapper, Object> biPredicate = PointWrapper::intersect;
        PointWrapper.PREDICATES[SpatialOperatorName.INTERSECTS.ordinal()] = biPredicate;
        PointWrapper.PREDICATES[SpatialOperatorName.OVERLAPS.ordinal()] = biPredicate;
        PointWrapper.PREDICATES[SpatialOperatorName.BBOX.ordinal()] = biPredicate;
        PointWrapper.PREDICATES[SpatialOperatorName.WITHIN.ordinal()] = PointWrapper::within;
        BiPredicate<PointWrapper, Object> biPredicate2 = PointWrapper::equal;
        PointWrapper.PREDICATES[SpatialOperatorName.EQUALS.ordinal()] = biPredicate2;
        PointWrapper.PREDICATES[SpatialOperatorName.CONTAINS.ordinal()] = biPredicate2;
        PointWrapper.PREDICATES[SpatialOperatorName.DISJOINT.ordinal()] = (w, o) -> !w.intersect(o);
    }
}

