/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.html;

import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.sling.commons.html.HtmlElement;
import org.apache.sling.commons.html.HtmlElementType;
import org.apache.sling.commons.html.impl.parser.ParseException;
import org.apache.sling.commons.html.impl.parser.TagParser;

public class HtmlIterator
implements Iterator<HtmlElement> {
    private HtmlElement current;
    boolean eof = false;
    private TagParser parser;

    public HtmlIterator(InputStream is) {
        this.parser = new TagParser(is);
    }

    public HtmlIterator(InputStream is, String encoding) {
        this.parser = new TagParser(is, encoding);
    }

    @Override
    public boolean hasNext() {
        if (this.current == null && !this.eof) {
            return this.seek();
        }
        return !this.eof;
    }

    @Override
    public HtmlElement next() {
        if (this.current == null && !this.eof) {
            this.seek();
        }
        if (this.current == null || this.eof) {
            throw new NoSuchElementException();
        }
        HtmlElement response = this.current;
        this.current = null;
        return response;
    }

    private boolean seek() {
        if (this.eof) {
            return false;
        }
        try {
            this.current = this.parser.element();
            this.eof = this.current.getType() == HtmlElementType.EOF;
            return !this.eof;
        }
        catch (ParseException parseException) {
            return false;
        }
    }
}

