/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.commons;

import java.util.Collection;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.DiscoveryService;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.TopologyView;
import org.apache.sling.discovery.base.commons.ClusterViewService;
import org.apache.sling.discovery.base.commons.DefaultTopologyView;
import org.apache.sling.discovery.base.commons.UndefinedClusterViewException;
import org.apache.sling.discovery.base.connectors.announcement.AnnouncementRegistry;
import org.apache.sling.discovery.commons.providers.spi.LocalClusterView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDiscoveryService
implements DiscoveryService {
    private static final Logger logger = LoggerFactory.getLogger(BaseDiscoveryService.class);
    private DefaultTopologyView oldView;

    protected abstract ClusterViewService getClusterViewService();

    protected abstract AnnouncementRegistry getAnnouncementRegistry();

    protected abstract void handleIsolatedFromTopology();

    protected DefaultTopologyView getOldView() {
        return this.oldView;
    }

    protected void setOldView(DefaultTopologyView view) {
        if (view == null) {
            throw new IllegalArgumentException("view must not be null");
        }
        logger.debug("setOldView: oldView is now: {}", (Object)this.oldView);
        this.oldView = view;
    }

    public TopologyView getTopology() {
        DefaultTopologyView topology = new DefaultTopologyView();
        LocalClusterView localClusterView = null;
        try {
            ClusterViewService clusterViewService = this.getClusterViewService();
            if (clusterViewService == null) {
                throw new UndefinedClusterViewException(UndefinedClusterViewException.Reason.REPOSITORY_EXCEPTION, "no ClusterViewService available at the moment");
            }
            localClusterView = clusterViewService.getLocalClusterView();
            topology.setLocalClusterView(localClusterView);
        }
        catch (UndefinedClusterViewException e) {
            logger.info("getTopology: undefined cluster view: " + (Object)((Object)e.getReason()) + "] " + e);
            this.oldView.setNotCurrent();
            if (e.getReason() == UndefinedClusterViewException.Reason.ISOLATED_FROM_TOPOLOGY) {
                this.handleIsolatedFromTopology();
            }
            return this.oldView;
        }
        Collection<InstanceDescription> attachedInstances = this.getAnnouncementRegistry().listInstances((ClusterView)localClusterView);
        topology.addInstances(attachedInstances);
        return topology;
    }
}

