/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.shared;

import java.io.Closeable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class JMXRegistration
implements Closeable {
    public static final String DOMAIN = "org.apache.sling.distribution";
    private ObjectName name;

    public JMXRegistration(Object bean, String type, String id) {
        try {
            this.name = JMXRegistration.nameOf(type, id);
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            if (!server.isRegistered(this.name)) {
                server.registerMBean(bean, this.name);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static ObjectName nameOf(String type, String id) throws MalformedObjectNameException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("type", type);
        props.put("id", id);
        return ObjectName.getInstance(DOMAIN, props);
    }

    @Override
    public void close() throws IOException {
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.name);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

