/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.ParsingNameResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.namespace.SessionNamespaceResolver;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.vault.util.DocViewProperty2;
import org.apache.jackrabbit.vault.util.DocViewProperty2Comparator;
import org.jetbrains.annotations.NotNull;

public class DocViewNode2 {
    @NotNull
    private final Name name;
    private final int index;
    @NotNull
    private final Map<Name, DocViewProperty2> properties;

    public DocViewNode2(@NotNull Name name, @NotNull Collection<DocViewProperty2> properties) {
        this(name, 0, properties);
    }

    public DocViewNode2(@NotNull Name name, int index, @NotNull Collection<DocViewProperty2> properties) {
        Objects.requireNonNull(name, "name must not be null");
        this.name = name;
        if (index < 0) {
            throw new IllegalArgumentException("index must be non-negative");
        }
        this.index = index;
        Objects.requireNonNull(properties, "properties must not be null");
        this.properties = properties.stream().collect(Collectors.toMap(DocViewProperty2::getName, Function.identity(), (existing, replacement) -> existing, LinkedHashMap::new));
    }

    @NotNull
    public DocViewNode2 cloneWithDifferentProperties(@NotNull Collection<DocViewProperty2> properties) {
        return new DocViewNode2(this.name, this.index, properties);
    }

    @NotNull
    public static DocViewNode2 fromNode(@NotNull Node node, boolean isRoot, boolean useBinaryReferences) throws RepositoryException {
        return DocViewNode2.fromNode(node, isRoot, JcrUtils.in((Iterator)node.getProperties()), useBinaryReferences);
    }

    @NotNull
    public static DocViewNode2 fromNode(@NotNull Node node, boolean isRoot, @NotNull Iterable<Property> properties, boolean useBinaryReferences) throws RepositoryException {
        ParsingNameResolver nameResolver = new ParsingNameResolver(NameFactoryImpl.getInstance(), (NamespaceResolver)new SessionNamespaceResolver(node.getSession()));
        Name nodeName = isRoot ? NameConstants.JCR_ROOT : nameResolver.getQName(node.getName());
        ArrayList<DocViewProperty2> docViewProps = new ArrayList<DocViewProperty2>();
        for (Property property : properties) {
            Name propertyName = nameResolver.getQName(property.getName());
            boolean sort = propertyName.equals(NameConstants.JCR_MIXINTYPES);
            docViewProps.add(DocViewProperty2.fromProperty(property, sort, useBinaryReferences));
        }
        int index = node.getIndex();
        if (index == 1) {
            index = 0;
        }
        return new DocViewNode2(nodeName, index, docViewProps);
    }

    @NotNull
    public Name getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    @NotNull
    public Name getSnsAwareName() {
        if (this.index > 0) {
            return NameFactoryImpl.getInstance().create(this.name.getNamespaceURI(), this.name.getLocalName() + "[" + this.getIndex() + "]");
        }
        return this.name;
    }

    @NotNull
    public Collection<DocViewProperty2> getProperties() {
        return Collections.unmodifiableCollection(this.properties.values());
    }

    @NotNull
    public Optional<DocViewProperty2> getProperty(Name name) {
        return Optional.ofNullable(this.properties.get(name));
    }

    public boolean hasProperty(Name name) {
        return this.properties.containsKey(name);
    }

    @NotNull
    public Collection<String> getPropertyValues(@NotNull Name name) {
        DocViewProperty2 prop = this.properties.get(name);
        return prop == null ? Collections.emptyList() : prop.getStringValues();
    }

    @NotNull
    public Optional<String> getPropertyValue(@NotNull Name name) {
        DocViewProperty2 prop = this.properties.get(name);
        if (prop == null) {
            return Optional.empty();
        }
        return prop.getStringValue();
    }

    @NotNull
    public Optional<String> getPrimaryType() {
        return this.getPropertyValue(NameConstants.JCR_PRIMARYTYPE);
    }

    @NotNull
    public Collection<String> getMixinTypes() {
        return this.getPropertyValues(NameConstants.JCR_MIXINTYPES);
    }

    @NotNull
    public Optional<String> getIdentifier() {
        return this.getPropertyValue(NameConstants.JCR_UUID);
    }

    public String toString() {
        return "DocViewNode2 [" + (this.name != null ? "name=" + this.name + ", " : "") + "index=" + this.index + ", " + (this.properties != null ? "properties=" + this.properties : "") + "]";
    }

    public int hashCode() {
        return Objects.hash(this.index, this.name, this.properties);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocViewNode2 other = (DocViewNode2)obj;
        return this.index == other.index && DocViewNode2.areNamesEqual(this.name, other.name) && Objects.equals(this.properties, other.properties);
    }

    static boolean areNamesEqual(@NotNull Name name, @NotNull Name otherName) {
        return Objects.equals(name.getLocalName(), otherName.getLocalName()) && Objects.equals(name.getNamespaceURI(), otherName.getNamespaceURI());
    }

    public void writeStart(@NotNull XMLStreamWriter writer, @NotNull NamespaceResolver nsResolver, @NotNull Iterable<String> namespacePrefixes) throws NamespaceException, XMLStreamException {
        TreeSet<DocViewProperty2> props = new TreeSet<DocViewProperty2>(new DocViewProperty2Comparator(nsResolver));
        props.addAll(this.properties.values());
        String namespaceUri = this.getName().getNamespaceURI();
        String localName = this.getName().getLocalName();
        if (this.getIndex() > 1) {
            localName = localName + "[" + this.getIndex() + "]";
        }
        String encodedLocalName = ISO9075.encode((String)localName);
        if (namespaceUri.length() > 0) {
            writer.writeStartElement(nsResolver.getPrefix(namespaceUri), encodedLocalName, namespaceUri);
        } else {
            writer.writeStartElement(encodedLocalName);
        }
        for (String namespacePrefix : namespacePrefixes) {
            if ("xml".equals(namespacePrefix)) continue;
            writer.writeNamespace(namespacePrefix, nsResolver.getURI(namespacePrefix));
        }
        for (DocViewProperty2 prop : props) {
            String attributeLocalName = ISO9075.encode((String)prop.getName().getLocalName());
            String attributeNamespaceUri = prop.getName().getNamespaceURI();
            if (attributeNamespaceUri.length() > 0) {
                writer.writeAttribute(nsResolver.getPrefix(attributeNamespaceUri), attributeNamespaceUri, attributeLocalName, prop.formatValue());
                continue;
            }
            writer.writeAttribute(attributeLocalName, prop.formatValue());
        }
    }

    public static void writeEnd(@NotNull XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndElement();
    }
}

