/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factories.subsystems.impl;

import org.apache.sling.installer.api.tasks.ChangeStateTask;
import org.apache.sling.installer.api.tasks.InstallTask;
import org.apache.sling.installer.api.tasks.InstallationContext;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.api.tasks.TaskResource;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.osgi.service.subsystem.Subsystem;

public class StartSubsystemTask
extends InstallTask {
    private static final String INSTALL_ORDER = "55-";
    private final Subsystem subsystem;

    public StartSubsystemTask(TaskResourceGroup grp, Subsystem system) {
        super(grp);
        this.subsystem = system;
    }

    public void execute(InstallationContext ctx) {
        TaskResource tr = this.getResource();
        ctx.log("Starting subsystem from {}", new Object[]{tr});
        this.subsystem.start();
        ctx.addTaskToCurrentCycle((InstallTask)new ChangeStateTask(this.getResourceGroup(), ResourceState.INSTALLED));
        ctx.log("Started subsystem {}", new Object[]{this.subsystem});
    }

    public String getSortKey() {
        return INSTALL_ORDER + this.getResource().getURL();
    }
}

