/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factories.subsystems.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.sling.installer.api.tasks.ChangeStateTask;
import org.apache.sling.installer.api.tasks.InstallTask;
import org.apache.sling.installer.api.tasks.InstallTaskFactory;
import org.apache.sling.installer.api.tasks.RegisteredResource;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.api.tasks.ResourceTransformer;
import org.apache.sling.installer.api.tasks.TaskResource;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.apache.sling.installer.api.tasks.TransformationResult;
import org.apache.sling.installer.factories.subsystems.impl.InstallSubsystemTask;
import org.apache.sling.installer.factories.subsystems.impl.StartSubsystemTask;
import org.apache.sling.installer.factories.subsystems.impl.UninstallSubsystemTask;
import org.apache.sling.installer.factories.subsystems.impl.UpdateSubsystemTask;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.subsystem.Subsystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubsystemInstaller
implements ResourceTransformer,
InstallTaskFactory {
    private static final String TYPE_SUBSYSTEM = "esa";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Subsystem rootSubsystem;
    private final BundleContext bundleContext;
    private static final String MAVEN_SNAPSHOT_MARKER = "SNAPSHOT";

    public SubsystemInstaller(Subsystem root, BundleContext bundleContext) {
        this.rootSubsystem = root;
        this.bundleContext = bundleContext;
    }

    public TransformationResult[] transform(RegisteredResource resource) {
        if (resource.getType().equals("file") && resource.getURL().endsWith(".esa")) {
            this.logger.info("Found potential subsystem resource {}", (Object)resource);
            SubsystemInfo headers = this.readSubsystemHeaders(resource);
            if (headers != null) {
                boolean validVersion = true;
                try {
                    new Version(headers.version);
                }
                catch (IllegalArgumentException iae) {
                    this.logger.info("Rejecting subsystem {} from {} due to invalid version information: {}.", new Object[]{headers.symbolicName, resource, headers.version});
                    validVersion = false;
                }
                if (validVersion) {
                    HashMap<String, String> attr = new HashMap<String, String>();
                    attr.put("Subsystem-SymbolicName", headers.symbolicName);
                    attr.put("Subsystem-Version", headers.version);
                    TransformationResult tr = new TransformationResult();
                    tr.setId(headers.symbolicName);
                    tr.setResourceType(TYPE_SUBSYSTEM);
                    tr.setAttributes(attr);
                    tr.setVersion(new Version(headers.version));
                    return new TransformationResult[]{tr};
                }
            } else {
                this.logger.info("Subsystem resource does not have required headers.");
            }
        }
        return null;
    }

    private SubsystemInfo checkResource(TaskResourceGroup toActivate) {
        TaskResource rsrc = toActivate.getActiveResource();
        SubsystemInfo result = null;
        String symbolicName = (String)rsrc.getAttribute("Subsystem-SymbolicName");
        if (symbolicName == null) {
            this.logger.error("Subsystem resource is missing symbolic name {}", (Object)rsrc);
        } else {
            String version = (String)rsrc.getAttribute("Subsystem-Version");
            if (version == null) {
                this.logger.error("Subsystem resource is missing version {}", (Object)rsrc);
            } else {
                boolean validVersion = true;
                try {
                    new Version(version);
                }
                catch (IllegalArgumentException iae) {
                    this.logger.info("Rejecting subsystem {} from {} due to invalid version information: {}.", new Object[]{symbolicName, rsrc, version});
                    validVersion = false;
                }
                if (validVersion) {
                    result = new SubsystemInfo();
                    result.symbolicName = symbolicName;
                    result.version = version;
                }
            }
        }
        return result;
    }

    private ServiceReference<Subsystem> getSubsystemReference(String symbolicName) {
        ServiceReference ref = null;
        try {
            Collection refs = this.bundleContext.getServiceReferences(Subsystem.class, "(subsystem.symbolicName=" + symbolicName + ")");
            if (refs.size() > 0) {
                ref = (ServiceReference)refs.iterator().next();
            }
        }
        catch (InvalidSyntaxException e) {
            this.logger.error("Problem searching for subsystem with symbolic name " + symbolicName, (Throwable)e);
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstallTask createTask(TaskResourceGroup toActivate) {
        Object result;
        TaskResource rsrc = toActivate.getActiveResource();
        if (rsrc.getType().equals(TYPE_SUBSYSTEM)) {
            SubsystemInfo info = this.checkResource(toActivate);
            if (info == null) {
                result = new ChangeStateTask(toActivate, ResourceState.IGNORED);
            } else {
                ServiceReference<Subsystem> ref = this.getSubsystemReference(info.symbolicName);
                Subsystem currentSubsystem = ref != null ? (Subsystem)this.bundleContext.getService(ref) : null;
                try {
                    Version oldVersion;
                    Version newVersion = new Version(info.version);
                    Version version = oldVersion = ref == null ? null : (Version)ref.getProperty("subsystem.version");
                    if (rsrc.getState() == ResourceState.INSTALL) {
                        if (oldVersion != null) {
                            int compare = oldVersion.compareTo(newVersion);
                            if (compare < 0) {
                                result = new UpdateSubsystemTask(toActivate, this.bundleContext, ref, this.rootSubsystem);
                            }
                            if (compare == 0 && SubsystemInstaller.isSnapshot(newVersion)) {
                                result = new UpdateSubsystemTask(toActivate, this.bundleContext, ref, this.rootSubsystem);
                            }
                            if (compare == 0 && currentSubsystem != null && currentSubsystem.getState() != Subsystem.State.ACTIVE) {
                                result = new StartSubsystemTask(toActivate, currentSubsystem);
                            }
                            this.logger.info("{} is not installed, subsystem with same or higher version is already installed: {}", (Object)info, (Object)newVersion);
                            result = new ChangeStateTask(toActivate, ResourceState.IGNORED);
                        }
                        result = new InstallSubsystemTask(toActivate, this.rootSubsystem);
                    }
                    if (rsrc.getState() == ResourceState.UNINSTALL) {
                        if (oldVersion == null) {
                            this.logger.error("Nothing to uninstall. {} is currently not installed.", (Object)info);
                            result = new ChangeStateTask(toActivate, ResourceState.IGNORED);
                        }
                        int compare = oldVersion.compareTo(newVersion);
                        if (compare == 0) {
                            result = new UninstallSubsystemTask(toActivate, this.bundleContext, ref);
                        }
                        this.logger.error("Nothing to uninstall. {} is currently not installed, different version is installed {}", (Object)info, (Object)oldVersion);
                        result = new ChangeStateTask(toActivate, ResourceState.IGNORED);
                    }
                    result = null;
                }
                finally {
                    if (currentSubsystem != null) {
                        this.bundleContext.ungetService(ref);
                    }
                }
            }
        } else {
            result = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest getManifest(RegisteredResource rsrc, Logger logger) throws IOException {
        InputStream ins = rsrc.getInputStream();
        Manifest result = null;
        if (ins != null) {
            ZipInputStream jis = null;
            try {
                ZipEntry entry;
                jis = new ZipInputStream(ins);
                while ((entry = jis.getNextEntry()) != null) {
                    if (!entry.getName().equals("OSGI-INF/SUBSYSTEM.MF")) continue;
                    result = new Manifest(jis);
                }
            }
            finally {
                if (jis != null) {
                    try {
                        jis.close();
                    }
                    catch (IOException ignore) {}
                } else {
                    try {
                        ins.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        return result;
    }

    private SubsystemInfo readSubsystemHeaders(RegisteredResource resource) {
        try {
            String sn;
            Manifest m = SubsystemInstaller.getManifest(resource, this.logger);
            if (m != null && (sn = m.getMainAttributes().getValue("Subsystem-SymbolicName")) != null) {
                String v = m.getMainAttributes().getValue("Subsystem-Version");
                int paramPos = sn.indexOf(59);
                String symbolicName = paramPos == -1 ? sn : sn.substring(0, paramPos);
                SubsystemInfo headers = new SubsystemInfo();
                headers.symbolicName = symbolicName;
                headers.version = v;
                if (headers.version == null) {
                    headers.version = "0.0.0.0";
                }
                return headers;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isSnapshot(Version v) {
        return v.toString().indexOf(MAVEN_SNAPSHOT_MARKER) >= 0;
    }

    public static final class SubsystemInfo {
        public String symbolicName;
        public String version;

        public String toString() {
            return "Subsystem[symbolicName=" + this.symbolicName + ", version=" + this.version + "]";
        }
    }
}

