/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.prefs.impl;

import java.util.ArrayList;
import java.util.Map;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.prefs.BackingStore;
import org.apache.felix.prefs.BackingStoreManager;
import org.apache.felix.prefs.PreferencesDescription;
import org.apache.felix.prefs.PreferencesImpl;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.prefs.BackingStoreException;

public class JcrBackingStore
implements BackingStore {
    protected static final String NS_URI = "http://osgi.org/service/prefs/Preferences/1.1";
    protected static final String PATH_PROPERTY = "sling.preferences.jcr.path";
    protected static final String NAMESPACE_PROPERTY = "sling.preferences.jcr.namespace";
    protected static final String NAMESPACE_PREFIX_PROPERTY = "sling.preferences.jcr.prefix";
    protected SlingRepository repository;
    protected boolean initialized = false;
    protected String rootNodePath = "/preferences";
    protected String namespacePrefix = "osgipref";
    protected String namespacePrefixSep = this.namespacePrefix + ':';
    protected String namespace = "http://osgi.org/service/prefs/Preferences/1.1";

    protected Session getSession() throws RepositoryException {
        return this.repository.loginAdministrative(null);
    }

    protected void activate(ComponentContext componentContext) {
        Object value = componentContext.getProperties().get(PATH_PROPERTY);
        if (value != null) {
            this.rootNodePath = value.toString();
        }
        if ((value = componentContext.getProperties().get(NAMESPACE_PROPERTY)) != null) {
            this.namespace = value.toString();
        }
        if ((value = componentContext.getProperties().get(NAMESPACE_PREFIX_PROPERTY)) != null) {
            this.namespacePrefix = value.toString();
            this.namespacePrefixSep = this.namespacePrefix + ':';
        }
    }

    protected Session checkInitialized() {
        if (!this.initialized) {
            this.initRepository();
        }
        try {
            return this.repository.loginAdministrative(null);
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unable to login and create a new session.", e);
        }
    }

    protected void createNodePath(Node parent, String relPath) throws RepositoryException {
        String nodeName;
        int pos = relPath.indexOf(47);
        String string = nodeName = pos == -1 ? relPath : relPath.substring(0, pos);
        if (!parent.hasNode(nodeName)) {
            parent.addNode(nodeName, "nt:unstructured");
        }
        if (pos != -1) {
            this.createNodePath(parent.getNode(nodeName), relPath.substring(pos + 1));
        }
    }

    protected synchronized void initRepository() {
        if (!this.initialized) {
            Session session = null;
            try {
                session = this.repository.loginAdministrative(null);
                if (!session.itemExists(this.rootNodePath)) {
                    this.createNodePath(session.getRootNode(), this.rootNodePath.substring(1));
                    session.save();
                }
                try {
                    String prefix;
                    this.namespacePrefix = prefix = session.getWorkspace().getNamespaceRegistry().getPrefix(this.namespace);
                    this.namespacePrefixSep = prefix + ':';
                }
                catch (NamespaceException ne) {
                    session.getWorkspace().getNamespaceRegistry().registerNamespace(this.namespacePrefix, this.namespace);
                }
            }
            catch (RepositoryException e) {
                throw new RuntimeException("Unable to get root node or to create new root node.", e);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
            this.initialized = true;
        }
    }

    protected String getNodePath(PreferencesImpl prefs) {
        PreferencesDescription desc = prefs.getDescription();
        StringBuilder buffer = new StringBuilder(this.rootNodePath);
        buffer.append('/');
        buffer.append(desc.getBundleId());
        buffer.append('/');
        if (desc.getIdentifier() != null) {
            buffer.append("users");
            buffer.append('/');
            buffer.append(desc.getIdentifier());
        } else {
            buffer.append("system");
        }
        buffer.append('/');
        buffer.append("preferences");
        String absPath = prefs.absolutePath();
        if (absPath.length() > 1) {
            buffer.append(absPath);
        }
        return buffer.toString();
    }

    protected String getNodePath(PreferencesDescription desc) {
        StringBuilder buffer = new StringBuilder(this.rootNodePath);
        buffer.append('/');
        buffer.append(desc.getBundleId());
        buffer.append('/');
        if (desc.getIdentifier() != null) {
            buffer.append("users");
            buffer.append('/');
            buffer.append(desc.getIdentifier());
        } else {
            buffer.append("system");
        }
        buffer.append('/');
        buffer.append("preferences");
        return buffer.toString();
    }

    protected void readPreferences(PreferencesImpl prefs, Session session, Node node) throws RepositoryException {
        PropertyIterator iterator = node.getProperties();
        while (iterator.hasNext()) {
            Property prop = iterator.nextProperty();
            if (!prop.getName().startsWith(this.namespacePrefixSep)) continue;
            prefs.getProperties().put(prop.getName(), prop.getString());
        }
    }

    protected void writePreferences(PreferencesImpl prefs, Session session) throws RepositoryException {
        String path = this.getNodePath(prefs);
        if (!session.itemExists(path)) {
            this.createNodePath(session.getRootNode(), path.substring(1));
        }
        Node node = (Node)session.getItem(path);
        Map properties = prefs.getProperties();
        for (String name : prefs.getChangeSet().getRemovedProperties()) {
            if (!node.hasProperty(this.namespacePrefixSep + name)) continue;
            node.getProperty(this.namespacePrefixSep + name).remove();
        }
        for (String name : prefs.getChangeSet().getChangedProperties()) {
            node.setProperty(this.namespacePrefixSep + name, (String)properties.get(name));
        }
        for (String name : prefs.getChangeSet().getRemovedChildren()) {
            if (!node.hasNode(name)) continue;
            node.getNode(name).remove();
        }
        session.save();
    }

    protected void readTree(PreferencesImpl prefs, Session session, Node node) throws RepositoryException {
        this.readPreferences(prefs, session, node);
        NodeIterator iterator = node.getNodes();
        while (iterator.hasNext()) {
            Node current = iterator.nextNode();
            PreferencesImpl impl = (PreferencesImpl)prefs.node(current.getName());
            this.readTree(impl, session, current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long[] availableBundles() {
        Session session = this.checkInitialized();
        Long[] result = new Long[]{};
        try {
            try {
                ArrayList<Long> bundleIds = new ArrayList<Long>();
                NodeIterator iterator = session.getRootNode().getNodes(this.rootNodePath);
                while (iterator.hasNext()) {
                    Node current = iterator.nextNode();
                    try {
                        Long id = Long.valueOf(current.getName());
                        bundleIds.add(id);
                    }
                    catch (NumberFormatException nfe) {}
                }
                result = bundleIds.toArray(new Long[bundleIds.size()]);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        finally {
            session.logout();
        }
        return result;
    }

    public PreferencesImpl load(BackingStoreManager manager, PreferencesDescription desc) throws BackingStoreException {
        Session session = this.checkInitialized();
        try {
            String path = this.getNodePath(desc);
            if (session.itemExists(path)) {
                PreferencesImpl root = new PreferencesImpl(desc, manager);
                this.readTree(root, session, (Node)session.getItem(path));
                PreferencesImpl preferencesImpl = root;
                return preferencesImpl;
            }
        }
        catch (RepositoryException re) {
            throw new BackingStoreException("Unable to load preferences.", (Throwable)re);
        }
        finally {
            session.logout();
        }
        return null;
    }

    public PreferencesImpl[] loadAll(BackingStoreManager manager, Long bundleId) throws BackingStoreException {
        Session session = this.checkInitialized();
        try {
            String userPath;
            ArrayList<PreferencesImpl> list = new ArrayList<PreferencesImpl>();
            PreferencesDescription systemDesc = new PreferencesDescription(bundleId, null);
            String systemPath = this.getNodePath(systemDesc);
            if (session.itemExists(systemPath)) {
                Node rootNode = (Node)session.getItem(systemPath);
                PreferencesImpl root = new PreferencesImpl(systemDesc, manager);
                this.readTree(root, session, rootNode);
            }
            if (session.itemExists(userPath = this.rootNodePath + '/' + bundleId + '/' + "users")) {
                NodeIterator iterator = ((Node)session.getItem(userPath)).getNodes();
                while (iterator.hasNext()) {
                    Node current = iterator.nextNode();
                    PreferencesDescription desc = new PreferencesDescription(bundleId, current.getName());
                    PreferencesImpl root = new PreferencesImpl(desc, manager);
                    this.readTree(root, session, current);
                    list.add(root);
                }
            }
            PreferencesImpl[] preferencesImplArray = list.toArray(new PreferencesImpl[list.size()]);
            return preferencesImplArray;
        }
        catch (RepositoryException re) {
            throw new BackingStoreException("Unable to load preferences.", (Throwable)re);
        }
        finally {
            session.logout();
        }
    }

    public void remove(Long bundleId) throws BackingStoreException {
        Session session = this.checkInitialized();
        try {
            String nodePath = this.rootNodePath + '/' + bundleId;
            if (session.itemExists(nodePath)) {
                Node node = ((Node)session).getNode(nodePath);
                Node parent = node.getParent();
                node.remove();
                parent.save();
            }
        }
        catch (RepositoryException re) {
            throw new BackingStoreException("Unable to remove preferences.", (Throwable)re);
        }
        finally {
            session.logout();
        }
    }

    public void store(PreferencesImpl prefs) throws BackingStoreException {
        Session session = this.checkInitialized();
        try {
            this.store(prefs, session);
        }
        catch (RepositoryException re) {
            throw new BackingStoreException("Unable to store preferences.", (Throwable)re);
        }
        finally {
            session.logout();
        }
    }

    protected void store(PreferencesImpl prefs, Session session) throws BackingStoreException, RepositoryException {
        if (prefs.getChangeSet().hasChanges()) {
            PreferencesImpl savedData = this.load(prefs.getBackingStoreManager(), prefs.getDescription());
            if (savedData != null) {
                PreferencesImpl n = savedData.getOrCreateNode(prefs.absolutePath());
                n.applyChanges(prefs);
                prefs = n;
            }
            this.writePreferences(prefs, session);
        }
        for (PreferencesImpl p : prefs.getChildren()) {
            this.store(p, session);
        }
    }

    public void update(PreferencesImpl prefs) throws BackingStoreException {
        PreferencesImpl root = this.load(prefs.getBackingStoreManager(), prefs.getDescription());
        if (root != null && root.nodeExists(prefs.absolutePath())) {
            PreferencesImpl updated = (PreferencesImpl)root.node(prefs.absolutePath());
            prefs.update(updated);
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

