/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.provisioning.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.sling.provisioning.model.ArtifactGroup;
import org.apache.sling.provisioning.model.Configuration;
import org.apache.sling.provisioning.model.ItemList;
import org.apache.sling.provisioning.model.KeyValueMap;
import org.apache.sling.provisioning.model.Traceable;

public class RunMode
extends Traceable
implements Comparable<RunMode> {
    private final String[] names;
    private final List<ArtifactGroup> groups = new ArrayList<ArtifactGroup>();
    private final ItemList<Configuration> configurations = new ItemList();
    private final KeyValueMap<String> settings = new KeyValueMap();

    public RunMode(String[] names) {
        this.names = RunMode.getSortedRunModesArray(names);
    }

    public static String[] getSortedRunModesArray(String[] names) {
        if (names != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (String m : names) {
                if (m == null || m.trim().isEmpty()) continue;
                list.add(m.trim());
            }
            if (list.size() > 0) {
                Collections.sort(list);
                return list.toArray(new String[list.size()]);
            }
        }
        return null;
    }

    public String[] getNames() {
        return this.names;
    }

    public boolean isActive(Set<String> activeRunModes) {
        boolean active = true;
        if (this.names != null) {
            for (String mode : this.names) {
                if (activeRunModes.contains(mode)) continue;
                active = false;
                break;
            }
        }
        return active;
    }

    public boolean isSpecial() {
        return this.names != null && this.names.length == 1 && this.names[0].startsWith(":");
    }

    public boolean isRunMode(String mode) {
        if (mode == null && this.names == null) {
            return true;
        }
        return mode != null && this.names != null && this.names.length == 1 && this.names[0].equals(mode);
    }

    public ArtifactGroup getArtifactGroup(int startLevel) {
        for (ArtifactGroup g : this.groups) {
            if (g.getStartLevel() != startLevel) continue;
            return g;
        }
        return null;
    }

    public ArtifactGroup getOrCreateArtifactGroup(int startLevel) {
        ArtifactGroup result = this.getArtifactGroup(startLevel);
        if (result == null) {
            result = new ArtifactGroup(startLevel);
            this.groups.add(result);
            Collections.sort(this.groups);
        }
        return result;
    }

    public Configuration getConfiguration(String pid) {
        for (Configuration c : this.configurations) {
            if (!pid.equals(c.getPid())) continue;
            return c;
        }
        return null;
    }

    public Configuration getConfiguration(String pid, String factoryPid) {
        Configuration found = null;
        for (Configuration current : this.configurations) {
            if (factoryPid == null) {
                if (current.getFactoryPid() != null || !current.getPid().equals(pid)) continue;
                found = current;
                break;
            }
            if (!factoryPid.equals(current.getFactoryPid()) || !current.getPid().equals(pid)) continue;
            found = current;
            break;
        }
        return found;
    }

    public Configuration getOrCreateConfiguration(String pid, String factoryPid) {
        Configuration found = this.getConfiguration(pid, factoryPid);
        if (found == null) {
            found = new Configuration(pid, factoryPid);
            this.configurations.add(found);
            Collections.sort(this.configurations.items);
        }
        return found;
    }

    public List<ArtifactGroup> getArtifactGroups() {
        return this.groups;
    }

    public ItemList<Configuration> getConfigurations() {
        return this.configurations;
    }

    public KeyValueMap<String> getSettings() {
        return this.settings;
    }

    @Override
    public int compareTo(RunMode o2) {
        if (this.names == null) {
            if (o2.names == null) {
                return 0;
            }
            return -1;
        }
        if (o2.names == null) {
            return 1;
        }
        return Arrays.toString(this.names).compareTo(Arrays.toString(o2.names));
    }

    @Override
    public String toString() {
        return "RunMode [names=" + Arrays.toString(this.names) + ", groups=" + this.groups + ", configurations=" + this.configurations + ", settings=" + this.settings + "]";
    }
}

