/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.impl.function;

import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.sling.query.api.SearchStrategy;
import org.apache.sling.query.api.internal.ElementToIteratorFunction;
import org.apache.sling.query.api.internal.IteratorToIteratorFunction;
import org.apache.sling.query.api.internal.Option;
import org.apache.sling.query.api.internal.TreeProvider;
import org.apache.sling.query.impl.function.DescendantFunction;
import org.apache.sling.query.impl.function.FilterFunction;
import org.apache.sling.query.impl.function.FindFunction;
import org.apache.sling.query.impl.function.IdentityFunction;
import org.apache.sling.query.impl.function.IteratorToIteratorFunctionWrapper;
import org.apache.sling.query.impl.iterator.EmptyElementFilter;
import org.apache.sling.query.impl.selector.SelectorFunction;
import org.apache.sling.query.impl.util.IteratorUtils;

public class HasFunction<T>
implements ElementToIteratorFunction<T> {
    private final IteratorToIteratorFunction<T> findFunction;
    private final IteratorToIteratorFunction<T> filter;

    private HasFunction(FindFunction<T> findFunction, IteratorToIteratorFunction<T> filter) {
        this.findFunction = new IteratorToIteratorFunctionWrapper(findFunction);
        this.filter = filter;
    }

    public HasFunction(String selectorString, SearchStrategy searchStrategy, TreeProvider<T> provider) {
        this(new FindFunction<T>(searchStrategy, provider, selectorString), new SelectorFunction<T>(selectorString, provider, searchStrategy));
    }

    public HasFunction(Predicate<T> predicate, SearchStrategy searchStrategy, TreeProvider<T> provider) {
        this(new FindFunction<T>(searchStrategy, provider, ""), new FilterFunction<T>(predicate));
    }

    public HasFunction(Iterable<T> iterable, TreeProvider<T> provider) {
        this.findFunction = new DescendantFunction<T>(iterable, provider);
        this.filter = new IdentityFunction();
    }

    @Override
    public Iterator<T> apply(T input) {
        Iterator iterator = IteratorUtils.singleElementIterator(Option.of(input, 0));
        iterator = (Iterator)this.findFunction.apply(iterator);
        if (new EmptyElementFilter(iterator = (Iterator)this.filter.apply(iterator)).hasNext()) {
            return IteratorUtils.singleElementIterator(input);
        }
        return IteratorUtils.emptyIterator();
    }
}

