/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.impl.resource.jcr.query;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.query.impl.resource.jcr.JcrOperator;
import org.apache.sling.query.impl.resource.jcr.JcrTypeResolver;
import org.apache.sling.query.impl.resource.jcr.query.Atomic;
import org.apache.sling.query.impl.resource.jcr.query.Formula;
import org.apache.sling.query.impl.resource.jcr.query.Term;
import org.apache.sling.query.impl.selector.parser.Attribute;
import org.apache.sling.query.impl.selector.parser.SelectorSegment;

public class JcrQueryBuilder {
    private final JcrTypeResolver typeResolver;

    public JcrQueryBuilder(JcrTypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public String buildQuery(List<SelectorSegment> segments, String rootPath) {
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM [");
        query.append(this.findPrimaryType(segments));
        query.append("]");
        query.append(" AS s");
        String conditionString = this.getConditionString(segments, rootPath);
        if (StringUtils.isNotBlank((CharSequence)conditionString)) {
            query.append(" WHERE ").append(conditionString);
        }
        return query.toString();
    }

    private String getConditionString(List<SelectorSegment> segments, String rootPath) {
        Formula formula = JcrQueryBuilder.prepareAlternativeConditions(segments);
        if (StringUtils.isNotBlank((CharSequence)rootPath) && !"/".equals(rootPath)) {
            ArrayList<Term> conditions = new ArrayList<Term>();
            conditions.add(new Atomic(String.format("ISDESCENDANTNODE('%s')", rootPath)));
            if (formula != null) {
                conditions.add(formula);
            }
            formula = new Formula(Formula.Operator.AND, conditions);
        }
        if (formula == null) {
            return null;
        }
        return formula.buildString();
    }

    private String findPrimaryType(List<SelectorSegment> segments) {
        String result = null;
        for (SelectorSegment s : segments) {
            String type = s.getType();
            if (!this.typeResolver.isJcrType(type)) continue;
            if (result == null) {
                result = type;
                continue;
            }
            if (this.typeResolver.isSubtype(type, result)) {
                result = type;
                continue;
            }
            if (this.typeResolver.isSubtype(result, type)) continue;
            result = "nt:base";
        }
        if (result == null) {
            result = "nt:base";
        }
        return result;
    }

    private static Formula prepareAlternativeConditions(List<SelectorSegment> segments) {
        ArrayList<Term> list = new ArrayList<Term>();
        for (SelectorSegment segment : segments) {
            Formula conditions = JcrQueryBuilder.prepareSegmentConditions(segment.getType(), segment.getName(), segment.getAttributes());
            if (conditions == null) continue;
            list.add(conditions);
        }
        if (list.isEmpty()) {
            return null;
        }
        return new Formula(Formula.Operator.OR, list);
    }

    private static Formula prepareSegmentConditions(String resourceType, String resourceName, List<Attribute> attributes) {
        ArrayList<Term> conditions = new ArrayList<Term>();
        if (StringUtils.isNotBlank((CharSequence)resourceType) && !StringUtils.contains((CharSequence)resourceType, (int)58)) {
            conditions.add(new Atomic(String.format("s.[sling:resourceType] = '%s'", resourceType)));
        }
        if (StringUtils.isNotBlank((CharSequence)resourceName)) {
            conditions.add(new Atomic(String.format("NAME(s) = '%s'", resourceName)));
        }
        if (attributes != null) {
            for (Attribute a : attributes) {
                String attributeCondition = JcrQueryBuilder.getAttributeCondition(a);
                if (!StringUtils.isNotBlank((CharSequence)attributeCondition)) continue;
                conditions.add(new Atomic(attributeCondition));
            }
        }
        if (conditions.isEmpty()) {
            return null;
        }
        return new Formula(Formula.Operator.AND, conditions);
    }

    private static String getAttributeCondition(Attribute attribute) {
        if (attribute.getKey().contains("/")) {
            return null;
        }
        JcrOperator operator = JcrOperator.getSelectorOperator(attribute.getOperator());
        String value = StringUtils.replace((String)attribute.getValue(), (String)"'", (String)"''");
        return operator.getJcrQueryFragment(attribute.getKey(), value);
    }
}

