/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.java.impl;

public class CompilerUtil {
    private static final String[] javaKeywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throws", "transient", "try", "void", "volatile", "while"};

    public static String mapSourcePath(String path) {
        String str = path.endsWith(".java") ? path.substring(0, path.length() - 5) : path;
        StringBuilder sb = new StringBuilder();
        int start = 0;
        for (int pos = 0; pos < str.length(); ++pos) {
            char c = str.charAt(pos);
            if (c != '/') continue;
            if (start != pos) {
                sb.append(CompilerUtil.makeJavaIdentifier(str.substring(start, pos)));
            }
            sb.append(c);
            start = pos + 1;
        }
        sb.append(CompilerUtil.makeJavaIdentifier(str.substring(start)));
        return sb.toString();
    }

    private static final String makeJavaIdentifier(String identifier) {
        StringBuilder modifiedIdentifier = new StringBuilder(identifier.length());
        if (!Character.isJavaIdentifierStart(identifier.charAt(0))) {
            modifiedIdentifier.append('_');
        }
        for (int i = 0; i < identifier.length(); ++i) {
            char ch = identifier.charAt(i);
            if (Character.isJavaIdentifierPart(ch) && ch != '_') {
                modifiedIdentifier.append(ch);
                continue;
            }
            if (ch == '.') {
                modifiedIdentifier.append('_');
                continue;
            }
            modifiedIdentifier.append(CompilerUtil.mangleChar(ch));
        }
        if (CompilerUtil.isJavaKeyword(modifiedIdentifier.toString())) {
            modifiedIdentifier.append('_');
        }
        return modifiedIdentifier.toString();
    }

    private static final String mangleChar(char ch) {
        char[] result = new char[]{'_', Character.forDigit(ch >> 12 & 0xF, 16), Character.forDigit(ch >> 8 & 0xF, 16), Character.forDigit(ch >> 4 & 0xF, 16), Character.forDigit(ch & 0xF, 16)};
        return new String(result);
    }

    private static boolean isJavaKeyword(String key) {
        int i = 0;
        int j = javaKeywords.length;
        while (i < j) {
            int k = (i + j) / 2;
            int result = javaKeywords[k].compareTo(key);
            if (result == 0) {
                return true;
            }
            if (result < 0) {
                i = k + 1;
                continue;
            }
            j = k;
        }
        return false;
    }
}

